//  Copyright 2024 Google LLC

//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at

//     https://www.apache.org/licenses/LICENSE-2.0

//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v3.21.12
// source: plugin_comm.proto

package plugin_comm

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.62.0 or later.
const _ = grpc.SupportPackageIsVersion8

const (
	GuestAgentPlugin_Start_FullMethodName     = "/plugin_comm.GuestAgentPlugin/Start"
	GuestAgentPlugin_Stop_FullMethodName      = "/plugin_comm.GuestAgentPlugin/Stop"
	GuestAgentPlugin_GetStatus_FullMethodName = "/plugin_comm.GuestAgentPlugin/GetStatus"
	GuestAgentPlugin_Apply_FullMethodName     = "/plugin_comm.GuestAgentPlugin/Apply"
)

// GuestAgentPluginClient is the client API for GuestAgentPlugin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GuestAgentPluginClient interface {
	// Start command - request to start the plugin.
	Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error)
	// Stop command - request to stop and exit the plugin process.
	Stop(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error)
	// Status command - request to get current plugin status.
	GetStatus(ctx context.Context, in *GetStatusRequest, opts ...grpc.CallOption) (*Status, error)
	// Apply command - request to apply config or some work received for plugin.
	Apply(ctx context.Context, in *ApplyRequest, opts ...grpc.CallOption) (*ApplyResponse, error)
}

type guestAgentPluginClient struct {
	cc grpc.ClientConnInterface
}

func NewGuestAgentPluginClient(cc grpc.ClientConnInterface) GuestAgentPluginClient {
	return &guestAgentPluginClient{cc}
}

func (c *guestAgentPluginClient) Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StartResponse)
	err := c.cc.Invoke(ctx, GuestAgentPlugin_Start_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guestAgentPluginClient) Stop(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StopResponse)
	err := c.cc.Invoke(ctx, GuestAgentPlugin_Stop_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guestAgentPluginClient) GetStatus(ctx context.Context, in *GetStatusRequest, opts ...grpc.CallOption) (*Status, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Status)
	err := c.cc.Invoke(ctx, GuestAgentPlugin_GetStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *guestAgentPluginClient) Apply(ctx context.Context, in *ApplyRequest, opts ...grpc.CallOption) (*ApplyResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ApplyResponse)
	err := c.cc.Invoke(ctx, GuestAgentPlugin_Apply_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GuestAgentPluginServer is the server API for GuestAgentPlugin service.
// All implementations must embed UnimplementedGuestAgentPluginServer
// for forward compatibility
type GuestAgentPluginServer interface {
	// Start command - request to start the plugin.
	Start(context.Context, *StartRequest) (*StartResponse, error)
	// Stop command - request to stop and exit the plugin process.
	Stop(context.Context, *StopRequest) (*StopResponse, error)
	// Status command - request to get current plugin status.
	GetStatus(context.Context, *GetStatusRequest) (*Status, error)
	// Apply command - request to apply config or some work received for plugin.
	Apply(context.Context, *ApplyRequest) (*ApplyResponse, error)
	mustEmbedUnimplementedGuestAgentPluginServer()
}

// UnimplementedGuestAgentPluginServer must be embedded to have forward compatible implementations.
type UnimplementedGuestAgentPluginServer struct {
}

func (UnimplementedGuestAgentPluginServer) Start(context.Context, *StartRequest) (*StartResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (UnimplementedGuestAgentPluginServer) Stop(context.Context, *StopRequest) (*StopResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}
func (UnimplementedGuestAgentPluginServer) GetStatus(context.Context, *GetStatusRequest) (*Status, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStatus not implemented")
}
func (UnimplementedGuestAgentPluginServer) Apply(context.Context, *ApplyRequest) (*ApplyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Apply not implemented")
}
func (UnimplementedGuestAgentPluginServer) mustEmbedUnimplementedGuestAgentPluginServer() {}

// UnsafeGuestAgentPluginServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GuestAgentPluginServer will
// result in compilation errors.
type UnsafeGuestAgentPluginServer interface {
	mustEmbedUnimplementedGuestAgentPluginServer()
}

func RegisterGuestAgentPluginServer(s grpc.ServiceRegistrar, srv GuestAgentPluginServer) {
	s.RegisterService(&GuestAgentPlugin_ServiceDesc, srv)
}

func _GuestAgentPlugin_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuestAgentPluginServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GuestAgentPlugin_Start_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuestAgentPluginServer).Start(ctx, req.(*StartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GuestAgentPlugin_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuestAgentPluginServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GuestAgentPlugin_Stop_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuestAgentPluginServer).Stop(ctx, req.(*StopRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GuestAgentPlugin_GetStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuestAgentPluginServer).GetStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GuestAgentPlugin_GetStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuestAgentPluginServer).GetStatus(ctx, req.(*GetStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GuestAgentPlugin_Apply_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GuestAgentPluginServer).Apply(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GuestAgentPlugin_Apply_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GuestAgentPluginServer).Apply(ctx, req.(*ApplyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GuestAgentPlugin_ServiceDesc is the grpc.ServiceDesc for GuestAgentPlugin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GuestAgentPlugin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "plugin_comm.GuestAgentPlugin",
	HandlerType: (*GuestAgentPluginServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Start",
			Handler:    _GuestAgentPlugin_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _GuestAgentPlugin_Stop_Handler,
		},
		{
			MethodName: "GetStatus",
			Handler:    _GuestAgentPlugin_GetStatus_Handler,
		},
		{
			MethodName: "Apply",
			Handler:    _GuestAgentPlugin_Apply_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "plugin_comm.proto",
}
