Using `--preferred-chain` to select the alternate chain.

If the ACME CA provides multiple cert chains, you can use `--preferred-chain` to select one. Otherwise, it will get the default chain.

1. For letsencrypt.org Staging Server:

https://letsencrypt.org/docs/staging-environment/

There are 2 chains provided:


|   Name                        |  Default |
|-------------------------------|----------|
|   (STAGING) Pretend Pear X1   |   No     |
|   (STAGING) Bogus Broccoli X2 |   Yes    |


You select the chain like:

```
acme.sh  --issue -d example.com .....  --test    --preferred-chain  "(STAGING) Pretend Pear X1"
```

You can also use part of the name:

```
acme.sh  --issue -d example.com .....  --test    --preferred-chain  "X1"
```

It's also case-insensitive:

```
acme.sh  --issue -d example.com .....  --test    --preferred-chain  "x1"
```


2. For Letsencrypt.org Production server:

    There are 2 chains provided:

    |   Name            |  Default  |
    |-------------------|-----------|
    |   DST Root CA X3 | Yes       |
    |   ISRG Root X1 |   No     |

    You select the chain like:
```
acme.sh  --issue -d example.com .....  --server letsencrypt   --preferred-chain  "ISRG Root X1"
```


You can also use part of the name:

```
acme.sh  --issue -d example.com .....  --server letsencrypt   --preferred-chain  "ISRG"
```

It's also case-insensitive:

```
acme.sh  --issue -d example.com .....  --server letsencrypt    --preferred-chain  "isrg"
```


3.  You can also set the default preferred chain for a specified CA(from v3.0.1).

```
acme.sh --set-default-chain  --preferred-chain "ISRG"   --server  letsencrypt
```

When you request a cert from letsencrypt in future, it will use the default preferred chain.






