INPUT=docs
OUTPUT=../web/mupdf.com/docs

for I in $(find $INPUT/examples -type f)
do
	B=$(echo $I | sed s,$INPUT/,,)
	O=$OUTPUT/$B
	cp $I $O
done

for I in $(find $INPUT -name '*.html')
do
	B=$(echo $I | sed s,$INPUT/,,)
	O=$OUTPUT/$B

	TITLE=$(cat $I | grep '<title>' | sed 's,</*title>,,g')

	ROOT=$(realpath --relative-to=$(dirname $I) $PWD)

	echo Processing $O "($TITLE)"

	sed '/<article>/,/<\/article>/p;d' < $I > temp.body

	cat >temp.head <<EOF
<!DOCTYPE html>
<html lang="en">
<head>
<title>$TITLE</title>
<meta name="description" content="MuPDF - the lightweight PDF, XPS, and E-book viewer">
<meta charset="UTF-8">
<meta name="format-detection" content="telephone=no">
<meta name="msapplication-tap-highlight" content="no">
<meta name="viewport" content="user-scalable=yes, initial-scale=1, width=device-width">
<link rel="stylesheet" type="text/css" href="$ROOT/css/default.css">
<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:200,200i,300,300i,400,400i,600,600i,700,700i,900,900i" rel="stylesheet">
<link rel="shortcut icon" href="$ROOT/images/favicon.png">
</head>
<body data-value="$ROOT/">
<header>
<div id="headerAssets" class="assets"></div>
<nav data-value="nav-index-2"></nav>
<noscript><code class="standout nojs"></code></noscript>
</header>
<main>
<div class="banner" role="heading" aria-level="1">
<h1>$TITLE</h1>
</div>
<div class="outer">
<div class="inner">
<!--- DO NOT EDIT. THIS FILE IS AUTOMATICALLY GENERATED. -->
EOF

cat >temp.foot <<EOF
</div>
</div>
<footer></footer>
</main>
<script type="text/javascript" src="$ROOT/js/app.js"></script>
</body>
</html>
EOF

	cat temp.head temp.body temp.foot > $O
done
