/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.NSProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Namespace;

public class BSEProperties
extends Properties {
    private static final String PROPERTIES_RESOURCE = "bse.properties";
    private static BSEProperties mInstance = null;
    private static long mLastUpdate = new Date().getTime();
    public static final String VERSION = "BseVersion";
    public static final String DATASERVER = "BseDataServer";
    public static final String GAUSSIAN = "Gaussian";
    public static final String GAUSSIANCONTRIB = "GaussianContrib";
    public static final String GAUSSIANEMSLLIB = "GaussianEmslLib";
    public static final String PLANEWAVE = "PlaveWave";
    public static final String PLANEWAVECONTRIB = "PlaneWaveContrib";
    public static final String PLANEWAVEEMSLLIB = "PlaneWaveEmslLib";
    public static final String SLATER = "Slater";
    public static final String SLATERCONTRIB = "SlaterContrib";
    public static final String SLATEREMSLLIB = "SlaterEmslLib";
    public static final String TEMPDIR = "TempDir";
    public static final String PROPERTYLIST = "PropertyList";
    public static final String BSESERVICEURL = "BseServiceUrl";
    public static final String BSEALLOWEDHOSTS_IP = "bse.allowedhosts_ip";
    public static final String BSEFULLACCESSHOSTS_IP = "bse.fullaccesshosts_ip";
    public static final String BSENAMESPACE = "http://purl.oclc.org/NET/EMSL/BSE";
    public static final String FEEDBACK = "Feedback";
    public static final Namespace mBseNs = Namespace.getNamespace("bse", "http://purl.oclc.org/NET/EMSL/BSE");
    public static final Namespace mDcNs = Namespace.getNamespace("dc", "http://purl.org/dc/elements/1.1/");
    public static final Namespace mDctNs = Namespace.getNamespace("dct", "http://purl.org/dc/terms/");
    public static final Namespace mCmcsNs = Namespace.getNamespace("cmcs", "http://purl.oclc.org/NET/cmcs/schema/");
    public static final Namespace mEmslNs = Namespace.getNamespace("", "http://purl.oclc.org/NET/EMSL/BSE");
    public static final Namespace mCmlNs = Namespace.getNamespace("cml", "http://www.xml-cml.org/schema/cml2/core");
    public static final Namespace mXlinkNs = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    public static final int NWCHEM = 1;
    public static final int MOLPRO = 2;
    public static final int MOLPRO_INT = 3;
    public static final int SUPERMOLECULE = 4;
    public static final int HONDO = 5;
    public static final int MELDF = 6;
    public static final int MOLCAS = 7;
    public static final int ACESII = 8;
    public static final int HYPERCHEM = 9;
    public static final int DALTON = 10;
    public static final int DEMON_KS = 11;
    public static final int DEMON_2001 = 12;
    public static final int AMICA = 13;
    public static final int NWCHEMECP = 101;
    public static final int MOLPROECP = 102;

    protected BSEProperties() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_RESOURCE);
        try {
            super.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static BSEProperties getBSEProperties() {
        if (mInstance == null) {
            mInstance = new BSEProperties();
        }
        return mInstance;
    }

    public static Vector getPropertyAsVector(String key) {
        Vector<String> propVec = null;
        String prop = BSEProperties.getBSEProperties().getProperty(key);
        if (prop != null) {
            propVec = new Vector<String>();
            StringTokenizer st = null;
            if (prop.startsWith("\\")) {
                String delim = prop.substring(1, 2);
                st = new StringTokenizer(prop.substring(2), delim);
            } else {
                st = new StringTokenizer(prop);
            }
            while (st.hasMoreTokens()) {
                propVec.add(st.nextToken().trim());
            }
        }
        return propVec;
    }

    public Vector getPropertyAsNSPropertyVector(String key) {
        Vector<NSProperty> propNameVec = null;
        Vector tmpVec = BSEProperties.getPropertyAsVector(key);
        if (tmpVec != null) {
            propNameVec = new Vector<NSProperty>(tmpVec.size());
            for (int i = 0; i < tmpVec.size(); ++i) {
                propNameVec.add(new NSProperty((String)tmpVec.get(i)));
            }
        }
        return propNameVec;
    }

    public static long lastUpdate() {
        return mLastUpdate;
    }

    public static void setLastUpdate() {
        mLastUpdate = new Date().getTime();
    }
}

