<?php

/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace libphonenumber;

/**
 * Class containing string constants of region codes for easier testing.
 * @internal
 */
class RegionCode
{
    // Region code for global networks (e.g. +800 numbers).
    public const UN001 = '001';
    public const AD = 'AD';
    public const AE = 'AE';
    public const AM = 'AM';
    public const AO = 'AO';
    public const AQ = 'AQ';
    public const AR = 'AR';
    public const AU = 'AU';
    public const BB = 'BB';
    public const BR = 'BR';
    public const BS = 'BS';
    public const BY = 'BY';
    public const CA = 'CA';
    public const CH = 'CH';
    public const CL = 'CL';
    public const CN = 'CN';
    public const CO = 'CO';
    public const CS = 'CS';
    public const CX = 'CX';
    public const DE = 'DE';
    public const FR = 'FR';
    public const GB = 'GB';
    public const HU = 'HU';
    public const IT = 'IT';
    public const JP = 'JP';
    public const KR = 'KR';
    public const MX = 'MX';
    public const NZ = 'NZ';
    public const PG = 'PG';
    public const PL = 'PL';
    public const RE = 'RE';
    public const RU = 'RU';
    public const SE = 'SE';
    public const SG = 'SG';
    public const US = 'US';
    public const UZ = 'UZ';
    public const YT = 'YT';
    public const ZW = 'ZW';
    // Official code for the unknown region.
    public const ZZ = 'ZZ';
}
