# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2024_01_01.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.v2024_01_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class Extension(_serialization.Model):
    """A plan's extension properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The extension name. Supported values are: :code:`<br>`:code:`<br>`\\
     **AgentlessDiscoveryForKubernetes** - API-based discovery of information about Kubernetes
     cluster architecture, workload objects, and setup. Required for Kubernetes inventory, identity
     and network exposure detection, attack path analysis and risk hunting as part of the cloud
     security explorer.
     Available for CloudPosture plan.:code:`<br>`:code:`<br>`\\ **OnUploadMalwareScanning** -
     Limits the GB to be scanned per month for each storage account within the subscription. Once
     this limit reached on a given storage account, Blobs won't be scanned during current calendar
     month.
     Available for StorageAccounts plan.:code:`<br>`:code:`<br>`\\ **SensitiveDataDiscovery** -
     Sensitive data discovery identifies Blob storage container with sensitive data such as
     credentials, credit cards, and more, to help prioritize and investigate security events.
     Available for StorageAccounts and CloudPosture plans.:code:`<br>`:code:`<br>`\\
     **ContainerRegistriesVulnerabilityAssessments** - Provides vulnerability management for images
     stored in your container registries.
     Available for CloudPosture and Containers plans. Required.
    :vartype name: str
    :ivar is_enabled: Indicates whether the extension is enabled. Required. Known values are:
     "True" and "False".
    :vartype is_enabled: str or ~azure.mgmt.security.v2024_01_01.models.IsEnabled
    :ivar additional_extension_properties: Property values associated with the extension.
    :vartype additional_extension_properties: dict[str, any]
    :ivar operation_status: Optional. A status describing the success/failure of the extension's
     enablement/disablement operation.
    :vartype operation_status: ~azure.mgmt.security.v2024_01_01.models.OperationStatus
    """

    _validation = {
        "name": {"required": True},
        "is_enabled": {"required": True},
        "operation_status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "str"},
        "additional_extension_properties": {"key": "additionalExtensionProperties", "type": "{object}"},
        "operation_status": {"key": "operationStatus", "type": "OperationStatus"},
    }

    def __init__(
        self,
        *,
        name: str,
        is_enabled: Union[str, "_models.IsEnabled"],
        additional_extension_properties: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The extension name. Supported values are: :code:`<br>`:code:`<br>`\\
         **AgentlessDiscoveryForKubernetes** - API-based discovery of information about Kubernetes
         cluster architecture, workload objects, and setup. Required for Kubernetes inventory, identity
         and network exposure detection, attack path analysis and risk hunting as part of the cloud
         security explorer.
         Available for CloudPosture plan.:code:`<br>`:code:`<br>`\\ **OnUploadMalwareScanning** -
         Limits the GB to be scanned per month for each storage account within the subscription. Once
         this limit reached on a given storage account, Blobs won't be scanned during current calendar
         month.
         Available for StorageAccounts plan.:code:`<br>`:code:`<br>`\\ **SensitiveDataDiscovery** -
         Sensitive data discovery identifies Blob storage container with sensitive data such as
         credentials, credit cards, and more, to help prioritize and investigate security events.
         Available for StorageAccounts and CloudPosture plans.:code:`<br>`:code:`<br>`\\
         **ContainerRegistriesVulnerabilityAssessments** - Provides vulnerability management for images
         stored in your container registries.
         Available for CloudPosture and Containers plans. Required.
        :paramtype name: str
        :keyword is_enabled: Indicates whether the extension is enabled. Required. Known values are:
         "True" and "False".
        :paramtype is_enabled: str or ~azure.mgmt.security.v2024_01_01.models.IsEnabled
        :keyword additional_extension_properties: Property values associated with the extension.
        :paramtype additional_extension_properties: dict[str, any]
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_enabled = is_enabled
        self.additional_extension_properties = additional_extension_properties
        self.operation_status = None


class OperationStatus(_serialization.Model):
    """A status describing the success/failure of the extension's enablement/disablement operation.

    :ivar code: The operation status code. Known values are: "Succeeded" and "Failed".
    :vartype code: str or ~azure.mgmt.security.v2024_01_01.models.Code
    :ivar message: Additional information regarding the success/failure of the operation.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[Union[str, "_models.Code"]] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The operation status code. Known values are: "Succeeded" and "Failed".
        :paramtype code: str or ~azure.mgmt.security.v2024_01_01.models.Code
        :keyword message: Additional information regarding the success/failure of the operation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Pricing(Resource):  # pylint: disable=too-many-instance-attributes
    """Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard
    tier offers advanced security capabilities, while the free tier offers basic security features.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar pricing_tier: Indicates whether the Defender plan is enabled on the selected scope.
     Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard
     tier offers advanced security capabilities, while the free tier offers basic security features.
     Known values are: "Free" and "Standard".
    :vartype pricing_tier: str or ~azure.mgmt.security.v2024_01_01.models.PricingTier
    :ivar sub_plan: The sub-plan selected for a Standard pricing configuration, when more than one
     sub-plan is available. Each sub-plan enables a set of security features. When not specified,
     full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2', where for
     resource level only 'P1' sub plan is supported.
    :vartype sub_plan: str
    :ivar free_trial_remaining_time: The duration left for the subscriptions free trial period - in
     ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
    :vartype free_trial_remaining_time: ~datetime.timedelta
    :ivar enablement_time: Optional. If ``pricingTier`` is ``Standard`` then this property holds
     the date of the last time the ``pricingTier`` was set to ``Standard``\\ , when available (e.g
     2023-03-01T12:42:42.1921106Z).
    :vartype enablement_time: ~datetime.datetime
    :ivar enforce: If set to "False", it allows the descendants of this scope to override the
     pricing configuration set on this scope (allows setting inherited="False"). If set to "True",
     it prevents overrides and forces this pricing configuration on all the descendants of this
     scope. This field is only available for subscription-level pricing. Known values are: "False"
     and "True".
    :vartype enforce: str or ~azure.mgmt.security.v2024_01_01.models.Enforce
    :ivar inherited: "inherited" = "True" indicates that the current scope inherits its pricing
     configuration from its parent. The ID of the parent scope that provides the inherited
     configuration is displayed in the "inheritedFrom" field. On the other hand, "inherited" =
     "False" indicates that the current scope has its own pricing configuration explicitly set, and
     does not inherit from its parent. This field is read only and available only for resource-level
     pricing. Known values are: "True" and "False".
    :vartype inherited: str or ~azure.mgmt.security.v2024_01_01.models.Inherited
    :ivar inherited_from: The id of the scope inherited from. "Null" if not inherited. This field
     is only available for resource-level pricing.
    :vartype inherited_from: str
    :ivar resources_coverage_status: This field is available for subscription-level only, and
     reflects the coverage status of the resources under the subscription. Please note: The
     "pricingTier" field reflects the plan status of the subscription. However, since the plan
     status can also be defined at the resource level, there might be misalignment between the
     subscription's plan status and the resource status. This field helps indicate the coverage
     status of the resources. Known values are: "FullyCovered", "PartiallyCovered", and
     "NotCovered".
    :vartype resources_coverage_status: str or
     ~azure.mgmt.security.v2024_01_01.models.ResourcesCoverageStatus
    :ivar extensions: Optional. List of extensions offered under a plan.
    :vartype extensions: list[~azure.mgmt.security.v2024_01_01.models.Extension]
    :ivar deprecated: Optional. True if the plan is deprecated. If there are replacing plans they
     will appear in ``replacedBy`` property.
    :vartype deprecated: bool
    :ivar replaced_by: Optional. List of plans that replace this plan. This property exists only if
     this plan is deprecated.
    :vartype replaced_by: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "free_trial_remaining_time": {"readonly": True},
        "enablement_time": {"readonly": True},
        "inherited": {"readonly": True},
        "inherited_from": {"readonly": True},
        "resources_coverage_status": {"readonly": True},
        "deprecated": {"readonly": True},
        "replaced_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "pricing_tier": {"key": "properties.pricingTier", "type": "str"},
        "sub_plan": {"key": "properties.subPlan", "type": "str"},
        "free_trial_remaining_time": {"key": "properties.freeTrialRemainingTime", "type": "duration"},
        "enablement_time": {"key": "properties.enablementTime", "type": "iso-8601"},
        "enforce": {"key": "properties.enforce", "type": "str"},
        "inherited": {"key": "properties.inherited", "type": "str"},
        "inherited_from": {"key": "properties.inheritedFrom", "type": "str"},
        "resources_coverage_status": {"key": "properties.resourcesCoverageStatus", "type": "str"},
        "extensions": {"key": "properties.extensions", "type": "[Extension]"},
        "deprecated": {"key": "properties.deprecated", "type": "bool"},
        "replaced_by": {"key": "properties.replacedBy", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        pricing_tier: Optional[Union[str, "_models.PricingTier"]] = None,
        sub_plan: Optional[str] = None,
        enforce: Optional[Union[str, "_models.Enforce"]] = None,
        extensions: Optional[List["_models.Extension"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pricing_tier: Indicates whether the Defender plan is enabled on the selected scope.
         Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard
         tier offers advanced security capabilities, while the free tier offers basic security features.
         Known values are: "Free" and "Standard".
        :paramtype pricing_tier: str or ~azure.mgmt.security.v2024_01_01.models.PricingTier
        :keyword sub_plan: The sub-plan selected for a Standard pricing configuration, when more than
         one sub-plan is available. Each sub-plan enables a set of security features. When not
         specified, full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2',
         where for resource level only 'P1' sub plan is supported.
        :paramtype sub_plan: str
        :keyword enforce: If set to "False", it allows the descendants of this scope to override the
         pricing configuration set on this scope (allows setting inherited="False"). If set to "True",
         it prevents overrides and forces this pricing configuration on all the descendants of this
         scope. This field is only available for subscription-level pricing. Known values are: "False"
         and "True".
        :paramtype enforce: str or ~azure.mgmt.security.v2024_01_01.models.Enforce
        :keyword extensions: Optional. List of extensions offered under a plan.
        :paramtype extensions: list[~azure.mgmt.security.v2024_01_01.models.Extension]
        """
        super().__init__(**kwargs)
        self.pricing_tier = pricing_tier
        self.sub_plan = sub_plan
        self.free_trial_remaining_time = None
        self.enablement_time = None
        self.enforce = enforce
        self.inherited = None
        self.inherited_from = None
        self.resources_coverage_status = None
        self.extensions = extensions
        self.deprecated = None
        self.replaced_by = None


class PricingList(_serialization.Model):
    """List of pricing configurations response.

    All required parameters must be populated in order to send to server.

    :ivar value: List of pricing configurations. Required.
    :vartype value: list[~azure.mgmt.security.v2024_01_01.models.Pricing]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Pricing]"},
    }

    def __init__(self, *, value: List["_models.Pricing"], **kwargs: Any) -> None:
        """
        :keyword value: List of pricing configurations. Required.
        :paramtype value: list[~azure.mgmt.security.v2024_01_01.models.Pricing]
        """
        super().__init__(**kwargs)
        self.value = value
