# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ImpactType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The impact type."""

    NONE = "None"
    """Pending updates has no impact on resource."""
    FREEZE = "Freeze"
    """Pending updates can freeze network or disk io operation on resource."""
    RESTART = "Restart"
    """Pending updates can cause resource to restart."""
    REDEPLOY = "Redeploy"
    """Pending updates can redeploy resource."""


class MaintenanceScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets maintenanceScope of the configuration."""

    HOST = "Host"
    """This maintenance scope controls installation of azure platform updates i.e. services on
    physical nodes hosting customer VMs."""
    RESOURCE = "Resource"
    """This maintenance scope controls the default update maintenance of the Azure Resource"""
    OS_IMAGE = "OSImage"
    """This maintenance scope controls os image installation on VM/VMSS"""
    EXTENSION = "Extension"
    """This maintenance scope controls extension installation on VM/VMSS"""
    IN_GUEST_PATCH = "InGuestPatch"
    """This maintenance scope controls installation of windows and linux packages on VM/VMSS"""
    SQLDB = "SQLDB"
    """This maintenance scope controls installation of SQL server platform updates."""
    SQL_MANAGED_INSTANCE = "SQLManagedInstance"
    """This maintenance scope controls installation of SQL managed instance platform update."""


class RebootOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible reboot preference as defined by the user based on which it would be decided to reboot
    the machine or not after the patch operation is completed.
    """

    IF_REQUIRED = "IfRequired"
    NEVER = "Never"
    ALWAYS = "Always"


class TagOperators(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Filter VMs by Any or All specified tags."""

    ALL = "All"
    ANY = "Any"


class UpdateStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status."""

    PENDING = "Pending"
    """There are pending updates to be installed."""
    IN_PROGRESS = "InProgress"
    """Updates installation are in progress."""
    COMPLETED = "Completed"
    """All updates are successfully applied."""
    RETRY_NOW = "RetryNow"
    """Updates installation failed but are ready to retry again."""
    RETRY_LATER = "RetryLater"
    """Updates installation failed and should be retried later."""
    NO_UPDATES_PENDING = "NoUpdatesPending"
    """No updates are pending."""
    CANCEL = "Cancel"
    """Cancel the schedule and stop creating PMR for resources part of it. Applicable to Maintenance
    Configuration resource type only."""
    CANCELLED = "Cancelled"
    """Send the Cancelled response to the user if request came to cancel the schedule. Applicable to
    Maintenance Configuration resource type only."""


class Visibility(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the visibility of the configuration. The default value is 'Custom'."""

    CUSTOM = "Custom"
    """Only visible to users with permissions."""
    PUBLIC = "Public"
    """Visible to all users."""
