% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{cif}
\alias{cif}
\title{Cumulative incidence with robust standard errors}
\usage{
cif(formula, data = data, cause = 1, cens.code = 0, ...)
}
\arguments{
\item{formula}{formula with 'Surv' outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{NULL looks at all, otherwise specify which cause to consider}

\item{cens.code}{censoring code "0" is default}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Cumulative incidence with robust standard errors
}
\examples{
data(TRACE)
TRACE$cluster <- sample(1:100,1878,replace=TRUE)
out1 <- cif(Event(time,status)~+1,data=TRACE,cause=9)
out2 <- cif(Event(time,status)~+1+cluster(cluster),data=TRACE,cause=9)

out1 <- cif(Event(time,status)~strata(vf,chf),data=TRACE,cause=9)
out2 <- cif(Event(time,status)~strata(vf,chf)+cluster(cluster),data=TRACE,cause=9)

par(mfrow=c(1,2))
bplot(out1,se=TRUE)
bplot(out2,se=TRUE)
}
\author{
Thomas Scheike
}
