% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/author.R
\name{use_author}
\alias{use_author}
\title{Add an author to the \code{Authors@R} field in DESCRIPTION}
\usage{
use_author(given = NULL, family = NULL, ..., role = "ctb")
}
\arguments{
\item{given}{a character vector with the \emph{given} names,
    or a list thereof.}

\item{family}{a character string with the \emph{family} name,
    or a list thereof.}

\item{...}{
  Arguments passed on to \code{\link[utils:person]{utils::person}}
  \describe{
    \item{\code{middle}}{a character string with the collapsed middle name(s).
    Deprecated, see \bold{Details}.}
    \item{\code{email}}{a character string (or vector) giving an e-mail address
    (each),
    or a list thereof.}
    \item{\code{comment}}{a character string (or vector) providing comments,
    or a list thereof.}
    \item{\code{first}}{a character string giving the first name.
    Deprecated, see \bold{Details}.}
    \item{\code{last}}{a character string giving the last name.
    Deprecated, see \bold{Details}.}
  }}

\item{role}{a character vector specifying the role(s) of the person
    (see \bold{Details}),
    or a list thereof.}
}
\description{
\code{use_author()} adds a person to the \code{Authors@R} field of the DESCRIPTION
file, creating that field if necessary. It will not modify, e.g., the role(s)
or email of an existing author (judged using their "Given Family" name). For
that we recommend editing DESCRIPTION directly. Or, for programmatic use,
consider calling the more specialized functions available in the \pkg{desc}
package directly.

\code{use_author()} also surfaces two other situations you might want to address:
\itemize{
\item Explicit use of the fields \code{Author} or \code{Maintainer}. We recommend switching
to the more modern \code{Authors@R} field instead, because it offers richer
metadata for various downstream uses. (Note that \code{Authors@R} is \emph{eventually}
processed to create \code{Author} and \code{Maintainer} fields, but only when the
\code{tar.gz} is built from package source.)
\item Presence of the fake author placed by \code{\link[=create_package]{create_package()}} and
\code{\link[=use_description]{use_description()}}. This happens when \pkg{usethis} has to create a
DESCRIPTION file and the user hasn't given any author information via the
\code{fields} argument or the global option \code{"usethis.description"}. The
placeholder looks something like \verb{First Last <first.last@example.com> [aut, cre]} and \code{use_author()} offers to remove it in interactive sessions.
}
}
\examples{
\dontrun{
use_author(
  given = "Lucy",
  family = "van Pelt",
  role = c("aut", "cre"),
  email = "lucy@example.com",
  comment = c(ORCID = "LUCY-ORCID-ID")
)

use_author("Charlie", "Brown")
}

}
