// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2012 - INRIA - Serge STEER
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

//============================================================================================
//=================================dct(A [,isn ]) ============================================
//============================================================================================
//*****1-D transform *************************************************************************
//Real case
x=1:12;
y=dct(x);
y_ref=[22.516660498395403,-11.8786642686858634,0,-1.28774657627874833,0,-0.43698525004935185,0,..
       -0.19742775076373928,0,-0.09151733141338797,0,-0.02710534350890513];
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checktrue(isreal(y));
y=dct(x,-1);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checktrue(isreal(y));
assert_checkalmostequal(dct(y,1),x,0,100*%eps);

x=[2;8;1;3;7;6;8;7;9;1;6;7;7;2;5;2;2;2;9;7;3];
y_ref=[22.6946605845432074;1.10519574266518794;-2.3241759528540804;-4.85151174144696462;
       1.0125846934610252;-1.1922212636993892;1.59557416291812504;4.54344111251121419;
       -2.5559634218592766;0.60407624058440501;-2.30214098713630388; 3.897143024186624;
       -4.1080570985039806;-4.03538258536340688;-2.00594354950719467;-1.38969746761551849;
       -1.83219922773155397;-2.95095934890382949;-1.53744081244562425;-1.30413301180655994;
       4.3041816147747296];
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checktrue(isreal(y));
y=dct(x,-1);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checktrue(isreal(y));
assert_checkalmostequal(dct(y,1),x,0,100*%eps);

//Complex case
x=[9+%i*4,2+%i*3,3+%i*6,4+%i*4,3+%i*9,6+%i,5+%i*5,3+%i*3,6+%i*4,5+%i*3];

y_ref=complex(dct(real(x)),dct(imag(x)));
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
y=dct(x,-1);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checkalmostequal(dct(y,1),x,0,100*%eps);
//*****2-D transform *************************************************************************
//Real case
x=matrix([1 5 -3 7 0.3 -1 23 -0.5 -0.9 2 -7 23],3,4);
y_ref=[14.1162140816863513,-8.0479004090282249,-1.9918584287042105,3.4272874122786048;
       5.26794551983977577,8.50616086908862101,-17.2887608000110866,12.1283851880283517;
       11.3288900603721974,-15.5570935550615044,-0.30618621784789912,-0.91342220197659429];

//assert_checkalmostequal(DCTN(x,-1),y_ref);

y=dct(x);
assert_checkalmostequal(y,y_ref);
assert_checktrue(isreal(y));
y=dct(x,-1);
assert_checkalmostequal(y,y_ref);
assert_checktrue(isreal(y));

assert_checkalmostequal(dct(y,1),x);


x = [5,0,8,8,6,4,3,2,4;
     4,5,2,4,6,9,5,6,8;
     3,3,1,4,7,9,3,8,6;
     6,4,7,9,9,3,5,0,5;
     4,3,2,1,5,4,5,7,2;
     9,1,7,2,3,7,1,2,8];
y_ref = [34.5650219259403997,-1.78710447324021815,-2.48169728021161573,0.16666666666666699,..
         5.69563532864431199,-0.59272882615611178,2.21317603189356582,3.3056243529158942,..
         0.77159656358327178;
         1.97808522199214609,-1.62888466797664266,-3.52915941330826,-1.81698729810778037,..
         -0.00057916618067070,0.72759134820032212,-0.49562009306186250,-1.52634899725477169,..
         -1.64182890117946090;
         -2,2.0255789396616728,2.39977639282567701,-1.02062072615965738,-0.21623417629893263,..
         -0.33673269589600086,4.59619407771255872,3.58705650694926259,1.2017970067515158;
         -1.632993161855452,4.54779009715027005,-3.28900566318474974,-2.5,-2.3230729643967232,..
         4.37582606600885970,0.28867513459481303,-2.32803596885859054,3.9415445893237928;
         0.7698003589195008,3.99972019170555404,-1.83426711715667090,-4.12478955692152738,..
         2.28878659482871472,0.71653818014654680,4.42268981335851574,1.16186166799936497,..
         1.59242235450869574;
         -2.92089426357420923,-3.87026979368244106,0.33153838264147889,2.68301270189221830,..
         -1.42188370601683456,1.21560492170039569,-3.67104657360480369,2.74425230353935490,..
         -2.13332925728981504];
//assert_checkalmostequal(DCTN(x,-1),y_ref);
y=dct(x);
assert_checkalmostequal(y,y_ref,1000*%eps);
assert_checktrue(isreal(y));

assert_checkalmostequal(dct(y,1),x,0,100*%eps);

//Complex case
x=[1+%i*4, 8+%i*4; 2+%i*9, 1+%i; 7+%i*2, 2+%i*6; 7+%i*6, 8+%i*7];
y_ref=complex(dct(real(x)),dct(imag(x)));
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checkalmostequal(dct(y,1),x,0,100*%eps);
//*****N-D transform *************************************************************************
function y=DCTN(y,flag)
  for i=1:ndims(y),y=dct(y,flag,i),end
endfunction

//Real case
x=matrix([2,8,1,3,7,6,8,7,9,1,6,7,7,2,5,2,2,2,9,7,3,9,2,3,..
          4,3,6,5,3,6,5,4,3,6,4,9,1,5,3,4,3,1,8,2,1,7,2,7],[3,4,4]);
y_ref=DCTN(x,-1);
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checktrue(isreal(y));
y=dct(x,-1);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checktrue(isreal(y));
assert_checkalmostequal(dct(y,1),x);

x=matrix([5,1,10,2,0,8,1,10,7,2,5,8,8,1,8,3],[2 2 2 2]);
y_ref=DCTN(x,-1);
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checkalmostequal(dct(y,1),x,0,100*%eps);

x=matrix([5,1,10,2,0,8,1,10,7,2,5,8,8,1,8,3],[1 2 2 2 2]);
y_ref=DCTN(x,-1);
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checkalmostequal(dct(y,1),x,0,100*%eps);


x=matrix([2,8,1,3,7,6,8,7,9,1,6,7,7,2,5,2,2,2,9,7,3,9,2,3,...
          4,3,6,5,3,6,5,4,3,6,4,9,11,5,3,4,3,1,8,2,1,7,2,7,...
          8,4,4,9,1,2,6,6,7,9,5,3,4,9,9,3,4,7,3,5,3,5,5,1,...
          2,6,8,5,7,2,4,8,6,5,2,8,1,3,9,8,5,10,6,10,1,7,4,6],[3,4,2 4]);
y_ref=DCTN(x,-1);
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checkalmostequal(dct(y,1),x,100*%eps);

//Complex case
x=matrix([3,3+%i*8,6+%i,1+%i*9,6,7+%i*2,3+%i*5,%i*7,5+%i*9,4+%i*2,2+%i*6,5+%i*3,4+%i*4,...
          3+%i*9,1+%i*8,6+%i*8,3+%i*3,7+%i*4,5+%i*4,3+%i*7,7+%i*8,1+%i*4,4+%i*8,7+%i*5,...
          9+%i,2+%i*10,4+%i*2,10,5+%i*8,5+%i,6+%i*10,6+%i*7,5+%i*2,8+%i*5,8+%i*8,10+%i*8,...
          8+%i,4+%i*8,2+%i*3,9+%i*3,1+%i*10,5+%i*9,4+%i*2,%i*9,5+%i*7,8+%i*9,6,2+%i*2],[3,4,1,4]);
y_ref=dct(real(x))+%i*(dct(imag(x)));
y=dct(x);
assert_checkalmostequal(y,y_ref,0,100*%eps);
assert_checkalmostequal(dct(y,1),x,0,100*%eps);
