/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.exceptions;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.rdf.model.Resource;

public class CannotConstructException
extends AssemblerException {
    protected final Resource type;
    protected final Class<?> assemblerClass;
    private static final String rootPrefix = CannotConstructException.getPackagePrefix(Assembler.class.getName());

    public CannotConstructException(Class<?> assemblerClass, Resource root, Resource type) {
        super(root, CannotConstructException.constructMessage(assemblerClass, root, type));
        this.type = type;
        this.assemblerClass = assemblerClass;
    }

    private static String constructMessage(Class<?> assemblerClass, Resource root, Resource type) {
        return "the assembler " + CannotConstructException.getClassName(assemblerClass) + " cannot construct the object named " + CannotConstructException.nice(root) + " because it is not of rdf:type " + CannotConstructException.nice(type);
    }

    private static String getClassName(Class<?> c) {
        String name = c.getName();
        return CannotConstructException.getPackagePrefix(name).equals(rootPrefix) ? CannotConstructException.getLeafName(name) : name;
    }

    private static String getLeafName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static String getPackagePrefix(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    public Class<?> getAssemblerClass() {
        return this.assemblerClass;
    }

    public Resource getType() {
        return this.type;
    }
}

