/* $Id: kmo_multi_reconstruct-test.c,v 1.12 2013-10-08 11:18:56 aagudo Exp $
 *
 * This file is part of the KMOS Library
 * Copyright (C) 2002-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: aagudo $
 * $Date: 2013-10-08 11:18:56 $
 * $Revision: 1.12 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <sys/stat.h>
#include <math.h>

#include <cpl.h>

#include "kmclipm_functions.h"

#include "kmo_dfs.h"

const char  *test_global_path_test_data;
float   test_global_seed_data, test_global_seed_noise;
int     test_global_size_x, test_global_size_y, test_global_size_z, test_global_nr_frames;
void kmo_get_pipe_command(char*, const char*, const char*, int);
int kmo_test_file_exists(const char*);
void kmo_test_verbose_off();
void kmo_test_verbose_on();
double kmo_test_esorex_data(const char*, int);
const char* kmo_test_cat_strings(char*, const char*, const char*);
int  kmo_test_create_RAW_data(int, int, const char*, char**, char**, int*, int, char**, char**, int*, int, float, float);
int  kmo_test_create_RAW_data_zero(int, int, const char*);
int  kmo_test_create_F2D_data(int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F2D_data_noise(int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F2I_data(int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F2I_data_noise(int, int, int, const char*, char *, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data(int, int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data_infinite(int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data2(int, int, int, int, int*, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data_noise(int, int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F1I_data(int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F1I_data_noise(int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_B2D_data(int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);

const char      *path_recipe       = "kmo_multi_reconstruct/";

const char      *valid_files[]     = {"science_obj_123.fits",
                                      "science_sky_123.fits",
                                      "kmos_wave_band.fits"};

/**
    @defgroup kmo_multi_reconstruct_test  kmo_multi_reconstruct_test unit tests

    @{
*/

/**
  @brief   test
 */
static void test_multi_reconstruct(const char *path1, const char *path2, int ret_val)
{
    // create sof-file
    const char *sof_path = "test_multi_reconstruct.sof";
    FILE *fh = fopen(sof_path, "w");
    char *my_path = cpl_sprintf("%s/ref_data/%s", getenv("srcdir"), valid_files[2]);
    fprintf (fh,
             "%s                          SCIENCE\n"
             "%s                          SCIENCE\n"
             "master_flat_KKK.fits        MASTER_FLAT\n"
             "xcal_KKK.fits               XCAL\n"
             "ycal_KKK.fits               YCAL\n"
             "lcal_KKK.fits               LCAL\n"
             "%s WAVE_BAND\n",
             path1, path2, my_path);
    fclose(fh);
    cpl_free(my_path);

    // create esorex-command
    char esorex_command[256];
    sprintf(esorex_command,
            "esorex --suppress-prefix=TRUE kmo_multi_reconstruct --b_start=1.948 "
            "--b_end=2.351 --name=\"FDF_086\" --method=\"header\"  %s", sof_path);

    kmo_get_pipe_command(esorex_command,
                         "log_kmo_multi_reconstruct.txt", sof_path, TRUE);

    // execute esorex-command
    if (ret_val == 0) {
        cpl_test_eq(0, system(esorex_command));
    } else {
        cpl_test_noneq(0, system(esorex_command));
    }
}

/**
  @brief    Test of kmo_multi_reconstruct recipe.
  @param    argc   the number of parameters
  @param    argv   the parameter list

  Call @c kmo_multi_reconstruct-test @c --generate when only the test data for this
  recipe should be generated.
  Call @c kmo_multi_reconstruct-test @c --no-gen when only the tests should be
  executed and no data should be generated.

 */
int main(int argc, char *argv[])
{
    float   tol = 0.1;

    char    test_path[256],
            file_path[256],
            op_file1[256],
            op_file2[256];

    cpl_test_init("<kmos-spark@mpe.mpg.de>", CPL_MSG_WARNING);

    strcpy(test_path, test_global_path_test_data);
    strcat(test_path, path_recipe);

    if (kmo_test_file_exists(test_path) == FALSE) {
        mkdir(test_path, 0777);
    }

    // get rid of warning...
    if ((argc == 5) && (strcmp(argv[1], "xxx") != 0)) {
    }

    FILE *fd = fopen("log_kmo_multi_reconstruct.txt", "w");
    fprintf(fd, "%s\n", " ");
    fclose(fd);

    //
    //  PIPELINE TEST (must be called after kmo_illumination-test, since the
    //  following recipes rely on this output)
    //
    cpl_msg_info(cpl_func, "Testing kmo_multi_reconstruct with real pipeline data.");
    sprintf(test_path, "%s%s", test_global_path_test_data, "pipeline/");

    kmo_test_cat_strings(op_file1, test_path, valid_files[0]);
    kmo_test_cat_strings(op_file2, test_path, valid_files[1]);
    test_multi_reconstruct(op_file1, op_file2, 0);

    strcpy(file_path, "cube_multi_FDF_086");
    if (fabs(kmo_test_esorex_data(file_path, 1)-291.216) < tol) {
        // Linux
        cpl_test_abs(kmo_test_esorex_data(file_path, 1), 291.216, tol);
    } else {
        // Mac
        cpl_test_abs(kmo_test_esorex_data(file_path, 1), 8132.22, tol);
    }

    return cpl_test_end(0);
}

/** @} */
