# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Utility functions for tests that require collections."""

from typing import Any

from debusine.artifacts.models import ArtifactCategory
from debusine.db.models import Artifact
from debusine.test.django import TestCase


class CollectionTestMixin(TestCase):
    """Utility functions to create test collections."""

    def create_source_package(
        self, name: str, version: str, dsc_fields: dict[str, Any] | None = None
    ) -> Artifact:
        """Create a minimal `debian:source-package` artifact."""
        artifact, _ = self.playground.create_artifact(
            category=ArtifactCategory.SOURCE_PACKAGE,
            data={
                "name": name,
                "version": version,
                "type": "dpkg",
                "dsc_fields": dsc_fields or {},
            },
            paths=[f"{name}_{version}.dsc"],
            create_files=True,
            skip_add_files_in_store=True,
        )
        return artifact
