# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""UI helpers for worker pools."""

from functools import cached_property

from debusine.db.models import WorkerPool
from debusine.web.views.places import ResourcePlace
from debusine.web.views.ui.base import UI


class WorkerPoolUI(UI[WorkerPool]):
    """UI helpers for worker pool instances."""

    @cached_property
    def place(self) -> ResourcePlace:
        """Return a place to show this worker pool."""
        return ResourcePlace(
            title=f"Worker pool {self.instance.name}",
            breadcrumb=self.instance.name,
            url=self.instance.get_absolute_url(),
        )
