
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file SymbolInputAttributes.h
    \\brief Definition of SymbolInput Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "SymbolInputWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



SymbolInputWrapper::SymbolInputWrapper(): symbolinput_(new SymbolInput())


{


	

}
SymbolInputWrapper::SymbolInputWrapper(SymbolInput* symbolinput): symbolinput_(symbolinput)
{

	
}

SymbolInputWrapper::~SymbolInputWrapper()
{

}

void SymbolInputWrapper::set(const MagRequest& request)
{

	

	doublearray  x_value;
	for (int i = 0; i < request.countValues("SYMBOL_INPUT_X_POSITION"); i++)
		x_value.push_back((double)request("SYMBOL_INPUT_X_POSITION", i));
	if ( !x_value.empty() )
		symbolinput_->x_ = x_value;
	doublearray  y_value;
	for (int i = 0; i < request.countValues("SYMBOL_INPUT_Y_POSITION"); i++)
		y_value.push_back((double)request("SYMBOL_INPUT_Y_POSITION", i));
	if ( !y_value.empty() )
		symbolinput_->y_ = y_value;
	doublearray  speed_value;
	for (int i = 0; i < request.countValues("SYMBOL_INPUT_WIND_SPEED"); i++)
		speed_value.push_back((double)request("SYMBOL_INPUT_WIND_SPEED", i));
	if ( !speed_value.empty() )
		symbolinput_->speed_ = speed_value;
	doublearray  direction_value;
	for (int i = 0; i < request.countValues("SYMBOL_INPUT_WIND_DIRECTION"); i++)
		direction_value.push_back((double)request("SYMBOL_INPUT_WIND_DIRECTION", i));
	if ( !direction_value.empty() )
		symbolinput_->direction_ = direction_value;
	doublearray  value_value;
	for (int i = 0; i < request.countValues("SYMBOL_INPUT_NUMBER_LIST"); i++)
		value_value.push_back((double)request("SYMBOL_INPUT_NUMBER_LIST", i));
	if ( !value_value.empty() )
		symbolinput_->value_ = value_value;
	if  (request.countValues("SYMBOL_POSITION_MODE") ) {
		string position_value = request("SYMBOL_POSITION_MODE");
		symbolinput_->position_ = position_value;
		}
	
	
}

void SymbolInputWrapper::print(ostream& out)  const
{
	out << "SymbolInputWrapper[]";
}


