# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 880-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55792);
 script_cve_id("CVE-2005-2869", "CVE-2005-3300", "CVE-2005-3301", "CVE-2005-2869");
 script_bugtraq_id(15169);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 880-1 (phpmyadmin)";
 script_name(name);

 desc = "The remote host is missing an update to phpmyadmin
announced via advisory DSA 880-1.

Several cross-site scripting vulnerabilities have been discovered in
phpmyadmin, a set of PHP-scripts to administrate MySQL over the WWW.
The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2005-2869

Andreas Kerber and Michal Cihar discovered several cross-site
scripting vulnerabilities in the error page and in the cookie
login.

CVE-2005-3300

Stefan Esser discovered missing safety checks in grab_globals.php
that could allow an attacker to induce phpmyadmin to include an
arbitrary local file.

CVE-2005-3301

Tobias Klein discovered several cross-site scripting
vulnerabilities that could allow attackers to inject arbitrary
HTML or client-side scripting.

The version in the old stable distribution (woody) has probably its
own flaws and is not easily fixable without a full audit and patch
session.  The easier way is to upgrade it from woody to sarge.

For the stable distribution (sarge) these problems have been fixed in
version 2.6.2-3sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 2.6.4-pl1-1.

We recommend that you upgrade your phpmyadmin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20880-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 880-1 (phpmyadmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpmyadmin", ver:"2.6.2-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
