#
#VID fdad8a87-7f94-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52186);
 script_cve_id("CVE-2005-0362", "CVE-2005-0363", "CVE-2005-0435", "CVE-2005-0436", "CVE-2005-0437", "CVE-2005-0438");
 script_bugtraq_id(12543,12545);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: awstats";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: awstats

CVE-2005-0362
awstats.pl in AWStats 6.2 allows remote attackers to execute arbitrary
commands via shell metacharacters in the (1) 'pluginmode', (2)
'loadplugin', or (3) 'noloadplugin' parameters.

CVE-2005-0363
awstats.pl in AWStats 4.0 and 6.2 allows remote attackers to execute
arbitrary commands via shell metacharacters in the config parameter.

CVE-2005-0435
awstats.pl in AWStats 6.3 and 6.4 allows remote attackers to read
server web logs by setting the loadplugin and pluginmode parameters to
rawlog.

CVE-2005-0436
Direct code injection vulnerability in awstats.pl in AWStats 6.3 and
6.4 allows remote attackers to execute portions of Perl code via the
PluginMode parameter.

CVE-2005-0437
Directory traversal vulnerability in awstats.pl in AWStats 6.3 and 6.4
allows remote attackers to include arbitrary Perl modules via .. (dot
dot) sequences in the loadplugin parameter.

CVE-2005-0438
awstats.pl in AWStats 6.3 and 6.4 allows remote attackers to obtain
sensitive information by setting the debug parameter.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://awstats.sourceforge.net/docs/awstats_changelog.txt
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=294488
http://packetstormsecurity.nl/0501-exploits/AWStatsVulnAnalysis.pdf
http://marc.theaimsgroup.com/?l=bugtraq&m=110840530924124
http://www.vuxml.org/freebsd/fdad8a87-7f94-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: awstats";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"awstats");
if(!isnull(bver) && revcomp(a:bver, b:"6.4")<0) {
    security_note(0, data:"Package awstats version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
