###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_iphone_conf_web_utlty_dir_trvsl_vuln.nasl 588 2008-12-09 16:15:42Z dec $
#
# Apple iPhone Configuration Web Utility Directory Traversal Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800080);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5315");
  script_bugtraq_id(32412);
  script_name("Apple iPhone Configuration Web Utility Directory Traversal Vulnerability");
  desc = "

  Overview: This host has Apple iPhone Configuration Web Utility installed
  and is prone to directory traversal vulnerability.

  Vulnerability Insight:
  The issue is caused due to an input validation error when processing HTTP
  GET requests.

  Impact:
  Successful exploitation could allow attackers to download arbitrary files
  from the affected system via directory traversal attacks.

  Impact Level: Application

  Affected Software/OS:
  iPhone Configuration Web Utility 1.0.x for Windows

  Fix: Upgrade to iPhone Configuration Utility 1.1
  http://support.apple.com/downloads/iPhone_Configuration_Utility_1_1_for_Windows

  References:
  http://secunia.com/advisories/32852
  http://lists.grok.org.uk/pipermail/full-disclosure/2008-November/065822.html

  CVSS Score:
    CVSS Base Score     : 7.8 (AV:N/AC:L/Au:NR/C:C/I:N/A:N)
    CVSS Temporal Score : 5.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of iPhone Utility");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Apple Inc.")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  iPhoneName = registry_get_sz(item:"DisplayName", key:key +item);
  if(iPhoneName =~ "iPhone Configuration.*Utility")
  {
    iPhoneVer = registry_get_sz(item:"DisplayVersion", key:key + item);
    if(!iPhoneVer){
      exit(0);
    }

    if(version_is_less(version:iPhoneVer, test_version:"1.1.0.43")){
      security_hole(0);
    }
    exit(0);
  }
}
