###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_filecopa_ftp_server_detect.nasl 5291 2009-10-22 19:36:29Z oct $
#
# FileCopa FTP Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801124);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("FileCopa FTP Server Version Detection");
  desc = "
  Overview: This script detects the installed version of FileCopa FTP Server
  and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of FileCopa FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

filecopePort = get_kb_item("Services/ftp");
if(!filecopePort){
  filecopePort = 21;
}

if(!get_port_state(filecopePort)){
  exit(0);
}

banner = get_ftp_banner(port:filecopePort);
if("FileCOPA FTP Server" >< banner)
{
  filecopeVer = eregmatch(pattern:"FileCOPA FTP Server Version ([0-9.]+)",
                          string:banner);
  if(filecopeVer[1])
  {
    set_kb_item(name:"FileCOPA-FTP-Server/Ver", value:filecopeVer[1]);
    security_note(data:"FileCOPA FTP Server version " + filecopeVer[1] +
                       " was detected on the host");
  }
}
