###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_navicopa_server_info_disc_vuln.nasl 6539 2010-01-05 17:29:24Z jan $
#
# NaviCOPA Web Server Source Code Disclosure Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800411);
  script_version("$Revision: 7922 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4529");
  script_name("NaviCOPA Web Server Source Code Disclosure Vulnerability");
  desc = "
  Overview: The host is running NaviCOPA Web Server and is prone to Source Code
  Disclosure vulnerability.

  Vulnerability Insight:
  This issue is caused by an error when handling requests with the '%20' string
  appended to the file extension.

  Impact:
  Successful exploitation will allow remote attackers to display the source code
  of arbitrary files (e.g. PHP) instead of an expected HTML response.

  Impact Level: Application

  Affected Software/OS:
  NaviCOPA Web Server version 3.0.1.2 and prior on windows.

  Fix: Upgrade to the NaviCOPA Web Server version 3.0.1.3 or later.
  For updates refer, http://www.navicopa.com/download.html

  References:
  http://secunia.com/advisories/37014
  http://xforce.iss.net/xforce/xfdb/53799
  http://www.vupen.com/english/advisories/2009/2927
  http://www.packetstormsecurity.org/0910-exploits/navicopa-disclose.txt

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for version of NaviCOPA Web Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Web Servers");
  script_dependencies("gb_navicopa_server_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

ncpaPort = get_http_port(default:80);
if(!ncpaPort){
  exit(0);
}

#Grep for KB Value
ncpaVer = get_kb_item("NaviCOPA/" + ncpaPort + "/Ver");
if(isnull(ncpaVer)){
  exit(0);
}

#check for the  NaviCOPA verison 3.0.1.2 (3.01.2)
if(version_is_less_equal(version:ncpaVer, test_version:"3.01.2")){
  security_warning(ncpaPort);
}
