###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for tk8.0, tk8.3, tk8.4 vulnerability USN-664-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840273);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "664-1");
  script_cve_id("CVE-2008-0553");
  script_name( "Ubuntu Update for tk8.0, tk8.3, tk8.4 vulnerability USN-664-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Tk could be made to overrun a buffer when loading
  certain images. If a user were tricked into opening a specially crafted
  GIF image, remote attackers could cause a denial of service or execute
  arbitrary code with user privileges.

  Affected Software/OS:
  tk8.0, tk8.3, tk8.4 vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000772.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tk8.0, tk8.3, tk8.4 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"tk8.0", ver:"8.0.5-11ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.3-dev", ver:"8.3.5-4ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.3", ver:"8.3.5-4ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4-dev", ver:"8.4.12-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4", ver:"8.4.12-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.0-dev", ver:"8.0.5-11ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4-doc", ver:"8.4.12-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.0-doc", ver:"8.0.5-11ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.3-doc", ver:"8.3.5-4ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"tk8.4-dev", ver:"8.4.16-2ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4", ver:"8.4.16-2ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4-doc", ver:"8.4.16-2ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"tk8.3-dev", ver:"8.3.5-6ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.3", ver:"8.3.5-6ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4-dev", ver:"8.4.15-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4", ver:"8.4.15-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.3-doc", ver:"8.3.5-6ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tk8.4-doc", ver:"8.4.15-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}