###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_yabsoft_aihs_xss_n_sql_inj_vuln.nasl 6182 2009-12-15 18:11:27Z dec $
#
# YABSoft AIHS Cross Site Scripting and SQL Injection Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801092);
  script_version("$Revision: 7615 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-4266", "CVE-2009-1032");
  script_bugtraq_id(37233, 34176);
  script_name("YABSoft AIHS Cross Site Scripting and SQL Injection Vulnerabilities");
  desc = "
  Overview: The host is running YABSoft AIHS and is prone to Cross-Site Scripting
  and SQL Injection vulnerabilities

  Vulnerability Insight:
  The flaws are due to:
  - Input passed to the 'gal' parameter in 'gallery_list.php' is not properly
    sanitised before being used in SQL queries.
  - Input passed to the 'text' parameter in 'search.php' is not properly
    sanitised before being returned to the user.

  Impact:
  Successful exploitation could allow remote attackers to conduct cross-site
  scripting and SQL injection attacks.

  Impact Level: Application.

  Affected Software/OS:
  YABSoft AIHS version 2.3 and prior on all running platform.

  Fix: No solution or patch is available as on 15th December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://yabsoft.com/aihs-feature.php

  References:
  http://secunia.com/advisories/34366
  http://xforce.iss.net/xforce/xfdb/49316
  http://xforce.iss.net/xforce/xfdb/54582
  http://www.exploit-db.com/exploits/10336

  CVSS Score:
    CVSS Base Score       : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score   : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check the version of YABSoft AIHS and XSS attack string");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_dependencies("gb_yabsoft_aihs_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

aihsPort = get_http_port(default:80);
if(!aihsPort){
  exit(0);
}

aihsVer = get_kb_item("www/" + aihsPort + "/YABSoft/AIHS");
if(!aihsVer){
  exit(0);
}

aihsVer = eregmatch(pattern:"^(.+) under (/.*)$", string:aihsVer);
if(!safe_checks() && aihsVer[2] != NULL)
{
  request = http_get(item:aihsVer[2] + "/search.php?text=%3Cscript%3E"+
          "alert(123456)%3C/script%3E&dosearch=Search", port:aihsPort);
  response = http_send_recv(port:aihsPort, data:request);

  if("alert(123456)" >< response)
  {
    security_hole(aihsPort);
    exit(0);
  }
}

if(aihsVer[1] != NULL)
{
  if(version_is_less_equal(version:aihsVer[1], test_version:"2.3")){
    security_hole(aihsPort);
  }
}
