###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wireshark_opcua_dos_vuln_lin.nasl 4887 2009-09-23 15:09:24Z sep $
#
# Wireshark OpcUa Dissector Denial of Service Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901032);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3241");
  script_bugtraq_id(36408);
  script_name("Wireshark OpcUa Dissector Denial of Service Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with Wireshark and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  The flaw is due to unspecified error in 'OpcUa' dissector which can be
  exploited by sending malformed OPCUA Service CallRequest packets.

  Impact:
  Successful exploitation could result in Denial of Serivce condition.

  Impact Level: Application

  Affected Software/OS:
  Wireshark version 0.99.6 to 1.0.8, 1.2.0 to 1.2.1 on Linux

  Fix: Upgrade to Wireshark 1.0.9 or 1.2.2
  http://www.wireshark.org/download.html

  References:
  http://secunia.com/advisories/36754
  http://www.wireshark.org/security/wnpa-sec-2009-06.html
  http://www.wireshark.org/security/wnpa-sec-2009-05.html
  https://bugs.wireshark.org/bugzilla/show_bug.cgi?id=3986

  CVSS Score:
    CVSS Base Score     : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Linux/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version 0.96.6 to 1.0.8 and 1.2.0 to 1.2.1
if(version_in_range(version:sharkVer, test_version:"0.99.6", test_version2:"1.0.8")||
   version_in_range(version:sharkVer, test_version:"1.2.0", test_version2:"1.2.1")){
  security_hole(0);
}
