###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_zeuscms_detect.nasl 7393 2010-02-23 12:20:36Z feb $
#
# ZeusCMS Version Detection
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902019);
  script_version("$Revision: 7734 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("ZeusCMS Version Detection");
  desc = "
  Overview: This script finds the installed ZeusCMS version and
  saves the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of ZeusCMS in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 SecPod");
  script_family("Service detection");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

zeusPort = get_http_port(default:80);
if(!zeusPort){
  zeusPort = 80;
}

if(!get_port_state(zeusPort)){
  exit(0);
}

foreach dir (make_list("/zeuscms", "/ZeusCMS", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir , "/index.php"), port:zeusPort);
  rcvRes = http_send_recv(port:zeusPort, data:sndReq);
  if("ZeusCMS" >< rcvRes)
  {
    zeusVer = eregmatch(pattern:"ZeusCMS v([0-9.]+)" , string:rcvRes);
    if(zeusVer[1] != NULL){
    set_kb_item(name:"www/" + zeusPort + "/ZeusCMS",
               value:zeusVer[1] + " under " + dir);
      security_note(data:"ZeusCMS version " + zeusVer[1] + " running at " +
                         "location " + dir + " was detected on the host");
    }
  }
}
