// Copyright (C) 2025 Rivos Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated by the ProtoZero Rust compiler plugin.
// Invoked by contrib/rust-sdk/tools/gen_rust_protos
// DO NOT EDIT.

use crate::pb_enum;
use crate::pb_msg;
use crate::protos::trace::track_event::source_location::*;

pb_enum!(ChromeCompositorSchedulerAction {
    CC_SCHEDULER_ACTION_UNSPECIFIED: 0,
    CC_SCHEDULER_ACTION_NONE: 1,
    CC_SCHEDULER_ACTION_SEND_BEGIN_MAIN_FRAME: 2,
    CC_SCHEDULER_ACTION_COMMIT: 3,
    CC_SCHEDULER_ACTION_ACTIVATE_SYNC_TREE: 4,
    CC_SCHEDULER_ACTION_DRAW_IF_POSSIBLE: 5,
    CC_SCHEDULER_ACTION_DRAW_FORCED: 6,
    CC_SCHEDULER_ACTION_DRAW_ABORT: 7,
    CC_SCHEDULER_ACTION_BEGIN_LAYER_TREE_FRAME_SINK_CREATION: 8,
    CC_SCHEDULER_ACTION_PREPARE_TILES: 9,
    CC_SCHEDULER_ACTION_INVALIDATE_LAYER_TREE_FRAME_SINK: 10,
    CC_SCHEDULER_ACTION_PERFORM_IMPL_SIDE_INVALIDATION: 11,
    CC_SCHEDULER_ACTION_NOTIFY_BEGIN_MAIN_FRAME_NOT_EXPECTED_UNTIL: 12,
    CC_SCHEDULER_ACTION_NOTIFY_BEGIN_MAIN_FRAME_NOT_EXPECTED_SOON: 13,
});

pb_enum!(BeginImplFrameArgsState {
    BEGIN_FRAME_FINISHED: 0,
    BEGIN_FRAME_USING: 1,
});

pb_enum!(BeginFrameArgsBeginFrameArgsType {
    BEGIN_FRAME_ARGS_TYPE_UNSPECIFIED: 0,
    BEGIN_FRAME_ARGS_TYPE_INVALID: 1,
    BEGIN_FRAME_ARGS_TYPE_NORMAL: 2,
    BEGIN_FRAME_ARGS_TYPE_MISSED: 3,
});

pb_enum!(MinorStateTreePriority {
    TREE_PRIORITY_UNSPECIFIED: 0,
    TREE_PRIORITY_SAME_PRIORITY_FOR_BOTH_TREES: 1,
    TREE_PRIORITY_SMOOTHNESS_TAKES_PRIORITY: 2,
    TREE_PRIORITY_NEW_CONTENT_TAKES_PRIORITY: 3,
});

pb_enum!(MinorStateScrollHandlerState {
    SCROLL_HANDLER_UNSPECIFIED: 0,
    SCROLL_AFFECTS_SCROLL_HANDLER: 1,
    SCROLL_DOES_NOT_AFFECT_SCROLL_HANDLER: 2,
});

pb_enum!(MajorStateBeginImplFrameState {
    BEGIN_IMPL_FRAME_UNSPECIFIED: 0,
    BEGIN_IMPL_FRAME_IDLE: 1,
    BEGIN_IMPL_FRAME_INSIDE_BEGIN_FRAME: 2,
    BEGIN_IMPL_FRAME_INSIDE_DEADLINE: 3,
});

pb_enum!(MajorStateBeginMainFrameState {
    BEGIN_MAIN_FRAME_UNSPECIFIED: 0,
    BEGIN_MAIN_FRAME_IDLE: 1,
    BEGIN_MAIN_FRAME_SENT: 2,
    BEGIN_MAIN_FRAME_READY_TO_COMMIT: 3,
});

pb_enum!(MajorStateLayerTreeFrameSinkState {
    LAYER_TREE_FRAME_UNSPECIFIED: 0,
    LAYER_TREE_FRAME_NONE: 1,
    LAYER_TREE_FRAME_ACTIVE: 2,
    LAYER_TREE_FRAME_CREATING: 3,
    LAYER_TREE_FRAME_WAITING_FOR_FIRST_COMMIT: 4,
    LAYER_TREE_FRAME_WAITING_FOR_FIRST_ACTIVATION: 5,
});

pb_enum!(MajorStateForcedRedrawOnTimeoutState {
    FORCED_REDRAW_UNSPECIFIED: 0,
    FORCED_REDRAW_IDLE: 1,
    FORCED_REDRAW_WAITING_FOR_COMMIT: 2,
    FORCED_REDRAW_WAITING_FOR_ACTIVATION: 3,
    FORCED_REDRAW_WAITING_FOR_DRAW: 4,
});

pb_enum!(ChromeCompositorSchedulerStateBeginImplFrameDeadlineMode {
    DEADLINE_MODE_UNSPECIFIED: 0,
    DEADLINE_MODE_NONE: 1,
    DEADLINE_MODE_IMMEDIATE: 2,
    DEADLINE_MODE_REGULAR: 3,
    DEADLINE_MODE_LATE: 4,
    DEADLINE_MODE_BLOCKED: 5,
});

pb_msg!(CompositorTimingHistory {
    begin_main_frame_queue_critical_estimate_delta_us: i64, primitive, 1,
    begin_main_frame_queue_not_critical_estimate_delta_us: i64, primitive, 2,
    begin_main_frame_start_to_ready_to_commit_estimate_delta_us: i64, primitive, 3,
    commit_to_ready_to_activate_estimate_delta_us: i64, primitive, 4,
    prepare_tiles_estimate_delta_us: i64, primitive, 5,
    activate_estimate_delta_us: i64, primitive, 6,
    draw_estimate_delta_us: i64, primitive, 7,
});

pb_msg!(BeginFrameSourceState {
    source_id: u32, primitive, 1,
    paused: bool, primitive, 2,
    num_observers: u32, primitive, 3,
    last_begin_frame_args: BeginFrameArgs, msg, 4,
});

pb_msg!(BeginFrameObserverState {
    dropped_begin_frame_args: i64, primitive, 1,
    last_begin_frame_args: BeginFrameArgs, msg, 2,
});

pb_msg!(BeginImplFrameArgs {
    updated_at_us: i64, primitive, 1,
    finished_at_us: i64, primitive, 2,
    state: BeginImplFrameArgsState, enum, 3,
    current_args: BeginFrameArgs, msg, 4,
    last_args: BeginFrameArgs, msg, 5,
    timestamps_in_us: TimestampsInUs, msg, 6,
});

pb_msg!(TimestampsInUs {
    interval_delta: i64, primitive, 1,
    now_to_deadline_delta: i64, primitive, 2,
    frame_time_to_now_delta: i64, primitive, 3,
    frame_time_to_deadline_delta: i64, primitive, 4,
    now: i64, primitive, 5,
    frame_time: i64, primitive, 6,
    deadline: i64, primitive, 7,
});

pb_msg!(BeginFrameArgs {
    type: BeginFrameArgsBeginFrameArgsType, enum, 1,
    source_id: u64, primitive, 2,
    sequence_number: u64, primitive, 3,
    frame_time_us: i64, primitive, 4,
    deadline_us: i64, primitive, 5,
    interval_delta_us: i64, primitive, 6,
    on_critical_path: bool, primitive, 7,
    animate_only: bool, primitive, 8,
    source_location_iid: u64, primitive, 9,
    source_location: SourceLocation, msg, 10,
    frames_throttled_since_last: i64, primitive, 12,
});

pb_msg!(ChromeCompositorStateMachine {
    major_state: MajorState, msg, 1,
    minor_state: MinorState, msg, 2,
});

pb_msg!(MinorState {
    commit_count: i32, primitive, 1,
    current_frame_number: i32, primitive, 2,
    last_frame_number_submit_performed: i32, primitive, 3,
    last_frame_number_draw_performed: i32, primitive, 4,
    last_frame_number_begin_main_frame_sent: i32, primitive, 5,
    did_draw: bool, primitive, 6,
    did_send_begin_main_frame_for_current_frame: bool, primitive, 7,
    did_notify_begin_main_frame_not_expected_until: bool, primitive, 8,
    did_notify_begin_main_frame_not_expected_soon: bool, primitive, 9,
    wants_begin_main_frame_not_expected: bool, primitive, 10,
    did_commit_during_frame: bool, primitive, 11,
    did_invalidate_layer_tree_frame_sink: bool, primitive, 12,
    did_perform_impl_side_invalidaion: bool, primitive, 13,
    did_prepare_tiles: bool, primitive, 14,
    consecutive_checkerboard_animations: i32, primitive, 15,
    pending_submit_frames: i32, primitive, 16,
    submit_frames_with_current_layer_tree_frame_sink: i32, primitive, 17,
    needs_redraw: bool, primitive, 18,
    needs_prepare_tiles: bool, primitive, 19,
    needs_begin_main_frame: bool, primitive, 20,
    needs_one_begin_impl_frame: bool, primitive, 21,
    visible: bool, primitive, 22,
    begin_frame_source_paused: bool, primitive, 23,
    can_draw: bool, primitive, 24,
    resourceless_draw: bool, primitive, 25,
    has_pending_tree: bool, primitive, 26,
    pending_tree_is_ready_for_activation: bool, primitive, 27,
    active_tree_needs_first_draw: bool, primitive, 28,
    active_tree_is_ready_to_draw: bool, primitive, 29,
    did_create_and_initialize_first_layer_tree_frame_sink: bool, primitive, 30,
    tree_priority: MinorStateTreePriority, enum, 31,
    scroll_handler_state: MinorStateScrollHandlerState, enum, 32,
    critical_begin_main_frame_to_activate_is_fast: bool, primitive, 33,
    main_thread_missed_last_deadline: bool, primitive, 34,
    video_needs_begin_frames: bool, primitive, 36,
    defer_begin_main_frame: bool, primitive, 37,
    last_commit_had_no_updates: bool, primitive, 38,
    did_draw_in_last_frame: bool, primitive, 39,
    did_submit_in_last_frame: bool, primitive, 40,
    needs_impl_side_invalidation: bool, primitive, 41,
    current_pending_tree_is_impl_side: bool, primitive, 42,
    previous_pending_tree_was_impl_side: bool, primitive, 43,
    processing_animation_worklets_for_active_tree: bool, primitive, 44,
    processing_animation_worklets_for_pending_tree: bool, primitive, 45,
    processing_paint_worklets_for_pending_tree: bool, primitive, 46,
});

pb_msg!(MajorState {
    next_action: ChromeCompositorSchedulerAction, enum, 1,
    begin_impl_frame_state: MajorStateBeginImplFrameState, enum, 2,
    begin_main_frame_state: MajorStateBeginMainFrameState, enum, 3,
    layer_tree_frame_sink_state: MajorStateLayerTreeFrameSinkState, enum, 4,
    forced_redraw_state: MajorStateForcedRedrawOnTimeoutState, enum, 5,
});

pb_msg!(ChromeCompositorSchedulerState {
    state_machine: ChromeCompositorStateMachine, msg, 1,
    observing_begin_frame_source: bool, primitive, 2,
    begin_impl_frame_deadline_task: bool, primitive, 3,
    pending_begin_frame_task: bool, primitive, 4,
    skipped_last_frame_missed_exceeded_deadline: bool, primitive, 5,
    inside_action: ChromeCompositorSchedulerAction, enum, 7,
    deadline_mode: ChromeCompositorSchedulerStateBeginImplFrameDeadlineMode, enum, 8,
    deadline_us: i64, primitive, 9,
    deadline_scheduled_at_us: i64, primitive, 10,
    now_us: i64, primitive, 11,
    now_to_deadline_delta_us: i64, primitive, 12,
    now_to_deadline_scheduled_at_delta_us: i64, primitive, 13,
    begin_impl_frame_args: BeginImplFrameArgs, msg, 14,
    begin_frame_observer_state: BeginFrameObserverState, msg, 15,
    begin_frame_source_state: BeginFrameSourceState, msg, 16,
    compositor_timing_history: CompositorTimingHistory, msg, 17,
});
