# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.azurestackhci import AzureStackHCIClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-azurestackhci
# USAGE
    python create_hci_edge_device.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AzureStackHCIClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.edge_devices.begin_create_or_update(
        resource_uri="subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/ArcInstance-rg/providers/Microsoft.HybridCompute/machines/Node-1",
        resource={
            "kind": "HCI",
            "properties": {
                "deviceConfiguration": {
                    "deviceMetadata": "",
                    "nicDetails": [
                        {
                            "adapterName": "ethernet",
                            "componentId": "VMBUS{f8615163-df3e-46c5-913f-f2d2f965ed0g} ",
                            "defaultGateway": "10.10.10.1",
                            "defaultIsolationId": "0",
                            "dnsServers": ["100.10.10.1"],
                            "driverVersion": "10.0.20348.1547 ",
                            "interfaceDescription": "NDIS 6.70 ",
                            "ip4Address": "10.10.10.10",
                            "subnetMask": "255.255.255.0",
                        }
                    ],
                }
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/CreateHciEdgeDevice.json
if __name__ == "__main__":
    main()
