# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import MatchConditions
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import prep_if_match, prep_if_none_match

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_table_query_request(
    *,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    top: Optional[int] = None,
    select: Optional[str] = None,
    filter: Optional[str] = None,
    next_table_name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json;odata=minimalmetadata")

    # Construct URL
    _url = "/Tables"

    # Construct parameters
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if next_table_name is not None:
        _params["NextTableName"] = _SERIALIZER.query("next_table_name", next_table_name, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_table_create_request(
    *,
    json: _models.TableProperties,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    response_preference: Optional[Union[str, _models.ResponseFormat]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json;odata=minimalmetadata")

    # Construct URL
    _url = "/Tables"

    # Construct parameters
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    if response_preference is not None:
        _headers["Prefer"] = _SERIALIZER.header("response_preference", response_preference, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, json=json, **kwargs)


def build_table_delete_request(table: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/Tables('{table}')"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_table_query_entities_request(
    table: str,
    *,
    timeout: Optional[int] = None,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    top: Optional[int] = None,
    select: Optional[str] = None,
    filter: Optional[str] = None,
    next_partition_key: Optional[str] = None,
    next_row_key: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json;odata=minimalmetadata")

    # Construct URL
    _url = "/{table}()"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if next_partition_key is not None:
        _params["NextPartitionKey"] = _SERIALIZER.query("next_partition_key", next_partition_key, "str")
    if next_row_key is not None:
        _params["NextRowKey"] = _SERIALIZER.query("next_row_key", next_row_key, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_table_query_entity_with_partition_and_row_key_request(  # pylint: disable=name-too-long
    table: str,
    partition_key: str,
    row_key: str,
    *,
    timeout: Optional[int] = None,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    select: Optional[str] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json;odata=minimalmetadata")

    # Construct URL
    _url = "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
        "partitionKey": _SERIALIZER.url("partition_key", partition_key, "str"),
        "rowKey": _SERIALIZER.url("row_key", row_key, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_table_update_entity_request(
    table: str,
    partition_key: str,
    row_key: str,
    *,
    timeout: Optional[int] = None,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
        "partitionKey": _SERIALIZER.url("partition_key", partition_key, "str"),
        "rowKey": _SERIALIZER.url("row_key", row_key, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_table_merge_entity_request(
    table: str,
    partition_key: str,
    row_key: str,
    *,
    timeout: Optional[int] = None,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
        "partitionKey": _SERIALIZER.url("partition_key", partition_key, "str"),
        "rowKey": _SERIALIZER.url("row_key", row_key, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_table_delete_entity_request(
    table: str,
    partition_key: str,
    row_key: str,
    *,
    etag: str,
    match_condition: MatchConditions,
    timeout: Optional[int] = None,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json;odata=minimalmetadata")

    # Construct URL
    _url = "/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
        "partitionKey": _SERIALIZER.url("partition_key", partition_key, "str"),
        "rowKey": _SERIALIZER.url("row_key", row_key, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_table_insert_entity_request(
    table: str,
    *,
    timeout: Optional[int] = None,
    format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
    response_preference: Optional[Union[str, _models.ResponseFormat]] = None,
    json: Optional[Dict[str, Any]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    data_service_version: Literal["3.0"] = kwargs.pop("data_service_version", _headers.pop("DataServiceVersion", "3.0"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/json;odata=minimalmetadata")

    # Construct URL
    _url = "/{table}"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if format is not None:
        _params["$format"] = _SERIALIZER.query("format", format, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["DataServiceVersion"] = _SERIALIZER.header("data_service_version", data_service_version, "str")
    if response_preference is not None:
        _headers["Prefer"] = _SERIALIZER.header("response_preference", response_preference, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, json=json, **kwargs)


def build_table_get_access_policy_request(table: str, *, timeout: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = "/{table}"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_table_set_access_policy_request(
    table: str, *, timeout: Optional[int] = None, content: Any = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = "/{table}"
    path_format_arguments = {
        "table": _SERIALIZER.url("table", table, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, content=content, **kwargs)


def build_service_set_properties_request(*, content: Any, timeout: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["service"] = kwargs.pop("restype", _params.pop("restype", "service"))
    comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = "/"

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, content=content, **kwargs)


def build_service_get_properties_request(*, timeout: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["service"] = kwargs.pop("restype", _params.pop("restype", "service"))
    comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = "/"

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_service_get_statistics_request(*, timeout: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype: Literal["service"] = kwargs.pop("restype", _params.pop("restype", "service"))
    comp: Literal["stats"] = kwargs.pop("comp", _params.pop("comp", "stats"))
    version: Literal["2019-02-02"] = kwargs.pop("version", _headers.pop("x-ms-version", "2019-02-02"))
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = "/"

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class TableOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.table.AzureTable`'s
        :attr:`table` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def query(
        self,
        *,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        top: Optional[int] = None,
        select: Optional[str] = None,
        filter: Optional[str] = None,
        next_table_name: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TableQueryResponse:
        """Queries tables under the given account.

        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword top: Maximum number of records to return. Default value is None.
        :paramtype top: int
        :keyword select: Select expression using OData notation. Limits the columns on each record to
         just those requested, e.g. "$select=PolicyAssignmentId, ResourceId". Default value is None.
        :paramtype select: str
        :keyword filter: OData filter expression. Default value is None.
        :paramtype filter: str
        :keyword next_table_name: A table query continuation token from a previous call. Default value
         is None.
        :paramtype next_table_name: str
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: TableQueryResponse
        :rtype: ~azure.table.models.TableQueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        cls: ClsType[_models.TableQueryResponse] = kwargs.pop("cls", None)

        request = build_table_query_request(
            format=format,
            top=top,
            select=select,
            filter=filter,
            next_table_name=next_table_name,
            data_service_version=data_service_version,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-continuation-NextTableName"] = self._deserialize(
            "str", response.headers.get("x-ms-continuation-NextTableName")
        )

        deserialized = self._deserialize("TableQueryResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def create(
        self,
        table_properties: _models.TableProperties,
        *,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        response_preference: Optional[Union[str, _models.ResponseFormat]] = None,
        **kwargs: Any
    ) -> Optional[_models.TableResponse]:
        """Creates a new table under the given account.

        :param table_properties: The Table properties. Required.
        :type table_properties: ~azure.table.models.TableProperties
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword response_preference: Specifies whether the response should include the inserted entity
         in the payload. Possible values are return-no-content and return-content. Known values are:
         "return-no-content" and "return-content". Default value is None.
        :paramtype response_preference: str or ~azure.table.models.ResponseFormat
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: TableResponse or None
        :rtype: ~azure.table.models.TableResponse or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        content_type: str = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json;odata=nometadata")
        )
        cls: ClsType[Optional[_models.TableResponse]] = kwargs.pop("cls", None)

        _json = self._serialize.body(table_properties, "TableProperties")

        request = build_table_create_request(
            format=format,
            response_preference=response_preference,
            data_service_version=data_service_version,
            content_type=content_type,
            version=self._config.version,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201, 204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        response_headers = {}
        if response.status_code == 201:
            response_headers["x-ms-client-request-id"] = self._deserialize(
                "str", response.headers.get("x-ms-client-request-id")
            )
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
            response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
            response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
            response_headers["Preference-Applied"] = self._deserialize(
                "str", response.headers.get("Preference-Applied")
            )

            deserialized = self._deserialize("TableResponse", pipeline_response)

        if response.status_code == 204:
            response_headers["x-ms-client-request-id"] = self._deserialize(
                "str", response.headers.get("x-ms-client-request-id")
            )
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
            response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
            response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
            response_headers["Preference-Applied"] = self._deserialize(
                "str", response.headers.get("Preference-Applied")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def delete(self, table: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Operation permanently deletes the specified table.

        :param table: The name of the table. Required.
        :type table: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_table_delete_request(
            table=table,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def query_entities(
        self,
        table: str,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        top: Optional[int] = None,
        select: Optional[str] = None,
        filter: Optional[str] = None,
        next_partition_key: Optional[str] = None,
        next_row_key: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TableEntityQueryResponse:
        """Queries entities in a table.

        :param table: The name of the table. Required.
        :type table: str
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword top: Maximum number of records to return. Default value is None.
        :paramtype top: int
        :keyword select: Select expression using OData notation. Limits the columns on each record to
         just those requested, e.g. "$select=PolicyAssignmentId, ResourceId". Default value is None.
        :paramtype select: str
        :keyword filter: OData filter expression. Default value is None.
        :paramtype filter: str
        :keyword next_partition_key: An entity query continuation token from a previous call. Default
         value is None.
        :paramtype next_partition_key: str
        :keyword next_row_key: An entity query continuation token from a previous call. Default value
         is None.
        :paramtype next_row_key: str
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: TableEntityQueryResponse
        :rtype: ~azure.table.models.TableEntityQueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        cls: ClsType[_models.TableEntityQueryResponse] = kwargs.pop("cls", None)

        request = build_table_query_entities_request(
            table=table,
            timeout=timeout,
            format=format,
            top=top,
            select=select,
            filter=filter,
            next_partition_key=next_partition_key,
            next_row_key=next_row_key,
            data_service_version=data_service_version,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-continuation-NextPartitionKey"] = self._deserialize(
            "str", response.headers.get("x-ms-continuation-NextPartitionKey")
        )
        response_headers["x-ms-continuation-NextRowKey"] = self._deserialize(
            "str", response.headers.get("x-ms-continuation-NextRowKey")
        )

        deserialized = self._deserialize("TableEntityQueryResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def query_entity_with_partition_and_row_key(
        self,
        table: str,
        partition_key: str,
        row_key: str,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        select: Optional[str] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> Dict[str, Any]:
        """Queries a single entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword select: Select expression using OData notation. Limits the columns on each record to
         just those requested, e.g. "$select=PolicyAssignmentId, ResourceId". Default value is None.
        :paramtype select: str
        :keyword filter: OData filter expression. Default value is None.
        :paramtype filter: str
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: dict mapping str to any
        :rtype: dict[str, any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        cls: ClsType[Dict[str, Any]] = kwargs.pop("cls", None)

        request = build_table_query_entity_with_partition_and_row_key_request(
            table=table,
            partition_key=partition_key,
            row_key=row_key,
            timeout=timeout,
            format=format,
            select=select,
            filter=filter,
            data_service_version=data_service_version,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["x-ms-continuation-NextPartitionKey"] = self._deserialize(
            "str", response.headers.get("x-ms-continuation-NextPartitionKey")
        )
        response_headers["x-ms-continuation-NextRowKey"] = self._deserialize(
            "str", response.headers.get("x-ms-continuation-NextRowKey")
        )

        deserialized = self._deserialize("{object}", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @overload
    def update_entity(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        partition_key: str,
        row_key: str,
        table_entity_properties: Optional[Dict[str, Any]] = None,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Update entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :param table_entity_properties: The properties for the table entity. Default value is None.
        :type table_entity_properties: dict[str, any]
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_entity(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        partition_key: str,
        row_key: str,
        table_entity_properties: Optional[IO] = None,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Update entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :param table_entity_properties: The properties for the table entity. Default value is None.
        :type table_entity_properties: IO
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_entity(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        partition_key: str,
        row_key: str,
        table_entity_properties: Optional[Union[Dict[str, Any], IO]] = None,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Update entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :param table_entity_properties: The properties for the table entity. Is either a {str: Any}
         type or a IO type. Default value is None.
        :type table_entity_properties: dict[str, any] or IO
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(table_entity_properties, (IOBase, bytes)):
            _content = table_entity_properties
        else:
            if table_entity_properties is not None:
                _json = self._serialize.body(table_entity_properties, "{object}")
            else:
                _json = None

        request = build_table_update_entity_request(
            table=table,
            partition_key=partition_key,
            row_key=row_key,
            timeout=timeout,
            format=format,
            etag=etag,
            match_condition=match_condition,
            data_service_version=data_service_version,
            content_type=content_type,
            version=self._config.version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @overload
    def merge_entity(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        partition_key: str,
        row_key: str,
        table_entity_properties: Optional[Dict[str, Any]] = None,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Merge entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :param table_entity_properties: The properties for the table entity. Default value is None.
        :type table_entity_properties: dict[str, any]
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def merge_entity(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        partition_key: str,
        row_key: str,
        table_entity_properties: Optional[IO] = None,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Merge entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :param table_entity_properties: The properties for the table entity. Default value is None.
        :type table_entity_properties: IO
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def merge_entity(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        partition_key: str,
        row_key: str,
        table_entity_properties: Optional[Union[Dict[str, Any], IO]] = None,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Merge entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :param table_entity_properties: The properties for the table entity. Is either a {str: Any}
         type or a IO type. Default value is None.
        :type table_entity_properties: dict[str, any] or IO
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(table_entity_properties, (IOBase, bytes)):
            _content = table_entity_properties
        else:
            if table_entity_properties is not None:
                _json = self._serialize.body(table_entity_properties, "{object}")
            else:
                _json = None

        request = build_table_merge_entity_request(
            table=table,
            partition_key=partition_key,
            row_key=row_key,
            timeout=timeout,
            format=format,
            etag=etag,
            match_condition=match_condition,
            data_service_version=data_service_version,
            content_type=content_type,
            version=self._config.version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def delete_entity(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        partition_key: str,
        row_key: str,
        *,
        etag: str,
        match_condition: MatchConditions,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        **kwargs: Any
    ) -> None:
        """Deletes the specified entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param partition_key: The partition key of the entity. Required.
        :type partition_key: str
        :param row_key: The row key of the entity. Required.
        :type row_key: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Required.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Required.
        :paramtype match_condition: ~azure.core.MatchConditions
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_table_delete_entity_request(
            table=table,
            partition_key=partition_key,
            row_key=row_key,
            etag=etag,
            match_condition=match_condition,
            timeout=timeout,
            format=format,
            data_service_version=data_service_version,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def insert_entity(
        self,
        table: str,
        table_entity_properties: Optional[Dict[str, Any]] = None,
        *,
        timeout: Optional[int] = None,
        format: Optional[Union[str, _models.OdataMetadataFormat]] = None,
        response_preference: Optional[Union[str, _models.ResponseFormat]] = None,
        **kwargs: Any
    ) -> Optional[Dict[str, Any]]:
        """Insert entity in a table.

        :param table: The name of the table. Required.
        :type table: str
        :param table_entity_properties: The properties for the table entity. Default value is None.
        :type table_entity_properties: dict[str, any]
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword format: Specifies the media type for the response. Known values are:
         "application/json;odata=nometadata", "application/json;odata=minimalmetadata", and
         "application/json;odata=fullmetadata". Default value is None.
        :paramtype format: str or ~azure.table.models.OdataMetadataFormat
        :keyword response_preference: Specifies whether the response should include the inserted entity
         in the payload. Possible values are return-no-content and return-content. Known values are:
         "return-no-content" and "return-content". Default value is None.
        :paramtype response_preference: str or ~azure.table.models.ResponseFormat
        :keyword data_service_version: Specifies the data service version. Default value is "3.0". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype data_service_version: str
        :return: dict mapping str to any or None
        :rtype: dict[str, any] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        data_service_version: Literal["3.0"] = kwargs.pop(
            "data_service_version", _headers.pop("DataServiceVersion", "3.0")
        )
        content_type: str = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json;odata=nometadata")
        )
        cls: ClsType[Optional[Dict[str, Any]]] = kwargs.pop("cls", None)

        if table_entity_properties is not None:
            _json = self._serialize.body(table_entity_properties, "{object}")
        else:
            _json = None

        request = build_table_insert_entity_request(
            table=table,
            timeout=timeout,
            format=format,
            response_preference=response_preference,
            data_service_version=data_service_version,
            content_type=content_type,
            version=self._config.version,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201, 204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        response_headers = {}
        if response.status_code == 201:
            response_headers["x-ms-client-request-id"] = self._deserialize(
                "str", response.headers.get("x-ms-client-request-id")
            )
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
            response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
            response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Preference-Applied"] = self._deserialize(
                "str", response.headers.get("Preference-Applied")
            )
            response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

            deserialized = self._deserialize("{object}", pipeline_response)

        if response.status_code == 204:
            response_headers["x-ms-client-request-id"] = self._deserialize(
                "str", response.headers.get("x-ms-client-request-id")
            )
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
            response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
            response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Preference-Applied"] = self._deserialize(
                "str", response.headers.get("Preference-Applied")
            )
            response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def get_access_policy(
        self, table: str, *, timeout: Optional[int] = None, **kwargs: Any
    ) -> List[_models.SignedIdentifier]:
        """Retrieves details about any stored access policies specified on the table that may be used with
        Shared Access Signatures.

        :param table: The name of the table. Required.
        :type table: str
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword comp: Required query string to handle stored access policies for the table that may be
         used with Shared Access Signatures. Default value is "acl". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype comp: str
        :return: SignedIdentifier
        :rtype: ~azure.table.models.SignedIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
        cls: ClsType[List[_models.SignedIdentifier]] = kwargs.pop("cls", None)

        request = build_table_get_access_policy_request(
            table=table,
            timeout=timeout,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("[SignedIdentifier]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def set_access_policy(  # pylint: disable=inconsistent-return-statements
        self,
        table: str,
        table_acl: Optional[List[_models.SignedIdentifier]] = None,
        *,
        timeout: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """Sets stored access policies for the table that may be used with Shared Access Signatures.

        :param table: The name of the table. Required.
        :type table: str
        :param table_acl: The acls for the table. Default value is None.
        :type table_acl: ~azure.table.models.SignedIdentifier
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword comp: Required query string to handle stored access policies for the table that may be
         used with Shared Access Signatures. Default value is "acl". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype comp: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/xml"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        serialization_ctxt = {"xml": {"name": "SignedIdentifiers", "wrapped": True, "itemsName": "SignedIdentifier"}}
        if table_acl is not None:
            _content = self._serialize.body(
                table_acl, "[SignedIdentifier]", is_xml=True, serialization_ctxt=serialization_ctxt
            )
        else:
            _content = None

        request = build_table_set_access_policy_request(
            table=table,
            timeout=timeout,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)


class ServiceOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.table.AzureTable`'s
        :attr:`service` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def set_properties(  # pylint: disable=inconsistent-return-statements
        self, table_service_properties: _models.TableServiceProperties, *, timeout: Optional[int] = None, **kwargs: Any
    ) -> None:
        """Sets properties for an account's Table service endpoint, including properties for Analytics and
        CORS (Cross-Origin Resource Sharing) rules.

        :param table_service_properties: The Table Service properties. Required.
        :type table_service_properties: ~azure.table.models.TableServiceProperties
        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword restype: Required query string to set the service properties. Default value is
         "service". Note that overriding this default value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: Required query string to set the service properties. Default value is
         "properties". Note that overriding this default value may result in unsupported behavior.
        :paramtype comp: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["service"] = kwargs.pop("restype", _params.pop("restype", "service"))
        comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/xml"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = self._serialize.body(table_service_properties, "TableServiceProperties", is_xml=True)

        request = build_service_set_properties_request(
            timeout=timeout,
            restype=restype,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def get_properties(self, *, timeout: Optional[int] = None, **kwargs: Any) -> _models.TableServiceProperties:
        """Gets the properties of an account's Table service, including properties for Analytics and CORS
        (Cross-Origin Resource Sharing) rules.

        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword restype: Required query string to set the service properties. Default value is
         "service". Note that overriding this default value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: Required query string to set the service properties. Default value is
         "properties". Note that overriding this default value may result in unsupported behavior.
        :paramtype comp: str
        :return: TableServiceProperties
        :rtype: ~azure.table.models.TableServiceProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["service"] = kwargs.pop("restype", _params.pop("restype", "service"))
        comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
        cls: ClsType[_models.TableServiceProperties] = kwargs.pop("cls", None)

        request = build_service_get_properties_request(
            timeout=timeout,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))

        deserialized = self._deserialize("TableServiceProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def get_statistics(self, *, timeout: Optional[int] = None, **kwargs: Any) -> _models.TableServiceStats:
        """Retrieves statistics related to replication for the Table service. It is only available on the
        secondary location endpoint when read-access geo-redundant replication is enabled for the
        account.

        :keyword timeout: The timeout parameter is expressed in seconds. Default value is None.
        :paramtype timeout: int
        :keyword restype: Required query string to get service stats. Default value is "service". Note
         that overriding this default value may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: Required query string to get service stats. Default value is "stats". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype comp: str
        :return: TableServiceStats
        :rtype: ~azure.table.models.TableServiceStats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["service"] = kwargs.pop("restype", _params.pop("restype", "service"))
        comp: Literal["stats"] = kwargs.pop("comp", _params.pop("comp", "stats"))
        cls: ClsType[_models.TableServiceStats] = kwargs.pop("cls", None)

        request = build_service_get_statistics_request(
            timeout=timeout,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.TableServiceError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("TableServiceStats", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
