% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_date}
\alias{colformat_date}
\title{Format date cells}
\usage{
colformat_date(
  x,
  i = NULL,
  j = NULL,
  fmt_date = get_flextable_defaults()$fmt_date,
  na_str = get_flextable_defaults()$na_str,
  nan_str = get_flextable_defaults()$nan_str,
  prefix = "",
  suffix = ""
)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{fmt_date}{see \code{\link[=strptime]{strptime()}}}

\item{na_str, nan_str}{string to be used for NA and NaN values}

\item{prefix, suffix}{string to be used as prefix or suffix}
}
\description{
Format date cells in a flextable.
}
\examples{
dat <- data.frame(
  z = Sys.Date() + 1:3,
  w = Sys.Date() - 1:3
)
ft <- flextable(dat)
ft <- colformat_date(x = ft)
ft <- autofit(ft)
ft
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_datetime}()},
\code{\link{colformat_double}()},
\code{\link{colformat_image}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()},
\code{\link{set_formatter}()}
}
\concept{cells formatters}
