% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsolve.R
\name{qsolve}
\alias{qsolve}
\title{Solve a linear system over the rationals}
\usage{
qsolve(mat, rel, sign, dir = tempdir(), quiet = TRUE, shell = FALSE, ...)
}
\arguments{
\item{mat}{The A matrix (see the 4ti2 documentation or examples)}

\item{rel}{A vector of "<" or ">" relations}

\item{sign}{The signs of the individual}

\item{dir}{Directory to place the files in, without an ending /}

\item{quiet}{If FALSE, messages the 4ti2 output}

\item{shell}{Messages the shell code used to do the computation}

\item{...}{Additional arguments to pass to the function}
}
\value{
The configuration matrix of the model provided
}
\description{
qsolve runs 4ti2's qsolve program to compute the
configuration matrix A corresponding to graphical statistical
models given by a simplicial complex and levels on the nodes.
}
\examples{

if (has_4ti2()) {

# x + y > 0
# x + y < 0

mat <- rbind(
  c( 1,  1),
  c( 1,  1)
)
rel <- c(">", "<")
sign <- c(0, 0)

qsolve(mat, rel, sign, p = "arb")
qsolve(mat, rel, sign, p = "arb", quiet = FALSE)
qsolve(mat, rel, sign, p = "arb", shell = TRUE)

}


}
