% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.mids.R
\name{mice.mids}
\alias{mice.mids}
\title{Multivariate Imputation by Chained Equations (Iteration Step)}
\usage{
mice.mids(obj, newdata = NULL, maxit = 1, printFlag = TRUE, ...)
}
\arguments{
\item{obj}{An object of class \code{mids}, typically produces by a previous
call to \code{mice()} or \code{mice.mids()}}

\item{newdata}{An optional \code{data.frame} for which multiple imputations
are generated according to the model in \code{obj}.}

\item{maxit}{The number of additional Gibbs sampling iterations. The
default is 1.}

\item{printFlag}{A Boolean flag. If \code{TRUE}, diagnostic information
during the Gibbs sampling iterations will be written to the command window.
The default is \code{TRUE}.}

\item{\dots}{Named arguments that are passed down to the univariate imputation
functions.}
}
\value{
\code{mice.mids} returns an object of class \code{"mids"}.
}
\description{
Takes a \code{mids} object, performs \code{maxit} iterations and
produces a new object of class \code{"mids"}.
}
\details{
This function enables the user to split up the computations of the Gibbs
sampler into smaller parts. This is useful for the following reasons:

\itemize{
\item To add a few extra iteration to an existing solution.
\item If RAM memory is exhausted. Returning to prompt/session
level may alleviate such problems.
\item To customize convergence statistics at specific points, e.g.,
after every \code{maxit} iterations to monitor convergence.
}

The imputation model itself is specified in the \code{\link{mice}()} function
and cannot be changed in \code{mice.mids()}. The state of the random
generator is saved with the \code{mids} object. This ensures that the
imputations are reproducible.
}
\examples{
imp1 <- mice(nhanes, maxit = 1, seed = 123)
imp2 <- mice.mids(imp1)

# yields the same result as
imp <- mice(nhanes, maxit = 2, seed = 123)

# verification
identical(imp$imp, imp2$imp)
#
}
\seealso{
\code{\link{complete}}, \code{\link{mice}}, \code{\link{set.seed}},
\code{\link{mids}}
}
\keyword{iteration}
