/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

public class Shell
implements Cloneable {
    private static final char[] DEFAULT_QUOTING_TRIGGER_CHARS = new char[]{' '};
    private String shellCommand;
    private List<String> shellArgs = new ArrayList<String>();
    private boolean quotedArgumentsEnabled = true;
    private boolean unconditionallyQuote = false;
    private String executable;
    private String workingDir;
    private boolean quotedExecutableEnabled = true;
    private boolean doubleQuotedArgumentEscaped = false;
    private boolean singleQuotedArgumentEscaped = false;
    private boolean doubleQuotedExecutableEscaped = false;
    private boolean singleQuotedExecutableEscaped = false;
    private char argQuoteDelimiter = (char)34;
    private char exeQuoteDelimiter = (char)34;
    private String argumentEscapePattern = "\\%s";

    public void setUnconditionalQuoting(boolean unconditionallyQuote) {
        this.unconditionallyQuote = unconditionallyQuote;
    }

    public void setShellCommand(String shellCommand) {
        this.shellCommand = shellCommand;
    }

    public String getShellCommand() {
        return this.shellCommand;
    }

    public void setShellArgs(String[] shellArgs) {
        this.shellArgs.clear();
        this.shellArgs.addAll(Arrays.asList(shellArgs));
    }

    public String[] getShellArgs() {
        if (this.shellArgs == null || this.shellArgs.isEmpty()) {
            return null;
        }
        return this.shellArgs.toArray(new String[0]);
    }

    public List<String> getCommandLine(String executable, String[] arguments) {
        return this.getRawCommandLine(executable, arguments);
    }

    protected String quoteOneItem(String inputString, boolean isExecutable) {
        char[] escapeChars = this.getEscapeChars(this.isSingleQuotedExecutableEscaped(), this.isDoubleQuotedExecutableEscaped());
        return StringUtils.quoteAndEscape(inputString, isExecutable ? this.getExecutableQuoteDelimiter() : this.getArgumentQuoteDelimiter(), escapeChars, this.getQuotingTriggerChars(), '\\', this.unconditionallyQuote);
    }

    protected List<String> getRawCommandLine(String executable, String[] arguments) {
        ArrayList<String> commandLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (executable != null) {
            String preamble = this.getExecutionPreamble();
            if (preamble != null) {
                sb.append(preamble);
            }
            if (this.isQuotedExecutableEnabled()) {
                sb.append(this.quoteOneItem(this.getOriginalExecutable(), true));
            } else {
                sb.append(this.getExecutable());
            }
        }
        for (String argument : arguments) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (this.isQuotedArgumentsEnabled()) {
                sb.append(this.quoteOneItem(argument, false));
                continue;
            }
            sb.append(argument);
        }
        commandLine.add(sb.toString());
        return commandLine;
    }

    protected char[] getQuotingTriggerChars() {
        return DEFAULT_QUOTING_TRIGGER_CHARS;
    }

    protected String getExecutionPreamble() {
        return null;
    }

    protected char[] getEscapeChars(boolean includeSingleQuote, boolean includeDoubleQuote) {
        StringBuilder buf = new StringBuilder(2);
        if (includeSingleQuote) {
            buf.append('\'');
        }
        if (includeDoubleQuote) {
            buf.append('\"');
        }
        char[] result = new char[buf.length()];
        buf.getChars(0, buf.length(), result, 0);
        return result;
    }

    protected boolean isDoubleQuotedArgumentEscaped() {
        return this.doubleQuotedArgumentEscaped;
    }

    protected boolean isSingleQuotedArgumentEscaped() {
        return this.singleQuotedArgumentEscaped;
    }

    protected boolean isDoubleQuotedExecutableEscaped() {
        return this.doubleQuotedExecutableEscaped;
    }

    protected boolean isSingleQuotedExecutableEscaped() {
        return this.singleQuotedExecutableEscaped;
    }

    protected void setArgumentQuoteDelimiter(char argQuoteDelimiter) {
        this.argQuoteDelimiter = argQuoteDelimiter;
    }

    protected char getArgumentQuoteDelimiter() {
        return this.argQuoteDelimiter;
    }

    protected void setExecutableQuoteDelimiter(char exeQuoteDelimiter) {
        this.exeQuoteDelimiter = exeQuoteDelimiter;
    }

    protected char getExecutableQuoteDelimiter() {
        return this.exeQuoteDelimiter;
    }

    protected void setArgumentEscapePattern(String argumentEscapePattern) {
        this.argumentEscapePattern = argumentEscapePattern;
    }

    protected String getArgumentEscapePattern() {
        return this.argumentEscapePattern;
    }

    public List<String> getShellCommandLine(String[] arguments) {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.getShellCommand() != null) {
            commandLine.add(this.getShellCommand());
        }
        if (this.getShellArgs() != null) {
            commandLine.addAll(this.getShellArgsList());
        }
        commandLine.addAll(this.getCommandLine(this.getOriginalExecutable(), arguments));
        return commandLine;
    }

    public List<String> getShellArgsList() {
        return this.shellArgs;
    }

    public void addShellArg(String arg) {
        this.shellArgs.add(arg);
    }

    public void setQuotedArgumentsEnabled(boolean quotedArgumentsEnabled) {
        this.quotedArgumentsEnabled = quotedArgumentsEnabled;
    }

    public boolean isQuotedArgumentsEnabled() {
        return this.quotedArgumentsEnabled;
    }

    public void setQuotedExecutableEnabled(boolean quotedExecutableEnabled) {
        this.quotedExecutableEnabled = quotedExecutableEnabled;
    }

    public boolean isQuotedExecutableEnabled() {
        return this.quotedExecutableEnabled;
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setWorkingDirectory(String path) {
        if (path != null) {
            this.workingDir = path;
        }
    }

    public void setWorkingDirectory(File workingDir) {
        if (workingDir != null) {
            this.workingDir = workingDir.getAbsolutePath();
        }
    }

    public File getWorkingDirectory() {
        return this.workingDir == null ? null : new File(this.workingDir);
    }

    public String getWorkingDirectoryAsString() {
        return this.workingDir;
    }

    public void clearArguments() {
        this.shellArgs.clear();
    }

    public Object clone() {
        Shell shell = new Shell();
        shell.setExecutable(this.getExecutable());
        shell.setWorkingDirectory(this.getWorkingDirectory());
        shell.setShellArgs(this.getShellArgs());
        return shell;
    }

    public String getOriginalExecutable() {
        return this.executable;
    }

    public List<String> getOriginalCommandLine(String executable, String[] arguments) {
        return this.getRawCommandLine(executable, arguments);
    }

    protected void setDoubleQuotedArgumentEscaped(boolean doubleQuotedArgumentEscaped) {
        this.doubleQuotedArgumentEscaped = doubleQuotedArgumentEscaped;
    }

    protected void setDoubleQuotedExecutableEscaped(boolean doubleQuotedExecutableEscaped) {
        this.doubleQuotedExecutableEscaped = doubleQuotedExecutableEscaped;
    }

    protected void setSingleQuotedArgumentEscaped(boolean singleQuotedArgumentEscaped) {
        this.singleQuotedArgumentEscaped = singleQuotedArgumentEscaped;
    }

    protected void setSingleQuotedExecutableEscaped(boolean singleQuotedExecutableEscaped) {
        this.singleQuotedExecutableEscaped = singleQuotedExecutableEscaped;
    }
}

