#![cfg(feature = "macros")]
#![cfg(feature = "std")]

use tabled::{
    col, row,
    settings::{format::Format, object::Segment, Alignment, Modify, Padding},
};

use crate::matrix::Matrix;
use testing_table::test_table;

test_table!(
    row_pair_test,
    row!(
        Matrix::new(3, 3)
            .with(Modify::new(Segment::all()).with(Alignment::left()))
            .with(Modify::new(Segment::all()).with(Padding::new(3, 1, 0, 0)))
            .with(Modify::new(Segment::all()).with(Format::content(|s| format!("[{s}]")))),
        Matrix::new(4, 4)
            .with(Modify::new(Segment::all()).with(Alignment::right()))
            .with(Modify::new(Segment::all()).with(Padding::new(1, 1, 1, 1)))
            .with(Modify::new(Segment::all()).with(Format::content(|s| format!("({s})")))),
    ),
    "+--------------------------------------------------------+-------------------------------------------------------------+"
    "| +-------+--------------+--------------+--------------+ | +-----+------------+------------+------------+------------+ |"
    "| |   [N] |   [column 0] |   [column 1] |   [column 2] | | |     |            |            |            |            | |"
    "| +-------+--------------+--------------+--------------+ | | (N) | (column 0) | (column 1) | (column 2) | (column 3) | |"
    "| |   [0] |   [0-0]      |   [0-1]      |   [0-2]      | | |     |            |            |            |            | |"
    "| +-------+--------------+--------------+--------------+ | +-----+------------+------------+------------+------------+ |"
    "| |   [1] |   [1-0]      |   [1-1]      |   [1-2]      | | |     |            |            |            |            | |"
    "| +-------+--------------+--------------+--------------+ | | (0) |      (0-0) |      (0-1) |      (0-2) |      (0-3) | |"
    "| |   [2] |   [2-0]      |   [2-1]      |   [2-2]      | | |     |            |            |            |            | |"
    "| +-------+--------------+--------------+--------------+ | +-----+------------+------------+------------+------------+ |"
    "|                                                        | |     |            |            |            |            | |"
    "|                                                        | | (1) |      (1-0) |      (1-1) |      (1-2) |      (1-3) | |"
    "|                                                        | |     |            |            |            |            | |"
    "|                                                        | +-----+------------+------------+------------+------------+ |"
    "|                                                        | |     |            |            |            |            | |"
    "|                                                        | | (2) |      (2-0) |      (2-1) |      (2-2) |      (2-3) | |"
    "|                                                        | |     |            |            |            |            | |"
    "|                                                        | +-----+------------+------------+------------+------------+ |"
    "|                                                        | |     |            |            |            |            | |"
    "|                                                        | | (3) |      (3-0) |      (3-1) |      (3-2) |      (3-3) | |"
    "|                                                        | |     |            |            |            |            | |"
    "|                                                        | +-----+------------+------------+------------+------------+ |"
    "+--------------------------------------------------------+-------------------------------------------------------------+"
);

test_table!(
    col_pair_test,
    col!(
        Matrix::new(3, 3)
            .with(Modify::new(Segment::all()).with(Alignment::left()))
            .with(Modify::new(Segment::all()).with(Padding::new(3, 1, 0, 0)))
            .with(Modify::new(Segment::all()).with(Format::content(|s| format!("[{s}]")))),
        Matrix::new(4, 4)
            .with(Modify::new(Segment::all()).with(Alignment::right()))
            .with(Modify::new(Segment::all()).with(Padding::new(1, 1, 1, 1)))
            .with(Modify::new(Segment::all()).with(Format::content(|s| format!("({s})")))),
    ),
    "+-------------------------------------------------------------+"
    "| +-------+--------------+--------------+--------------+      |"
    "| |   [N] |   [column 0] |   [column 1] |   [column 2] |      |"
    "| +-------+--------------+--------------+--------------+      |"
    "| |   [0] |   [0-0]      |   [0-1]      |   [0-2]      |      |"
    "| +-------+--------------+--------------+--------------+      |"
    "| |   [1] |   [1-0]      |   [1-1]      |   [1-2]      |      |"
    "| +-------+--------------+--------------+--------------+      |"
    "| |   [2] |   [2-0]      |   [2-1]      |   [2-2]      |      |"
    "| +-------+--------------+--------------+--------------+      |"
    "+-------------------------------------------------------------+"
    "| +-----+------------+------------+------------+------------+ |"
    "| |     |            |            |            |            | |"
    "| | (N) | (column 0) | (column 1) | (column 2) | (column 3) | |"
    "| |     |            |            |            |            | |"
    "| +-----+------------+------------+------------+------------+ |"
    "| |     |            |            |            |            | |"
    "| | (0) |      (0-0) |      (0-1) |      (0-2) |      (0-3) | |"
    "| |     |            |            |            |            | |"
    "| +-----+------------+------------+------------+------------+ |"
    "| |     |            |            |            |            | |"
    "| | (1) |      (1-0) |      (1-1) |      (1-2) |      (1-3) | |"
    "| |     |            |            |            |            | |"
    "| +-----+------------+------------+------------+------------+ |"
    "| |     |            |            |            |            | |"
    "| | (2) |      (2-0) |      (2-1) |      (2-2) |      (2-3) | |"
    "| |     |            |            |            |            | |"
    "| +-----+------------+------------+------------+------------+ |"
    "| |     |            |            |            |            | |"
    "| | (3) |      (3-0) |      (3-1) |      (3-2) |      (3-3) | |"
    "| |     |            |            |            |            | |"
    "| +-----+------------+------------+------------+------------+ |"
    "+-------------------------------------------------------------+"
);

test_table!(
    row_duplication_test,
    row!(
        Matrix::new(3, 3)
            .with(Modify::new(Segment::all()).with(Alignment::left()))
            .with(Modify::new(Segment::all()).with(Padding::new(3, 1, 0, 0)))
            .with(Modify::new(Segment::all()).with(Format::content(|s| format!("[{s}]"))));
        3
    ),
    "+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+"
    "| +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ |"
    "| |   [N] |   [column 0] |   [column 1] |   [column 2] | | |   [N] |   [column 0] |   [column 1] |   [column 2] | | |   [N] |   [column 0] |   [column 1] |   [column 2] | |"
    "| +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ |"
    "| |   [0] |   [0-0]      |   [0-1]      |   [0-2]      | | |   [0] |   [0-0]      |   [0-1]      |   [0-2]      | | |   [0] |   [0-0]      |   [0-1]      |   [0-2]      | |"
    "| +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ |"
    "| |   [1] |   [1-0]      |   [1-1]      |   [1-2]      | | |   [1] |   [1-0]      |   [1-1]      |   [1-2]      | | |   [1] |   [1-0]      |   [1-1]      |   [1-2]      | |"
    "| +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ |"
    "| |   [2] |   [2-0]      |   [2-1]      |   [2-2]      | | |   [2] |   [2-0]      |   [2-1]      |   [2-2]      | | |   [2] |   [2-0]      |   [2-1]      |   [2-2]      | |"
    "| +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ | +-------+--------------+--------------+--------------+ |"
    "+--------------------------------------------------------+--------------------------------------------------------+--------------------------------------------------------+"
);

test_table!(
    col_and_rows_test,
    col!(
        row!(
            Matrix::new(3, 3)
                .with(Modify::new(Segment::all()).with(Alignment::left()))
                .with(Modify::new(Segment::all()).with(Padding::new(3, 1, 0, 0)))
                .with(Modify::new(Segment::all()).with(Format::content(|s| format!("[{s}]")))),
            Matrix::new(4, 4)
                .with(Modify::new(Segment::all()).with(Alignment::right()))
                .with(Modify::new(Segment::all()).with(Padding::new(1, 1, 1, 1)))
                .with(Modify::new(Segment::all()).with(Format::content(|s| format!("({s})")))),
        ),
        Matrix::new(3, 5)
            .with(Modify::new(Segment::all()).with(Alignment::left()))
            .with(Modify::new(Segment::all()).with(Padding::new(2, 2, 0, 0)))
            .with(Modify::new(Segment::all()).with(Format::content(|s| format!("[{s}]")))),
    ),
    "+--------------------------------------------------------------------------------------------------------------------------+"
    "| +--------------------------------------------------------+-------------------------------------------------------------+ |"
    "| | +-------+--------------+--------------+--------------+ | +-----+------------+------------+------------+------------+ | |"
    "| | |   [N] |   [column 0] |   [column 1] |   [column 2] | | |     |            |            |            |            | | |"
    "| | +-------+--------------+--------------+--------------+ | | (N) | (column 0) | (column 1) | (column 2) | (column 3) | | |"
    "| | |   [0] |   [0-0]      |   [0-1]      |   [0-2]      | | |     |            |            |            |            | | |"
    "| | +-------+--------------+--------------+--------------+ | +-----+------------+------------+------------+------------+ | |"
    "| | |   [1] |   [1-0]      |   [1-1]      |   [1-2]      | | |     |            |            |            |            | | |"
    "| | +-------+--------------+--------------+--------------+ | | (0) |      (0-0) |      (0-1) |      (0-2) |      (0-3) | | |"
    "| | |   [2] |   [2-0]      |   [2-1]      |   [2-2]      | | |     |            |            |            |            | | |"
    "| | +-------+--------------+--------------+--------------+ | +-----+------------+------------+------------+------------+ | |"
    "| |                                                        | |     |            |            |            |            | | |"
    "| |                                                        | | (1) |      (1-0) |      (1-1) |      (1-2) |      (1-3) | | |"
    "| |                                                        | |     |            |            |            |            | | |"
    "| |                                                        | +-----+------------+------------+------------+------------+ | |"
    "| |                                                        | |     |            |            |            |            | | |"
    "| |                                                        | | (2) |      (2-0) |      (2-1) |      (2-2) |      (2-3) | | |"
    "| |                                                        | |     |            |            |            |            | | |"
    "| |                                                        | +-----+------------+------------+------------+------------+ | |"
    "| |                                                        | |     |            |            |            |            | | |"
    "| |                                                        | | (3) |      (3-0) |      (3-1) |      (3-2) |      (3-3) | | |"
    "| |                                                        | |     |            |            |            |            | | |"
    "| |                                                        | +-----+------------+------------+------------+------------+ | |"
    "| +--------------------------------------------------------+-------------------------------------------------------------+ |"
    "+--------------------------------------------------------------------------------------------------------------------------+"
    "| +-------+--------------+--------------+--------------+--------------+--------------+                                     |"
    "| |  [N]  |  [column 0]  |  [column 1]  |  [column 2]  |  [column 3]  |  [column 4]  |                                     |"
    "| +-------+--------------+--------------+--------------+--------------+--------------+                                     |"
    "| |  [0]  |  [0-0]       |  [0-1]       |  [0-2]       |  [0-3]       |  [0-4]       |                                     |"
    "| +-------+--------------+--------------+--------------+--------------+--------------+                                     |"
    "| |  [1]  |  [1-0]       |  [1-1]       |  [1-2]       |  [1-3]       |  [1-4]       |                                     |"
    "| +-------+--------------+--------------+--------------+--------------+--------------+                                     |"
    "| |  [2]  |  [2-0]       |  [2-1]       |  [2-2]       |  [2-3]       |  [2-4]       |                                     |"
    "| +-------+--------------+--------------+--------------+--------------+--------------+                                     |"
    "+--------------------------------------------------------------------------------------------------------------------------+"
);

test_table!(
    row_and_col_test,
    row!(
        col!(
            Matrix::new(3, 3)
                .with(Modify::new(Segment::all()).with(Alignment::left()))
                .with(Modify::new(Segment::all()).with(Padding::new(3, 1, 0, 0)))
                .with(Modify::new(Segment::all()).with(Format::content(|s| format!("[{s}]")))),
            Matrix::new(4, 4)
                .with(Modify::new(Segment::all()).with(Alignment::right()))
                .with(Modify::new(Segment::all()).with(Padding::new(1, 1, 1, 1)))
                .with(Modify::new(Segment::all()).with(Format::content(|s| format!("({s})")))),
        ),
        Matrix::new(3, 5)
            .with(Modify::new(Segment::all()).with(Alignment::left()))
            .with(Modify::new(Segment::all()).with(Padding::new(2, 2, 0, 0)))
            .with(Modify::new(Segment::all()).with(Format::content(|s| format!("[{s}]")))),
    ),
    "+-----------------------------------------------------------------+--------------------------------------------------------------------------------------+"
    "| +-------------------------------------------------------------+ | +-------+--------------+--------------+--------------+--------------+--------------+ |"
    "| | +-------+--------------+--------------+--------------+      | | |  [N]  |  [column 0]  |  [column 1]  |  [column 2]  |  [column 3]  |  [column 4]  | |"
    "| | |   [N] |   [column 0] |   [column 1] |   [column 2] |      | | +-------+--------------+--------------+--------------+--------------+--------------+ |"
    "| | +-------+--------------+--------------+--------------+      | | |  [0]  |  [0-0]       |  [0-1]       |  [0-2]       |  [0-3]       |  [0-4]       | |"
    "| | |   [0] |   [0-0]      |   [0-1]      |   [0-2]      |      | | +-------+--------------+--------------+--------------+--------------+--------------+ |"
    "| | +-------+--------------+--------------+--------------+      | | |  [1]  |  [1-0]       |  [1-1]       |  [1-2]       |  [1-3]       |  [1-4]       | |"
    "| | |   [1] |   [1-0]      |   [1-1]      |   [1-2]      |      | | +-------+--------------+--------------+--------------+--------------+--------------+ |"
    "| | +-------+--------------+--------------+--------------+      | | |  [2]  |  [2-0]       |  [2-1]       |  [2-2]       |  [2-3]       |  [2-4]       | |"
    "| | |   [2] |   [2-0]      |   [2-1]      |   [2-2]      |      | | +-------+--------------+--------------+--------------+--------------+--------------+ |"
    "| | +-------+--------------+--------------+--------------+      | |                                                                                      |"
    "| +-------------------------------------------------------------+ |                                                                                      |"
    "| | +-----+------------+------------+------------+------------+ | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | | (N) | (column 0) | (column 1) | (column 2) | (column 3) | | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | +-----+------------+------------+------------+------------+ | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | | (0) |      (0-0) |      (0-1) |      (0-2) |      (0-3) | | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | +-----+------------+------------+------------+------------+ | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | | (1) |      (1-0) |      (1-1) |      (1-2) |      (1-3) | | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | +-----+------------+------------+------------+------------+ | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | | (2) |      (2-0) |      (2-1) |      (2-2) |      (2-3) | | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | +-----+------------+------------+------------+------------+ | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | | (3) |      (3-0) |      (3-1) |      (3-2) |      (3-3) | | |                                                                                      |"
    "| | |     |            |            |            |            | | |                                                                                      |"
    "| | +-----+------------+------------+------------+------------+ | |                                                                                      |"
    "| +-------------------------------------------------------------+ |                                                                                      |"
    "+-----------------------------------------------------------------+--------------------------------------------------------------------------------------+"
);

test_table!(
    row_str_test,
    row!("hello", "world"),
    "+-------+-------+"
    "| hello | world |"
    "+-------+-------+"
);

test_table!(
    row_str_duplication_test,
    row!("duplicate me"; 5),
    "+--------------+--------------+--------------+--------------+--------------+"
    "| duplicate me | duplicate me | duplicate me | duplicate me | duplicate me |"
    "+--------------+--------------+--------------+--------------+--------------+"
);

test_table!(
    row_display_mixed_test,
    row!("str", "string".to_string(), 55, false),
    "+-----+--------+----+-------+"
    "| str | string | 55 | false |"
    "+-----+--------+----+-------+"
);

test_table!(
    col_display_mixed_test,
    col!("str", "string".to_string(), 55, false),
    "+--------+"
    "| str    |"
    "+--------+"
    "| string |"
    "+--------+"
    "| 55     |"
    "+--------+"
    "| false  |"
    "+--------+"
);
