/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import writer2latex.util.SimpleDOMBuilder;

public class SimpleXMLParser
extends DefaultHandler {
    private SimpleDOMBuilder builder = new SimpleDOMBuilder();

    public static Document parse(InputStream is) throws IOException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SimpleXMLParser handler = new SimpleXMLParser();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
            return handler.getDOM();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Oops - failed to get XML parser!?");
            e.printStackTrace();
            return null;
        }
    }

    public Document getDOM() {
        return this.builder.getDOM();
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startElement(String nameSpace, String localName, String qName, Attributes attributes) {
        this.builder.startElement(qName);
        int nLen = attributes.getLength();
        for (int i = 0; i < nLen; ++i) {
            this.builder.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
    }

    @Override
    public void endElement(String nameSpace, String localName, String qName) {
        this.builder.endElement();
    }

    @Override
    public void characters(char[] characters, int nStart, int nEnd) throws SAXException {
        this.builder.characters(new String(characters, nStart, nEnd));
    }
}

