// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +xcvalu -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg | FileCheck %s

#include <stdint.h>
#include <riscv_corev_alu.h>

// CHECK-LABEL: @test_alu_sle(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = icmp sle i32 [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    [[SLE_I:%.*]] = zext i1 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[SLE_I]]
//
int test_alu_sle(int32_t a, int32_t b) {
  return __riscv_cv_alu_sle(a, b);
}

// CHECK-LABEL: @test_alu_sleu(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = icmp ule i32 [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    [[SLEU_I:%.*]] = zext i1 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[SLEU_I]]
//
int test_alu_sleu(uint32_t a, uint32_t b) {
  return __riscv_cv_alu_sleu(a, b);
}

// CHECK-LABEL: @test_alu_min(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[ELT_MIN_I:%.*]] = call i32 @llvm.smin.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[ELT_MIN_I]]
//
int test_alu_min(int32_t a, int32_t b) {
  return __riscv_cv_alu_min(a, b);
}

// CHECK-LABEL: @test_alu_minu(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[ELT_MIN_I:%.*]] = call i32 @llvm.umin.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[ELT_MIN_I]]
//
int test_alu_minu(uint32_t a, uint32_t b) {
  return __riscv_cv_alu_minu(a, b);
}

// CHECK-LABEL: @test_alu_max(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[ELT_MAX_I:%.*]] = call i32 @llvm.smax.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[ELT_MAX_I]]
//
int test_alu_max(int32_t a, int32_t b) {
  return __riscv_cv_alu_max(a, b);
}

// CHECK-LABEL: @test_alu_maxu(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[ELT_MAX_I:%.*]] = call i32 @llvm.umax.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[ELT_MAX_I]]
//
int test_alu_maxu(uint32_t a, uint32_t b) {
  return __riscv_cv_alu_maxu(a, b);
}

// CHECK-LABEL: @test_alu_exths(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = sext i16 [[A:%.*]] to i32
// CHECK-NEXT:    [[EXTHS_I:%.*]] = sext i16 [[A]] to i32
// CHECK-NEXT:    ret i32 [[EXTHS_I]]
//
int test_alu_exths(int16_t a) {
  return __riscv_cv_alu_exths(a);
}

// CHECK-LABEL: @test_alu_exthz(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i16 [[A:%.*]] to i32
// CHECK-NEXT:    [[EXTHZ_I:%.*]] = zext i16 [[A]] to i32
// CHECK-NEXT:    ret i32 [[EXTHZ_I]]
//
int test_alu_exthz(uint16_t a) {
  return __riscv_cv_alu_exthz(a);
}

// CHECK-LABEL: @test_alu_extbs(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = sext i8 [[A:%.*]] to i32
// CHECK-NEXT:    [[EXTBS_I:%.*]] = sext i8 [[A]] to i32
// CHECK-NEXT:    ret i32 [[EXTBS_I]]
//
int test_alu_extbs(int8_t a) {
  return __riscv_cv_alu_extbs(a);
}

// CHECK-LABEL: @test_alu_extbz(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 [[A:%.*]] to i32
// CHECK-NEXT:    [[EXTBZ_I:%.*]] = zext i8 [[A]] to i32
// CHECK-NEXT:    ret i32 [[EXTBZ_I]]
//
int test_alu_extbz(uint8_t a) {
  return __riscv_cv_alu_extbz(a);
}

// CHECK-LABEL: @test_alu_clip(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.clip(i32 [[A:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_clip(int32_t a) {
  return __riscv_cv_alu_clip(a, 0);
}

// CHECK-LABEL: @test_alu_clipu(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.clipu(i32 [[A:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_clipu(uint32_t a) {
  return __riscv_cv_alu_clipu(a, 0);
}

// CHECK-LABEL: @test_alu_addN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.addN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_addN(int32_t a, int32_t b) {
  return __riscv_cv_alu_addN(a, b, 0);
}

// CHECK-LABEL: @test_alu_adduN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.adduN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_adduN(uint32_t a, uint32_t b) {
  return __riscv_cv_alu_adduN(a, b, 0);
}

// CHECK-LABEL: @test_alu_addRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.addRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_addRN(int32_t a, int32_t b) {
  return __riscv_cv_alu_addRN(a, b, 0);
}

// CHECK-LABEL: @test_alu_adduRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.adduRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_adduRN(uint32_t a, uint32_t b) {
  return __riscv_cv_alu_adduRN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subN(int32_t a, int32_t b) {
  return __riscv_cv_alu_subN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subuN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subuN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subuN(uint32_t a, uint32_t b) {
  return __riscv_cv_alu_subuN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subRN(int32_t a, int32_t b) {
  return __riscv_cv_alu_subRN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subuRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV_I:%.*]] = zext i8 0 to i32
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subuRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 [[CONV_I]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subuRN(uint32_t a, uint32_t b) {
  return __riscv_cv_alu_subuRN(a, b, 0);
}
