/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.impl.ModelCom;

public class ModelListenerAdapter
implements GraphListener {
    protected ModelCom m;
    protected ModelChangedListener L;

    public ModelListenerAdapter(ModelCom m, ModelChangedListener L) {
        this.m = m;
        this.L = L;
    }

    @Override
    public void notifyAddArray(Graph graph, Triple[] triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyAddTriple(Graph g, Triple t) {
        this.L.addedStatement(this.m.asStatement(t));
    }

    @Override
    public void notifyAddList(Graph g, List<Triple> triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        this.L.addedStatements(this.m.asStatements(it));
    }

    @Override
    public void notifyAddGraph(Graph g, Graph added) {
        this.L.addedStatements(this.m.asModel(added));
    }

    @Override
    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        this.L.removedStatements(this.m.asStatements(it));
    }

    @Override
    public void notifyDeleteTriple(Graph g, Triple t) {
        this.L.removedStatement(this.m.asStatement(t));
    }

    public void notifyAddIterator(Graph g, List<Triple> triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteList(Graph g, List<Triple> triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.L.removedStatements(this.m.asModel(removed));
    }

    @Override
    public void notifyEvent(Graph g, Object event) {
        this.L.notifyEvent(this.m, event);
    }

    public boolean equals(Object other) {
        return other instanceof ModelListenerAdapter && ((ModelListenerAdapter)other).sameAs(this);
    }

    public boolean sameAs(ModelListenerAdapter other) {
        return this.L.equals(other.L) && this.m.equals(other.m);
    }
}

