/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.apache.ws.security.saml.WSSecSignatureSAML;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;

public class SAMLTokenSignedAction
implements Action {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$action$SAMLTokenSignedAction == null ? (class$org$apache$ws$security$action$SAMLTokenSignedAction = SAMLTokenSignedAction.class$("org.apache.ws.security.action.SAMLTokenSignedAction")) : class$org$apache$ws$security$action$SAMLTokenSignedAction).getName());
    static /* synthetic */ Class class$org$apache$ws$security$action$SAMLTokenSignedAction;

    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        Crypto crypto;
        block9: {
            crypto = null;
            try {
                crypto = handler.loadSignatureCrypto(reqData);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)t.getMessage(), t);
            }
        }
        SAMLIssuer saml = this.loadSamlIssuer(handler, reqData);
        saml.setUsername(reqData.getUsername());
        saml.setUserCrypto(crypto);
        saml.setInstanceDoc(doc);
        SAMLAssertion assertion = saml.newAssertion();
        if (assertion == null) {
            throw new WSSecurityException("WSHandler: Signed SAML: no SAML token received");
        }
        String issuerKeyName = null;
        String issuerKeyPW = null;
        Crypto issuerCrypto = null;
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setWsConfig(reqData.getWssConfig());
        String password = null;
        if (saml.isSenderVouches()) {
            issuerKeyName = saml.getIssuerKeyName();
            issuerKeyPW = saml.getIssuerKeyPassword();
            issuerCrypto = saml.getIssuerCrypto();
        } else {
            password = handler.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
            wsSign.setUserInfo(reqData.getUsername(), password);
        }
        if (reqData.getSigKeyId() != 0) {
            wsSign.setKeyIdentifierType(reqData.getSigKeyId());
        }
        if (reqData.getSignatureParts().size() > 0) {
            wsSign.setParts(reqData.getSignatureParts());
        }
        try {
            wsSign.build(doc, crypto, assertion, issuerCrypto, issuerKeyName, issuerKeyPW, reqData.getSecHeader());
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("Error when signing the SAML token: ", e);
        }
    }

    protected SAMLIssuer loadSamlIssuer(WSHandler handler, RequestData reqData) {
        String samlPropFile = handler.getString("samlPropFile", reqData.getMsgContext());
        return SAMLIssuerFactory.getInstance(samlPropFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

