#ifndef TRANSLATION_TRANSLATION_H
#define TRANSLATION_TRANSLATION_H

#include "core/locale.h"

#include <stdint.h>

#define CUSTOM_TRANSLATION 10000

typedef enum {
    TR_NO_PATCH_TITLE,
    TR_NO_PATCH_MESSAGE,
    TR_MISSING_FONTS_TITLE,
    TR_MISSING_FONTS_MESSAGE,
    TR_NO_EDITOR_TITLE,
    TR_NO_EDITOR_MESSAGE,
    TR_INVALID_LANGUAGE_TITLE,
    TR_INVALID_LANGUAGE_MESSAGE,
    TR_AUTO_CYCLE_TEMPLES,
    TR_BUTTON_OK,
    TR_BUTTON_CANCEL,
    TR_BUTTON_RESET_DEFAULTS,
    TR_BUTTON_CONFIGURE_HOTKEYS,
    TR_CONFIG_ARE_YOU_SURE,
    TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS,
    TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS,
    TR_CONFIG_TITLE,
    TR_CONFIG_HEADER_GENERAL,
    TR_CONFIG_HEADER_UI_CHANGES,
    TR_CONFIG_HEADER_GAMEPLAY_CHANGES,
    TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES,
    TR_CONFIG_LANGUAGE_LABEL,
    TR_CONFIG_LANGUAGE_DEFAULT,
    TR_CONFIG_GAME_SPEED,
    TR_CONFIG_VIDEO,
    TR_CONFIG_FULLSCREEN,
    TR_CONFIG_WINDOWED_RESOLUTION,
    TR_CONFIG_DISPLAY_SCALE,
    TR_CONFIG_CURSOR_SCALE,
    TR_CONFIG_USE_COLOR_CURSORS,
    TR_CONFIG_AUDIO,
    TR_CONFIG_VOLUME,
    TR_CONFIG_ENABLE_AUDIO,
    TR_CONFIG_MUSIC,
    TR_CONFIG_SPEECH,
    TR_CONFIG_EFFECTS,
    TR_CONFIG_CITY_SOUNDS,
    TR_CONFIG_VIDEO_SOUND,
    TR_CONFIG_SCROLL_SPEED,
    TR_CONFIG_SHOW_INTRO_VIDEO,
    TR_CONFIG_SIDEBAR_INFO,
    TR_CONFIG_SMOOTH_SCROLLING,
    TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING,
    TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE,
    TR_CONFIG_ALLOW_CYCLING_TEMPLES,
    TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE,
    TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE_HOUSES,
    TR_CONFIG_SHOW_MARKET_RANGE,
    TR_CONFIG_SHOW_CONSTRUCTION_SIZE,
    TR_CONFIG_HIGHLIGHT_LEGIONS,
    TR_CONFIG_ROTATE_MANUALLY,
    TR_CONFIG_UI_INVERSE_MAP_DRAG,
    TR_CONFIG_UI_MESSAGE_ALERTS,
    TR_CONFIG_UI_SHOW_GRID,
    TR_CONFIG_UI_SHOW_PARTIAL_GRID_AROUND_CONSTRUCTION,
    TR_CONFIG_UI_ALWAYS_SHOW_ROTATION_BUTTONS,
    TR_CONFIG_FIX_IMMIGRATION_BUG,
    TR_CONFIG_FIX_100_YEAR_GHOSTS,
    TR_CONFIG_FIX_EDITOR_EVENTS,
    TR_CONFIG_COMPLETE_RATING_COLUMNS,
    TR_CONFIG_GRANDFESTIVAL,
    TR_CONFIG_DIFFICULTY,
    TR_CONFIG_MAX_GRAND_TEMPLES,
    TR_CONFIG_INFINITE,
    TR_CONFIG_GODS_EFFECTS,
    TR_CONFIG_JEALOUS_GODS,
    TR_CONFIG_GLOBAL_LABOUR,
    TR_CONFIG_SCHOOL_WALKERS,
    TR_CONFIG_RETIRE_AT_60,
    TR_CONFIG_FIXED_WORKERS,
    TR_CONFIG_EXTRA_FORTS,
    TR_CONFIG_WOLVES_BLOCK,
    TR_CONFIG_DYNAMIC_GRANARIES,
    TR_CONFIG_MORE_STOCKPILE,
    TR_CONFIG_NO_SUPPLIER_DISTRIBUTION,
    TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS,
    TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD,
    TR_CONFIG_GRANARIES_GET_DOUBLE,
    TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES,
    TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD,
    TR_CONFIG_FARMS_DELIVER_CLOSE,
    TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES,
    TR_CONFIG_ALL_HOUSES_MERGE,
    TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE,
    TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY,
    TR_CONFIG_MULTIPLE_BARRACKS,
    TR_CONFIG_NOT_ACCEPTING_WAREHOUSES,
    TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS,
    TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS,
    TR_CONFIG_SHOW_MILITARY_SIDEBAR,
    TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG,
    TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY,
    TR_CONFIG_AUTO_KILL_ANIMALS,
    TR_CONFIG_SHOW_ROAMING_PATH,
    TR_CONFIG_DRAW_CLOUD_SHADOWS,
    TR_CONFIG_ASK_CONFIRMATION_ON_FILE_OVERWRITE,
    TR_CONFIG_GATES_DEFAULT_TO_PASS_ALL_WALKERS,
    TR_HOTKEY_TITLE,
    TR_HOTKEY_LABEL,
    TR_HOTKEY_ALTERNATIVE_LABEL,
    TR_HOTKEY_HEADER_ARROWS,
    TR_HOTKEY_HEADER_GLOBAL,
    TR_HOTKEY_HEADER_CITY,
    TR_HOTKEY_HEADER_ADVISORS,
    TR_HOTKEY_HEADER_OVERLAYS,
    TR_HOTKEY_HEADER_BOOKMARKS,
    TR_HOTKEY_HEADER_EDITOR,
    TR_HOTKEY_HEADER_BUILD,
    TR_HOTKEY_ARROW_UP,
    TR_HOTKEY_ARROW_DOWN,
    TR_HOTKEY_ARROW_LEFT,
    TR_HOTKEY_ARROW_RIGHT,
    TR_HOTKEY_TOGGLE_FULLSCREEN,
    TR_HOTKEY_CENTER_WINDOW,
    TR_HOTKEY_RESIZE_TO_640,
    TR_HOTKEY_RESIZE_TO_800,
    TR_HOTKEY_RESIZE_TO_1024,
    TR_HOTKEY_SAVE_SCREENSHOT,
    TR_HOTKEY_SAVE_CITY_SCREENSHOT,
    TR_HOTKEY_SAVE_MINIMAP_SCREENSHOT,
    TR_HOTKEY_BUILD_CLONE,
    TR_HOTKEY_COPY_SETTINGS,
    TR_HOTKEY_PASTE_SETTINGS,
    TR_HOTKEY_MOTHBALL_TOGGLE,
    TR_HOTKEY_SPECIAL_ORDERS,
    TR_HOTKEY_LOAD_FILE,
    TR_HOTKEY_SAVE_FILE,
    TR_HOTKEY_INCREASE_GAME_SPEED,
    TR_HOTKEY_DECREASE_GAME_SPEED,
    TR_HOTKEY_TOGGLE_PAUSE,
    TR_HOTKEY_CYCLE_LEGION,
    TR_HOTKEY_ROTATE_MAP_LEFT,
    TR_HOTKEY_ROTATE_MAP_RIGHT,
    TR_HOTKEY_ZOOM_IN,
    TR_HOTKEY_ZOOM_OUT,
    TR_HOTKEY_RESET_ZOOM,
    TR_HOTKEY_SHOW_ADVISOR_LABOR,
    TR_HOTKEY_SHOW_ADVISOR_MILITARY,
    TR_HOTKEY_SHOW_ADVISOR_IMPERIAL,
    TR_HOTKEY_SHOW_ADVISOR_RATINGS,
    TR_HOTKEY_SHOW_ADVISOR_TRADE,
    TR_HOTKEY_SHOW_ADVISOR_POPULATION,
    TR_HOTKEY_SHOW_ADVISOR_HEALTH,
    TR_HOTKEY_SHOW_ADVISOR_EDUCATION,
    TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT,
    TR_HOTKEY_SHOW_ADVISOR_RELIGION,
    TR_HOTKEY_SHOW_ADVISOR_FINANCIAL,
    TR_HOTKEY_SHOW_ADVISOR_CHIEF,
    TR_HOTKEY_SHOW_ADVISOR_HOUSING,
    TR_HOTKEY_TOGGLE_OVERLAY,
    TR_HOTKEY_SHOW_OVERLAY_RELATIVE,
    TR_HOTKEY_SHOW_OVERLAY_WATER,
    TR_HOTKEY_SHOW_OVERLAY_FIRE,
    TR_HOTKEY_SHOW_OVERLAY_DAMAGE,
    TR_HOTKEY_SHOW_OVERLAY_CRIME,
    TR_HOTKEY_SHOW_OVERLAY_PROBLEMS,
    TR_HOTKEY_ROTATE_BUILDING,
    TR_HOTKEY_ROTATE_BUILDING_BACK,
    TR_HOTKEY_GO_TO_BOOKMARK_1,
    TR_HOTKEY_GO_TO_BOOKMARK_2,
    TR_HOTKEY_GO_TO_BOOKMARK_3,
    TR_HOTKEY_GO_TO_BOOKMARK_4,
    TR_HOTKEY_SET_BOOKMARK_1,
    TR_HOTKEY_SET_BOOKMARK_2,
    TR_HOTKEY_SET_BOOKMARK_3,
    TR_HOTKEY_SET_BOOKMARK_4,
    TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO,
    TR_HOTKEY_EDIT_TITLE,
    TR_BUILDING_ARCHITECT_GUILD,
    TR_BUILDING_ARCHITECT_GUILD_DESC,
    TR_BUILDING_GRAND_TEMPLE_ADD_MODULE,
    TR_BUILDING_GRAND_TEMPLE_CERES,
    TR_BUILDING_GRAND_TEMPLE_NEPTUNE,
    TR_BUILDING_GRAND_TEMPLE_MERCURY,
    TR_BUILDING_GRAND_TEMPLE_MARS,
    TR_BUILDING_GRAND_TEMPLE_VENUS,
    TR_BUILDING_PANTHEON,
    TR_BUILDING_GRAND_TEMPLE_CERES_DESC,
    TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC,
    TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC,
    TR_BUILDING_GRAND_TEMPLE_MARS_DESC,
    TR_BUILDING_GRAND_TEMPLE_VENUS_DESC,
    TR_BUILDING_PANTHEON_DESC,
    TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC,
    TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC,
    TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC,
    TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC,
    TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC,
    TR_BUILDING_PANTHEON_BONUS_DESC,
    TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC,
    TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC,
    TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC,
    TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC,
    TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC,
    TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC,
    TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC,
    TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC,
    TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC,
    TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC,
    TR_BUILDING_PANTHEON_MODULE_1_DESC,
    TR_BUILDING_PANTHEON_MODULE_2_DESC,
    TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1,
    TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2,
    TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1,
    TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2,
    TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1,
    TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2,
    TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1,
    TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2,
    TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1,
    TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2,
    TR_BUILDING_PANTHEON_DESC_MODULE_1,
    TR_BUILDING_PANTHEON_DESC_MODULE_2,
    TR_BUILDING_GRAND_TEMPLE_MENU,
    TR_BUILDING_ROADBLOCK,
    TR_BUILDING_ROADBLOCK_DESC,
    TR_BUILDING_WORK_CAMP,
    TR_BUILDING_WORK_CAMP_DESC,
    TR_HEADER_HOUSING,
    TR_ADVISOR_HOUSING_ROOM,
    TR_ADVISOR_HOUSING_NO_ROOM,
    TR_ADVISOR_RESIDENCES_USING_POTTERY,
    TR_ADVISOR_RESIDENCES_USING_FURNITURE,
    TR_ADVISOR_RESIDENCES_USING_OIL,
    TR_ADVISOR_RESIDENCES_USING_WINE,
    TR_ADVISOR_TOTAL_NUM_HOUSES,
    TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY,
    TR_ADVISOR_TOTAL_HOUSING_CAPACITY,
    TR_ADVISOR_ADVISOR_HEADER_HOUSING,
    TR_ADVISOR_BUTTON_GRAPHS,
    TR_ADVISOR_HOUSING_PROSPERITY_RATING,
    TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES,
    TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS,
    TR_ADVISOR_AVERAGE_TAX,
    TR_ADVISOR_AVERAGE_AGE,
    TR_ADVISOR_PERCENT_IN_WORKFORCE,
    TR_ADVISOR_BIRTHS_LAST_YEAR,
    TR_ADVISOR_DEATHS_LAST_YEAR,
    TR_ADVISOR_TOTAL_POPULATION,
    TR_ADVISOR_IN_STORAGE,
    TR_ADVISOR_FROM_GRANARIES,
    TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE,
    TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT,
    TR_ADVISOR_KEEP_STOCKPILING,
    TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_REACHED,
    TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS,
    TR_ADVISOR_POPULATION_AGE,
    TR_ADVISOR_POPULATION_RESIDENTS,
    TR_ADVISOR_POPULATION_DWELLERS,
    TR_REQUIRED_RESOURCES,
    TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC,
    TR_CONSTRUCTION_PHASE,
    TR_ADD_MODULE,
    TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED,
    TR_BUILDING_CERES_TEMPLE_QUOTE,
    TR_BUILDING_NEPTUNE_TEMPLE_QUOTE,
    TR_BUILDING_MERCURY_TEMPLE_QUOTE,
    TR_BUILDING_MARS_TEMPLE_QUOTE,
    TR_BUILDING_VENUS_TEMPLE_QUOTE,
    TR_BUILDING_PANTHEON_QUOTE,
    TR_BUILDING_GRAND_TEMPLE_PHASE_1,
    TR_BUILDING_GRAND_TEMPLE_PHASE_2,
    TR_BUILDING_GRAND_TEMPLE_PHASE_3,
    TR_BUILDING_GRAND_TEMPLE_PHASE_4,
    TR_BUILDING_GRAND_TEMPLE_PHASE_5,
    TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT,
    TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT,
    TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT,
    TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT,
    TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT,
    TR_BUILDING_MENU_TREES,
    TR_BUILDING_MENU_PATHS,
    TR_BUILDING_MENU_PARKS,
    TR_BUILDING_SMALL_POND,
    TR_BUILDING_LARGE_POND,
    TR_BUILDING_PINE_TREE,
    TR_BUILDING_FIR_TREE,
    TR_BUILDING_OAK_TREE,
    TR_BUILDING_ELM_TREE,
    TR_BUILDING_FIG_TREE,
    TR_BUILDING_PLUM_TREE,
    TR_BUILDING_PALM_TREE,
    TR_BUILDING_DATE_TREE,
    TR_BUILDING_PINE_PATH,
    TR_BUILDING_FIR_PATH,
    TR_BUILDING_OAK_PATH,
    TR_BUILDING_ELM_PATH,
    TR_BUILDING_FIG_PATH,
    TR_BUILDING_PLUM_PATH,
    TR_BUILDING_PALM_PATH,
    TR_BUILDING_DATE_PATH,
    TR_BUILDING_BLUE_PAVILION,
    TR_BUILDING_RED_PAVILION,
    TR_BUILDING_ORANGE_PAVILION,
    TR_BUILDING_YELLOW_PAVILION,
    TR_BUILDING_GREEN_PAVILION,
    TR_BUILDING_SMALL_STATUE_ALT,
    TR_BUILDING_SMALL_STATUE_ALT_B,
    TR_BUILDING_OBELISK,
    TR_BUILDING_POND_DESC,
    TR_BUILDING_WINDOW_POND,
    TR_BUILDING_OBELISK_DESC,
    TR_ADVISOR_FINANCE_LEVIES,
    TR_CONFIRM_DELETE_MONUMENT,
    TR_SELECT_EPITHET_PROMPT_HEADER,
    TR_SELECT_EPITHET_PROMPT_TEXT,
    TR_BUILDING_INFO_MONTHLY_LEVY,
    TR_BUILDING_MESS_HALL,
    TR_BUILDING_MESS_HALL_DESC,
    TR_BUILDING_MESS_HALL_FULFILLMENT,
    TR_BUILDING_MESS_HALL_TROOP_HUNGER,
    TR_BUILDING_MESS_HALL_TROOP_HUNGER_1,
    TR_BUILDING_MESS_HALL_TROOP_HUNGER_2,
    TR_BUILDING_MESS_HALL_TROOP_HUNGER_3,
    TR_BUILDING_MESS_HALL_TROOP_HUNGER_4,
    TR_BUILDING_MESS_HALL_TROOP_HUNGER_5,
    TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1,
    TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2,
    TR_BUILDING_MESS_HALL_NO_SOLDIERS,
    TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED,
    TR_BUILDING_MESS_HALL_NO_FOOD,
    TR_MESS_HALL_SPECIAL_ORDERS_HEADER,
    TR_BUILDING_BARRACKS_FOOD_WARNING,
    TR_BUILDING_BARRACKS_FOOD_WARNING_2,
    TR_BUILDING_LEGION_FOOD_WARNING_1,
    TR_BUILDING_LEGION_FOOD_WARNING_2,
    TR_BUILDING_LEGION_STARVING,
    TR_ADVISOR_TRADE_MAX,
    TR_ADVISOR_TRADE_NO_LIMIT,
    TR_ADVISOR_TRADE_IMPORTABLE,
    TR_ADVISOR_TRADE_EXPORTABLE,
    TR_ADVISOR_TRADE_IMPORTABLE_EXPORTABLE,
    TR_ADVISOR_TRADE_NO_BUYERS,
    TR_ADVISOR_TRADE_NO_SELLERS,
    TR_ADVISOR_TRADE_NOT_IMPORTING,
    TR_ADVISOR_TRADE_NOT_EXPORTING,
    TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE,
    TR_ADVISOR_TRADE_RESOURCE_NOT_STORABLE_OR_TRADABLE,
    TR_ADVISOR_OPEN_TO_IMPORT,
    TR_ADVISOR_OPEN_TO_EXPORT,
    TR_ADVISOR_LEGION_FOOD_SATISFIED,
    TR_ADVISOR_LEGION_FOOD_NEEDED,
    TR_ADVISOR_LEGION_FOOD_CRITICAL,
    TR_ADVISOR_LEGION_MONTHS_FOOD_STORED,
    TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD,
    TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD,
    TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING,
    TR_MARKET_SPECIAL_ORDERS_HEADER,
    TR_DOCK_SPECIAL_ORDERS_HEADER,
    TR_TEMPLE_SPECIAL_ORDERS_HEADER,
    TR_TAVERN_SPECIAL_ORDERS_HEADER,
    TR_WARNING_NO_MESS_HALL,
    TR_WARNING_MAX_GRAND_TEMPLES,
    TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE,
    TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE,
    TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING,
    TR_BUILDING_DEPOT,
    TR_BUILDING_CAT_DEPOT,
    TR_BUILDING_DEPOT_DESC,
    TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING,
    TR_FIGURE_TYPE_WORK_CAMP_WORKER,
    TR_FIGURE_TYPE_WORK_CAMP_SLAVE,
    TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT,
    TR_FIGURE_TYPE_MESS_HALL_SUPPLIER,
    TR_FIGURE_TYPE_MESS_HALL_COLLECTOR,
    TR_BUILDING_CERES_TEMPLE_MODULE_DESC,
    TR_BUILDING_VENUS_TEMPLE_MODULE_DESC,
    TR_BUILDING_MARS_TEMPLE_MODULE_DESC,
    TR_BUILDING_SMALL_TEMPLE_CERES_NAME,
    TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME,
    TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME,
    TR_BUILDING_SMALL_TEMPLE_MARS_NAME,
    TR_BUILDING_SMALL_TEMPLE_VENUS_NAME,
    TR_FIGURE_TYPE_PRIEST_SUPPLIER,
    TR_BUILDING_DOCK_CITIES_CONFIG_DESC,
    TR_BUILDING_DOCK_CITIES_NO_ROUTES,
    TR_PHRASE_FIGURE_MISSIONARY_EXACT_4,
    TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL,
    TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES,
    TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE,
    TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY,
    TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS,
    TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS,
    TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES,
    TR_TOOLTIP_BUTTON_MOTHBALL_ON,
    TR_TOOLTIP_BUTTON_MOTHBALL_OFF,
    TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES,
    TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN,
    TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS,
    TR_BUILDING_LIGHTHOUSE,
    TR_BUILDING_CARAVANSERAI,
    TR_BUILDING_CARAVANSERAI_DESC,
    TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER,
    TR_BUILDING_CARAVANSERAI_PHASE_1,
    TR_BUILDING_CARAVANSERAI_PHASE_2,
    TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT,
    TR_BUILDING_CARAVANSERAI_PHASE_2_TEXT,
    TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER,
    TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR,
    TR_BUILDING_CARAVANSERAI_POLICY_TITLE,
    TR_BUILDING_CARAVANSERAI_NO_POLICY,
    TR_BUILDING_CARAVANSERAI_POLICY_TEXT,
    TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE,
    TR_BUILDING_CARAVANSERAI_POLICY_1,
    TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE,
    TR_BUILDING_CARAVANSERAI_POLICY_2,
    TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE,
    TR_BUILDING_CARAVANSERAI_POLICY_3,
    TR_BUILDING_CARAVANSERAI_NO_FOOD,
    TR_BUILDING_LIGHTHOUSE_PHASE_1,
    TR_BUILDING_LIGHTHOUSE_PHASE_2,
    TR_BUILDING_LIGHTHOUSE_PHASE_3,
    TR_BUILDING_LIGHTHOUSE_PHASE_4,
    TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT,
    TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT,
    TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT,
    TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT,
    TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC,
    TR_BUILDING_LIGHTHOUSE_BONUS_DESC,
    TR_BUILDING_LIGHTHOUSE_POLICY_TITLE,
    TR_BUILDING_LIGHTHOUSE_NO_POLICY,
    TR_BUILDING_LIGHTHOUSE_POLICY_TEXT,
    TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE,
    TR_BUILDING_LIGHTHOUSE_POLICY_1,
    TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE,
    TR_BUILDING_LIGHTHOUSE_POLICY_2,
    TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE,
    TR_BUILDING_LIGHTHOUSE_POLICY_3,
    TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS,
    TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE,
    TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE,
    TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE,
    TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING,
    TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING,
    TR_CITY_MESSAGE_TITLE_VENUS_BLESSING,
    TR_CITY_MESSAGE_TEXT_VENUS_BLESSING,
    TR_BUILDING_MENU_STATUES,
    TR_BUILDING_MENU_GOV_RES,
    TR_OVERLAY_ROADS,
    TR_NO_EXTRA_ASSETS_TITLE,
    TR_NO_EXTRA_ASSETS_MESSAGE,
    TR_WARNING_WATER_NEEDED_FOR_BUILDING,
    TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS,
    TR_BUILDING_LEGION_FOOD_BONUS,
    TR_BUILDING_LEGION_FOOD_STATUS,
    TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER,
    TR_WARNING_RESOURCES_NOT_AVAILABLE,
    TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING,
    TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING,
    TR_BUTTON_BACK_TO_MAIN_MENU,
    TR_LABEL_PAUSE_MENU,
    TR_OVERLAY_LEVY,
    TR_TOOLTIP_OVERLAY_LEVY,
    TR_MAP_EDITOR_OPTIONS,
    TR_BUILDING_TAVERN,
    TR_BUILDING_GRAND_GARDEN,
    TR_BUILDING_TAVERN_DESC_1,
    TR_BUILDING_TAVERN_DESC_2,
    TR_BUILDING_TAVERN_DESC_3,
    TR_BUILDING_TAVERN_DESC_4,
    TR_FIGURE_TYPE_BARKEEP,
    TR_FIGURE_TYPE_BARKEEP_SUPPLIER,
    TR_OVERLAY_TAVERN,
    TR_TOOLTIP_OVERLAY_TAVERN_1,
    TR_TOOLTIP_OVERLAY_TAVERN_2,
    TR_TOOLTIP_OVERLAY_TAVERN_3,
    TR_TOOLTIP_OVERLAY_TAVERN_4,
    TR_TOOLTIP_OVERLAY_TAVERN_5,
    TR_TOOLTIP_OVERLAY_TAVERN_6,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11,
    TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12,
    TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES,
    TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES,
    TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT,
    TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR,
    TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT,
    TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD,
    TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY,
    TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE,
    TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE,
    TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY,
    TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY_TOOLTIP,
    TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_RAW_MATERIALS,
    TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_WORKSHOPS,
    TR_BUILDING_WINDOW_INDUSTRY_WHARF_AVERAGE_CATCH,
    TR_BUILDING_WINDOW_INDUSTRY_NEEDED,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE_PLURAL,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING,
    TR_SELECT_GAMES_HEADER,
    TR_SELECT_GAMES_TEXT,
    TR_BUILDING_ARENA,
    TR_BUILDING_HORSE_STATUE,
    TR_BUILDING_DOLPHIN_FOUNTAIN,
    TR_BUILDING_HEDGE_DARK,
    TR_BUILDING_HEDGE_LIGHT,
    TR_BUILDING_GARDEN_WALL,
    TR_BUILDING_LEGION_STATUE,
    TR_BUILDING_DECORATIVE_COLUMN,
    TR_BUILDING_COLOSSEUM_PHASE_1,
    TR_BUILDING_COLOSSEUM_PHASE_2,
    TR_BUILDING_COLOSSEUM_PHASE_3,
    TR_BUILDING_COLOSSEUM_PHASE_4,
    TR_BUILDING_COLOSSEUM_PHASE_1_TEXT,
    TR_BUILDING_COLOSSEUM_PHASE_2_TEXT,
    TR_BUILDING_COLOSSEUM_PHASE_3_TEXT,
    TR_BUILDING_COLOSSEUM_PHASE_4_TEXT,
    TR_BUILDING_HIPPODROME_PHASE_1,
    TR_BUILDING_HIPPODROME_PHASE_2,
    TR_BUILDING_HIPPODROME_PHASE_3,
    TR_BUILDING_HIPPODROME_PHASE_4,
    TR_BUILDING_HIPPODROME_PHASE_1_TEXT,
    TR_BUILDING_HIPPODROME_PHASE_2_TEXT,
    TR_BUILDING_HIPPODROME_PHASE_3_TEXT,
    TR_BUILDING_HIPPODROME_PHASE_4_TEXT,
    TR_BUILDING_MONUMENT_CONSTRUCTION_DESC,
    TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED,
    TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE_PLURAL,
    TR_BUILDING_INFO_TOURISM,
    TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE,
    TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE,
    TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING,
    TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING,
    TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING,
    TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING,
    TR_WINDOW_GAMES_OPTION_1,
    TR_WINDOW_GAMES_OPTION_2,
    TR_WINDOW_GAMES_OPTION_3,
    TR_WINDOW_GAMES_OPTION_4,
    TR_WINDOW_GAMES_OPTION_5,
    TR_WINDOW_GAMES_OPTION_1_DESC,
    TR_WINDOW_GAMES_OPTION_2_DESC,
    TR_WINDOW_GAMES_OPTION_3_DESC,
    TR_WINDOW_GAMES_OPTION_4_DESC,
    TR_WINDOW_GAMES_OPTION_5_DESC,
    TR_WINDOW_GAMES_COST,
    TR_WINDOW_GAMES_PERSONAL_FUNDS,
    TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS,
    TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES,
    TR_WINDOW_GAMES_NO_WATER_ACCESS,
    TR_WINDOW_GAMES_NO_VENUE,
    TR_BUILDING_SMALL_TEMPLE_PHASE_1,
    TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT,
    TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC,
    TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING,
    TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING,
    TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING,
    TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING,
    TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING,
    TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING,
    TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING,
    TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING,
    TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING,
    TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING,
    TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING,
    TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING,
    TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING,
    TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING,
    TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING,
    TR_CITY_MESSAGE_TITLE_GREAT_GAMES,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG,
    TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY,
    TR_WINDOW_BUILDING_ARENA_CLOSED,
    TR_WINDOW_BUILDING_ARENA_NO_SHOWS,
    TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS,
    TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS,
    TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS,
    TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS,
    TR_OVERLAY_ARENA_COL,
    TR_TOOLTIP_OVERLAY_ARENA_COL_1,
    TR_TOOLTIP_OVERLAY_ARENA_COL_2,
    TR_TOOLTIP_OVERLAY_ARENA_COL_3,
    TR_TOOLTIP_OVERLAY_ARENA_COL_4,
    TR_TOOLTIP_OVERLAY_ARENA_COL_5,
    TR_TOOLTIP_OVERLAY_ARENA_COL_6,
    TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE,
    TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS,
    TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER,
    TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES,
    TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED,
    TR_TOOLTIP_OVERLAY_PROBLEMS_PLAGUE,
    TR_WINDOW_BUILDING_TOURISM_DISABLED,
    TR_WINDOW_BUILDING_TOURISM_ANNUAL,
    TR_WINDOW_BUILDING_WHARF_MOTHBALLED,
    TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE,
    TR_WINDOW_ADVISOR_TOURISM,
    TR_WINDOW_FIGURE_TOURIST,
    TR_FIGURE_TYPE_TOURIST,
    TR_SAVEGAME_LARGER_VERSION_TITLE,
    TR_SAVEGAME_LARGER_VERSION_MESSAGE,
    TR_SAVEGAME_NOT_ABLE_TO_SAVE_TITLE,
    TR_SAVEGAME_NOT_ABLE_TO_SAVE_MESSAGE,
    TR_BUILDING_COLONNADE,
    TR_BUILDING_LARARIUM,
    TR_WINDOW_BUILDING_LARARIUM_DESC,
    TR_BUILDING_WATCHTOWER,
    TR_BUILDING_WATCHTOWER_DESC,
    TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS,
    TR_BUILDING_NYMPHAEUM,
    TR_BUILDING_NYMPHAEUM_DESC,
    TR_BUILDING_SMALL_MAUSOLEUM,
    TR_BUILDING_SMALL_MAUSOLEUM_DESC,
    TR_BUILDING_LARGE_MAUSOLEUM,
    TR_BUILDING_LARGE_MAUSOLEUM_DESC,
    TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1,
    TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2,
    TR_BUILDING_LARGE_MAUSOLEUM_PHASE_1_TEXT,
    TR_BUILDING_LARGE_MAUSOLEUM_PHASE_2_TEXT,
    TR_BUILDING_LARGE_MAUSOLEUM_CONSTRUCTION_DESC,
    TR_FIGURE_TYPE_WATCHMAN,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY,
    TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN,
    TR_HOTKEY_DUPLICATE_TITLE,
    TR_HOTKEY_DUPLICATE_MESSAGE,
    TR_BUILDING_GARDEN_PATH,
    TR_BUTTON_GO_TO_SITE,
    TR_BUTTON_HALT_MONUMENT_CONSTRUCTION,
    TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION,
    TR_RESOURCE_FISH,
    TR_RESOURCE_GOLD,
    TR_RESOURCE_STONE,
    TR_RESOURCE_SAND,
    TR_RESOURCE_BRICKS,
    TR_RESOURCE_CONCRETE,
    TR_WARNING_VARIANT_TOGGLE,
    TR_BUILDING_SCHOOL_UPGRADE_DESC,
    TR_BUILDING_THEATRE_UPGRADE_DESC,
    TR_BUILDING_LIBRARY_UPGRADE_DESC,
    TR_BUILDING_ACADEMY_UPGRADE_DESC,
    TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS,
    TR_WINDOW_BUILDING_WORKSHOP_STRIKING,
    TR_CITY_WARNING_SECESSION,
    TR_CITY_WARNING_WAREHOUSE_BREAKIN,
    TR_CITY_WARNING_GRANARY_BREAKIN,
    TR_CITY_WARNING_MARKET_BREAKIN,
    TR_CITY_WARNING_THEFT,
    TR_CITY_MESSAGE_TITLE_LOOTING,
    TR_CITY_MESSAGE_TEXT_LOOTING,
    TR_SIDEBAR_EXTRA_INVASIONS,
    TR_SIDEBAR_EXTRA_INVASION_UNDERWAY,
    TR_SIDEBAR_EXTRA_NO_INVASIONS,
    TR_SIDEBAR_EXTRA_INVASION_IMMINENT,
    TR_SIDEBAR_EXTRA_ENEMIES_CLOSING,
    TR_SIDEBAR_EXTRA_ENEMIES_DISTANT,
    TR_SIDEBAR_EXTRA_GODS,
    TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL,
    TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE,
    TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE,
    TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE,
    TR_SIDEBAR_EXTRA_REQUESTS_SEND,
    TR_SIDEBAR_EXTRA_REQUESTS_STOCK,
    TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK,
    TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON,
    TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON,
    TR_RETURN_ALL_TO_FORT,
    TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON,
    TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING,
    TR_OPTION_MENU_APPLY,
    TR_OPTION_MENU_COST,
    TR_FIGURE_TYPE_LOOTER,
    TR_FIGURE_TYPE_ROBBER,
    TR_OVERLAY_SENTIMENT,
    TR_OVERLAY_EFFICIENCY,
    TR_OVERLAY_STORAGES,
    TR_TOOLTIP_OVERLAY_EFFICIENCY_0,
    TR_TOOLTIP_OVERLAY_EFFICIENCY_1,
    TR_TOOLTIP_OVERLAY_EFFICIENCY_2,
    TR_TOOLTIP_OVERLAY_EFFICIENCY_3,
    TR_TOOLTIP_OVERLAY_EFFICIENCY_4,
    TR_TOOLTIP_OVERLAY_EFFICIENCY_5,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE,
    TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE,
    TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY,
    TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED,
    TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY,
    TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED,
    TR_TOOLTIP_HOLD_GAME,
    TR_TOOLTIP_NO_GAME,
    TR_WARNING_NEARBY_WOLF,
    TR_MARKET_TRADING,
    TR_MARKET_NOT_TRADING,
    TR_TAVERN_FETCHING,
    TR_TAVERN_NOT_FETCHING,
    TR_TEMPLE_DISTRIBUTING,
    TR_TEMPLE_NOT_DISTRIBUTING,
    TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR,
    TR_CITY_MESSAGE_SQUALOR,
    TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER,
    TR_WINDOW_ADVISOR_RELIGION_LARARIUMS,
    TR_WINDOW_RACE_YOUR_BET,
    TR_WINDOW_RACE_BET_BUTTON,
    TR_WINDOW_IN_PROGRESS_BET_BUTTON,
    TR_WINDOW_RACE_BET_TITLE,
    TR_WINDOW_RACE_BET_AMOUNT,
    TR_WINDOW_RACE_BET_DESCRIPTION,
    TR_WARNING_BET_VICTORY,
    TR_WARNING_BET_DEFEAT,
    TR_PERSONAL_SAVINGS,
    TR_WINDOW_RACE_BET_BLUE_HORSE,
    TR_WINDOW_RACE_BET_RED_HORSE,
    TR_WINDOW_RACE_BET_WHITE_HORSE,
    TR_WINDOW_RACE_BET_GREEN_HORSE,
    TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS,
    TR_BUILDING_COLOSSEUM_NEEDS_WORKERS,
    TR_BUILDING_HIPPODROME_NEEDS_WORKERS,
    TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS,
    TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS,
    TR_BUILDING_ROOFED_GARDEN_WALL,
    TR_BUILDING_GARDEN_WALL_GATE,
    TR_BUILDING_GARDEN_WALL_GATE_DESC,
    TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING,
    TR_BUILDING_PALISADE,
    TR_BUILDING_PALISADE_DESC,
    TR_TOOLTIP_BUTTON_ACCEPT_WORKERS,
    TR_TOOLTIP_BUTTON_STOCKPILING_ON,
    TR_TOOLTIP_BUTTON_STOCKPILING_OFF,
    TR_OVERLAY_MOTHBALL,
    TR_OVERLAY_ENEMY,
    TR_BUILDING_TAVERN_DESC_5,
    TR_OVERLAY_WAREHOUSES,
    TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION,
    TR_WINDOW_RACE_RED_HORSE_DESCRIPTION,
    TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION,
    TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION,
    TR_TOOLTIP_BUTTON_REJECT_WORKERS,
    TR_CONFIG_DIGIT_SEPARATOR,
    TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR,
    TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING,
    TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH,
    TR_BUTTON_YEARLY_AUTOSAVE_OFF,
    TR_BUTTON_YEARLY_AUTOSAVE_ON,
    TR_BUILDING_DOCK_PLAGUE_DESC,
    TR_BUILDING_GRANARY_PLAGUE_DESC,
    TR_BUILDING_GRANARY_NO_FOOD,
    TR_BUILDING_WAREHOUSE_PLAGUE_DESC,
    TR_BUILDING_WAREHOUSE_NO_GOODS,
    TR_BUILDING_HOUSE_DISEASE_DESC,
    TR_BUILDING_FUMIGATION_DESC,
    TR_OVERLAY_SICKNESS,
    TR_ADVISOR_SICKNESS_LEVEL_LOW,
    TR_ADVISOR_SICKNESS_LEVEL_MEDIUM,
    TR_ADVISOR_SICKNESS_LEVEL_HIGH,
    TR_ADVISOR_SICKNESS_LEVEL_PLAGUE,
    TR_TOOLTIP_OVERLAY_SICKNESS_NONE,
    TR_TOOLTIP_OVERLAY_SICKNESS_LOW,
    TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM,
    TR_TOOLTIP_OVERLAY_SICKNESS_HIGH,
    TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE,
    TR_CITY_MESSAGE_TITLE_SICKNESS,
    TR_CITY_MESSAGE_TEXT_SICKNESS,
    TR_FIGURES_CARTPUSHER_GOING_TO_ROME,
    TR_CITY_WARNING_DATA_COPY_SUCCESS,
    TR_CITY_WARNING_DATA_COPY_NOT_SUPPORTED,
    TR_CITY_WARNING_DATA_PASTE_SUCCESS,
    TR_CITY_WARNING_DATA_PASTE_NOT_SUPPORTED,
    TR_CITY_WARNING_DATA_MOTHBALL_ON,
    TR_CITY_WARNING_DATA_MOTHBALL_OFF,
    TR_CITY_WARNING_GOLD_NEEDED,
    TR_CITY_WARNING_BUILD_GOLD_MINE,
    TR_CITY_WARNING_SAND_NEEDED,
    TR_CITY_WARNING_BUILD_SAND_PIT,
    TR_CITY_WARNING_STONE_NEEDED,
    TR_CITY_WARNING_BUILD_STONE_QUARRY,
    TR_CITY_WARNING_SENATE_NEEDED,
    TR_CITY_WARNING_BUILD_SENATE,
    TR_HOTKEY_SHOW_OVERLAY_EFFICIENCY,
    TR_HOTKEY_SHOW_OVERLAY_FOOD_STOCKS,
    TR_HOTKEY_SHOW_OVERLAY_ENTERTAINMENT,
    TR_HOTKEY_SHOW_OVERLAY_EDUCATION,
    TR_HOTKEY_SHOW_OVERLAY_SCHOOL,
    TR_HOTKEY_SHOW_OVERLAY_LIBRARY,
    TR_HOTKEY_SHOW_OVERLAY_ACADEMY,
    TR_HOTKEY_SHOW_OVERLAY_BARBER,
    TR_HOTKEY_SHOW_OVERLAY_BATHHOUSE,
    TR_HOTKEY_SHOW_OVERLAY_CLINIC,
    TR_HOTKEY_SHOW_OVERLAY_HOSPITAL,
    TR_HOTKEY_SHOW_OVERLAY_SICKNESS,
    TR_HOTKEY_SHOW_OVERLAY_TAX_INCOME,
    TR_HOTKEY_SHOW_OVERLAY_DESIRABILITY,
    TR_HOTKEY_SHOW_OVERLAY_SENTIMENT,
    TR_HOTKEY_SHOW_OVERLAY_MOTHBALL,
    TR_HOTKEY_SHOW_OVERLAY_RELIGION,
    TR_HOTKEY_SHOW_OVERLAY_ROADS,
    TR_HOTKEY_SHOW_OVERLAY_LEVY,
    TR_HOTKEY_ROTATE_MAP_NORTH,
    TR_HOTKEY_BUILD_WHEAT_FARM,
    TR_HOTKEY_SHOW_MESSAGES,
    TR_HOTKEY_SHOW_EMPIRE_MAP,
    TR_TOGGLE_GRID,
    TR_WARNING_SCREENSHOT_SAVED,
    TR_OUT_OF_MONEY,
    TR_CITY_MESSAGE_TITLE_EMPERORS_WRATH,
    TR_CITY_MESSAGE_TEXT_EMPERORS_WRATH,
    TR_BUILDING_PALISADE_GATE,
    TR_BUILDING_PALISADE_GATE_DESC,
    TR_SAVE_DIALOG_INVALID_FILE,
    TR_SAVE_DIALOG_INVALID_FILE_DESC,
    TR_SAVE_DIALOG_INCOMPATIBLE_VERSION,
    TR_SAVE_DIALOG_NEW_FILE,
    TR_SAVE_DIALOG_SELECT_FILE,
    TR_SAVE_DIALOG_FUNDS,
    TR_SAVE_DIALOG_POPULATION,
    TR_SAVE_DIALOG_DATE,
    TR_SAVE_DIALOG_CUSTOM_SCENARIO,
    TR_SAVE_DIALOG_FIRST_MISSION,
    TR_SAVE_DIALOG_MISSION,
    TR_SAVE_DIALOG_MILITARY,
    TR_SAVE_DIALOG_PEACEFUL,
    TR_SAVE_DIALOG_FILTER,
    TR_SAVE_DIALOG_SORTING_BY_NAME,
    TR_SAVE_DIALOG_SORTING_BY_DATE,
    TR_SAVE_DIALOG_OVERWRITE_FILE,
    TR_SAVE_DIALOG_OVERWRITE_FILE_DESC,
    TR_SAVE_DIALOG_OVERWRITE_FILE_DO_NOT_ASK_AGAIN,
    TR_CITY_MESSAGE_TITLE_MARS_MINOR_CURSE_PREVENTED,
    TR_CITY_MESSAGE_TEXT_MARS_MINOR_CURSE_PREVENTED,
    TR_TOOLTIP_MONUMENT_PHASE,
    TR_TOOLTIP_MONUMENT_PHASES,
    TR_TOOLTIP_MONUMENT_RESOURCE_REQUIREMENTS,
    TR_BUILDING_GLADIATOR_STATUE,
    TR_BUILDING_HIGHWAY,
    TR_BUILDING_HIGHWAY_DESC,
    TR_BUILDING_GOLD_MINE,
    TR_BUILDING_GOLD_MINE_DESC,
    TR_BUILDING_GOLD_MINE_PRODUCTION,
    TR_BUILDING_GOLD_MINE_COMPLETE,
    TR_BUILDING_GOLD_MINE_HALTED,
    TR_BUILDING_GOLD_MINE_NO_EMPLOYEES,
    TR_BUILDING_GOLD_MINE_FULL_EMPLOYEES,
    TR_BUILDING_GOLD_MINE_MANY_EMPLOYEES,
    TR_BUILDING_GOLD_MINE_HALF_EMPLOYEES,
    TR_BUILDING_GOLD_MINE_SOME_EMPLOYEES,
    TR_BUILDING_GOLD_MINE_FEW_EMPLOYEES,
    TR_BUILDING_STONE_QUARRY,
    TR_BUILDING_STONE_QUARRY_DESC,
    TR_BUILDING_STONE_QUARRY_PRODUCTION,
    TR_BUILDING_STONE_QUARRY_COMPLETE,
    TR_BUILDING_STONE_QUARRY_HALTED,
    TR_BUILDING_STONE_QUARRY_NO_EMPLOYEES,
    TR_BUILDING_STONE_QUARRY_FULL_EMPLOYEES,
    TR_BUILDING_STONE_QUARRY_MANY_EMPLOYEES,
    TR_BUILDING_STONE_QUARRY_HALF_EMPLOYEES,
    TR_BUILDING_STONE_QUARRY_SOME_EMPLOYEES,
    TR_BUILDING_STONE_QUARRY_FEW_EMPLOYEES,
    TR_BUILDING_SAND_PIT,
    TR_BUILDING_SAND_PIT_DESC,
    TR_BUILDING_SAND_PIT_PRODUCTION,
    TR_BUILDING_SAND_PIT_COMPLETE,
    TR_BUILDING_SAND_PIT_HALTED,
    TR_BUILDING_SAND_PIT_NO_EMPLOYEES,
    TR_BUILDING_SAND_PIT_FULL_EMPLOYEES,
    TR_BUILDING_SAND_PIT_MANY_EMPLOYEES,
    TR_BUILDING_SAND_PIT_HALF_EMPLOYEES,
    TR_BUILDING_SAND_PIT_SOME_EMPLOYEES,
    TR_BUILDING_SAND_PIT_FEW_EMPLOYEES,
    TR_BUILDING_BRICKWORKS,
    TR_BUILDING_BRICKWORKS_DESC,
    TR_BUILDING_BRICKWORKS_PRODUCTION,
    TR_BUILDING_BRICKWORKS_COMPLETE,
    TR_BUILDING_BRICKWORKS_HALTED,
    TR_BUILDING_BRICKWORKS_NO_EMPLOYEES,
    TR_BUILDING_BRICKWORKS_FULL_EMPLOYEES,
    TR_BUILDING_BRICKWORKS_MANY_EMPLOYEES,
    TR_BUILDING_BRICKWORKS_HALF_EMPLOYEES,
    TR_BUILDING_BRICKWORKS_SOME_EMPLOYEES,
    TR_BUILDING_BRICKWORKS_FEW_EMPLOYEES,
    TR_BUILDING_BRICKWORKS_NO_RESOURCES,
    TR_BUILDING_BRICKWORKS_STORED_SAND,
    TR_BUILDING_BRICKWORKS_STORED_CLAY,
    TR_BUILDING_CONCRETE_MAKER,
    TR_BUILDING_CONCRETE_MAKER_DESC,
    TR_BUILDING_CONCRETE_MAKER_PRODUCTION,
    TR_BUILDING_CONCRETE_MAKER_COMPLETE,
    TR_BUILDING_CONCRETE_MAKER_HALTED,
    TR_BUILDING_CONCRETE_MAKER_NO_EMPLOYEES,
    TR_BUILDING_CONCRETE_MAKER_FULL_EMPLOYEES,
    TR_BUILDING_CONCRETE_MAKER_MANY_EMPLOYEES,
    TR_BUILDING_CONCRETE_MAKER_HALF_EMPLOYEES,
    TR_BUILDING_CONCRETE_MAKER_SOME_EMPLOYEES,
    TR_BUILDING_CONCRETE_MAKER_FEW_EMPLOYEES,
    TR_BUILDING_CONCRETE_MAKER_NO_RESOURCES,
    TR_BUILDING_CONCRETE_MAKER_STORED_SAND,
    TR_BUILDING_CONCRETE_MAKER_NO_TARGETS,
    TR_BUILDING_CONCRETE_MAKER_IMPROVE_WATER_ACCESS,
    TR_BUILDING_CITY_MINT,
    TR_BUILDING_CITY_MINT_PHASE_1,
    TR_BUILDING_CITY_MINT_PHASE_1_TEXT,
    TR_BUILDING_CITY_MINT_DESC,
    TR_BUILDING_CITY_MINT_DESC_ALTERNATIVE,
    TR_BUILDING_CITY_MINT_DESC_NO_PALACE,
    TR_BUILDING_CITY_MINT_DESC_PALACE,
    TR_BUILDING_CITY_MINT_NO_EMPLOYEES,
    TR_BUILDING_CITY_MINT_FULL_EMPLOYEES,
    TR_BUILDING_CITY_MINT_MANY_EMPLOYEES,
    TR_BUILDING_CITY_MINT_HALF_EMPLOYEES,
    TR_BUILDING_CITY_MINT_SOME_EMPLOYEES,
    TR_BUILDING_CITY_MINT_FEW_EMPLOYEES,
    TR_BUILDING_CITY_MINT_NO_GOLD,
    TR_BUILDING_CITY_MINT_STORED_GOLD,
    TR_BUILDING_CITY_MINT_NO_SENATE,
    TR_BUILDING_CITY_MINT_CONVERT,
    TR_BUILDING_CITY_MINT_GOLD_TO_DN,
    TR_BUILDING_CITY_MINT_DN_TO_GOLD,
    TR_BUILDING_CITY_MINT_CHANGE_PRODUCTION,
    TR_BUILDING_CITY_MINT_PROGRESS_WILL_BE_LOST,
    TR_ADVISOR_NO_ACTIVE_COLOSSEUM,
    TR_ADVISOR_ACTIVE_COLOSSEUM,
    TR_ADVISOR_NO_ACTIVE_HIPPODROME,
    TR_ADVISOR_ACTIVE_HIPPODROME,
    TR_WINDOW_ADVISOR_EDUCATION_MISSION_POSTS,
    TR_CITY_MESSAGE_TITLE_ENEMIES_LEAVING,
    TR_CITY_MESSAGE_TEXT_ENEMIES_LEAVING,
    TR_ZOOM,
    TR_WINDOW_ASSET_PREVIEWER_TITLE,
    TR_WINDOW_ASSET_PREVIEWER_GROUP,
    TR_WINDOW_ASSET_PREVIEWER_NO_GROUPS,
    TR_WINDOW_ASSET_PREVIEWER_TERRAIN,
    TR_WINDOW_ASSET_PREVIEWER_PLAY_ANIMATIONS,
    TR_WINDOW_ASSET_PREVIEWER_REFRESH,
    TR_WINDOW_ASSET_PREVIEWER_QUIT,
    TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NONE,
    TR_WINDOW_ASSET_PREVIEWER_TERRAIN_CENTRAL,
    TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NORTHERN,
    TR_WINDOW_ASSET_PREVIEWER_TERRAIN_DESERT,
    TR_WINDOW_ASSET_PREVIEWER_ASSET,
    TR_WINDOW_ASSET_PREVIEWER_NO_ASSETS,
    TR_WINDOW_ASSET_PREVIEWER_UNNAMED_ASSET,
    TR_WINDOW_ASSET_PREVIEWER_ANIMATION_FRAME,
    TR_WINDOW_ASSET_PREVIEWER_SHOW_ANIMATION_FRAMES,
    TR_WINDOW_ASSET_PREVIEWER_ASSETS_REFRESHED,
    TR_CHEAT_ADDED_MONEY,
    TR_CHEAT_STARTED_INVASION,
    TR_CHEAT_YEAR_ADVANCED,
    TR_CHEAT_CASTED_BLESSING,
    TR_CHEAT_TOGGLE_TOOLTIPS,
    TR_CHEAT_KILLED_ALL_WALKERS,
    TR_CHEAT_FINISHED_MONUMENTS,
    TR_CHEAT_UPDATED_MONUMENTS,
    TR_CHEAT_UNLOCKED_ALL_BUILDINGS,
    TR_CHEAT_INCITED_RIOT,
    TR_CITY_MESSAGE_TITLE_ROAD_TO_ROME_WARNING,
    TR_CITY_MESSAGE_TEXT_ROAD_TO_ROME_WARNING,
    TR_CITY_MESSAGE_TITLE_TRADE_ROUTE_PRICE_CHANGE,
    TR_CITY_MESSAGE_TEXT_TRADE_ROUTE_PRICE_CHANGE,
    TR_EDITOR_CHOOSE_CUSTOM_EMPIRE,
    TR_EDITOR_CUSTOM_EMPIRE_TITLE,
    TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_TITLE,
    TR_EDITOR_UNABLE_TO_LOAD_EMPIRE_MESSAGE,
    TR_EDITOR_SHORT_ROUTE_TEXT,
    TR_EDITOR_TOGGLE_INVASIONS,
    TR_EDITOR_REFRESH_EMPIRE,
    TR_EDITOR_CITY_PREVIEW,
    TR_EDITOR_CURRENT_COORDS,
    TR_EDITOR_SELECTED_COORDS,
    TR_EDITOR_MAX_WAGES,
    TR_EDITOR_MIN_WAGES,
    TR_EDITOR_FAVOUR_DISFAVOR,
    TR_EDITOR_FAVOUR_IGNORED,
    TR_EDITOR_FAVOUR_EXTENSION_MONTHS,
    TR_EDITOR_SCENARIO_EVENTS_TITLE,
    TR_EDITOR_SCENARIO_EVENTS_IMPORT,
    TR_EDITOR_SCENARIO_EVENTS_IMPORT_FULL,
    TR_EDITOR_SCENARIO_EVENTS_EXPORT,
    TR_EDITOR_SCENARIO_EVENTS_EXPORT_FULL,
    TR_EDITOR_SCENARIO_EVENTS_CLEAR,
    TR_EDITOR_SCENARIO_EVENTS_COUNT,
    TR_EDITOR_SCENARIO_EVENTS_CONDITIONS,
    TR_EDITOR_SCENARIO_EVENTS_ACTIONS,
    TR_EDITOR_UNABLE_TO_LOAD_EVENTS_TITLE,
    TR_EDITOR_CHECK_LOG_MESSAGE,
    TR_EDITOR_UNABLE_TO_SAVE_EVENTS_TITLE,
    TR_EDITOR_IMPORT_LINE,
    TR_EDITOR_SCENARIO_EVENT_ID,
    TR_EDITOR_SCENARIO_EVENT_REPEAT_MIN_MONTHS,
    TR_EDITOR_SCENARIO_EVENT_REPEAT_MAX_MONTHS,
    TR_EDITOR_SCENARIO_EVENT_MAX_NUM_REPEATS,
    TR_EDITOR_SCENARIO_EVENT_REPEATS_FOREVER,
    TR_EDITOR_SCENARIO_EVENT_DOES_NOT_REPEAT,
    TR_EDITOR_SCENARIO_EVENT_STATE_UNDEFINED,
    TR_EDITOR_SCENARIO_EVENT_STATE_DISABLED,
    TR_EDITOR_SCENARIO_EVENT_STATE_ACTIVE,
    TR_EDITOR_SCENARIO_EVENT_STATE_PAUSED,
    TR_EDITOR_SCENARIO_EVENT_EXECUTION_COUNT,
    TR_EDITOR_SCENARIO_EVENT_MONTHS_UNTIL_ACTIVE,
    TR_EDITOR_SCENARIO_CONDITION,
    TR_EDITOR_SCENARIO_ACTION,
    TR_EDITOR_SCENARIO_EVENTS_ADD,
    TR_EDITOR_SCENARIO_CONDITION_ADD,
    TR_EDITOR_SCENARIO_ACTION_ADD,
    TR_EDITOR_DELETE,
    TR_EDITOR_DELETED,
    TR_EDITOR_SCENARIO_EVENT_DELETED,
    TR_EDITOR_CUSTOM_MESSAGES_TITLE,
    TR_EDITOR_CUSTOM_MESSAGES_COUNT,
    TR_EDITOR_CUSTOM_MESSAGES_CLEAR,
    TR_EDITOR_CUSTOM_MESSAGES_IMPORT_FULL,
    TR_EDITOR_CUSTOM_MESSAGES_EXPORT_FULL,
    TR_EDITOR_CUSTOM_VARIABLES_TITLE,
    TR_EDITOR_CUSTOM_VARIABLES_COUNT,
    TR_EDITOR_UNABLE_TO_LOAD_CUSTOM_MESSAGES_TITLE,
    TR_EDITOR_SCENARIO_SELECT_INTRO,
    TR_EDITOR_SCENARIO_DESELECT_INTRO,
    TR_EDITOR_GRID_OFFSET,
    TR_PARAMETER_TYPE_CHECK,
    TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MIN,
    TR_PARAMETER_TYPE_MIN_MAX_NUMBER_MAX,
    TR_PARAMETER_TYPE_DIFFICULTY,
    TR_PARAMETER_TYPE_BOOLEAN,
    TR_PARAMETER_TYPE_NUMBER,
    TR_PARAMETER_TYPE_RESOURCE,
    TR_PARAMETER_TYPE_POP_CLASS,
    TR_PARAMETER_TYPE_BUILDING_COUNTING,
    TR_PARAMETER_TYPE_ALLOWED_BUILDING,
    TR_PARAMETER_TYPE_ROUTE,
    TR_PARAMETER_TYPE_STANDARD_MESSAGE,
    TR_PARAMETER_TYPE_FUTURE_CITY,
    TR_PARAMETER_TYPE_STORAGE_TYPE,
    TR_PARAMETER_USE_PERCENTAGE,
    TR_PARAMETER_IN_CITY_ONLY,
    TR_PARAMETER_CHECK_FOR_ONGOING,
    TR_PARAMETER_SHOW_MESSAGE,
    TR_PARAMETER_SET_TO_VALUE,
    TR_PARAMETER_ADD_AS_BUYING,
    TR_PARAMETER_PRODUCED,
    TR_PARAMETER_ALLOWED,
    TR_PARAMETER_SET_BUY_PRICE,
    TR_PARAMETER_CHECK_FOR_OPEN,
    TR_PARAMETER_RESPECT_SETTINGS,
    TR_PARAMETER_TYPE_CUSTOM_MESSAGE,
    TR_PARAMETER_TYPE_CUSTOM_VARIABLE,
    TR_PARAMETER_TYPE_RATING_TYPE,
    TR_PARAMETER_APPLY_COST,
    TR_PARAMETER_DESTROY_ALL,
    TR_PARAMETER_GRID_OFFSET,
    TR_PARAMETER_RADIUS,
    TR_PARAMETER_TYPE_INVASION_SIZE,
    TR_PARAMETER_TYPE_INVASION_TYPE,
    TR_PARAMETER_TYPE_INVASION_POINT,
    TR_PARAMETER_TYPE_TARGET_TYPE,
    TR_PARAMETER_TYPE_ENEMY_TYPE,
    TR_CONDITION_TYPE_TIME_PASSED,
    TR_CONDITION_TYPE_DIFFICULTY,
    TR_CONDITION_TYPE_MONEY,
    TR_CONDITION_TYPE_SAVINGS,
    TR_CONDITION_TYPE_STATS_FAVOR,
    TR_CONDITION_TYPE_STATS_PROSPERITY,
    TR_CONDITION_TYPE_STATS_CULTURE,
    TR_CONDITION_TYPE_STATS_PEACE,
    TR_CONDITION_TYPE_TRADE_SELL_PRICE,
    TR_CONDITION_TYPE_POPS_UNEMPLOYMENT,
    TR_CONDITION_TYPE_ROME_WAGES,
    TR_CONDITION_TYPE_CITY_POPULATION,
    TR_CONDITION_TYPE_BUILDING_COUNT_ACTIVE,
    TR_CONDITION_TYPE_STATS_CITY_HEALTH,
    TR_CONDITION_TYPE_COUNT_OWN_TROOPS,
    TR_CONDITION_TYPE_REQUEST_IS_ONGOING,
    TR_CONDITION_TYPE_TAX_RATE,
    TR_CONDITION_TYPE_BUILDING_COUNT_ANY,
    TR_CONDITION_TYPE_CUSTOM_VARIABLE_CHECK,
    TR_CONDITION_TYPE_TRADE_ROUTE_OPEN,
    TR_CONDITION_TYPE_TRADE_ROUTE_PRICE,
    TR_CONDITION_TYPE_RESOURCE_STORED_COUNT,
    TR_CONDITION_TYPE_RESOURCE_STORAGE_AVAILABLE,
    TR_CONDITION_TYPE_BUILDING_COUNT_AREA,
    TR_ACTION_TYPE_ADJUST_FAVOR,
    TR_ACTION_TYPE_ADJUST_MONEY,
    TR_ACTION_TYPE_ADJUST_SAVINGS,
    TR_ACTION_TYPE_TRADE_ADJUST_PRICE,
    TR_ACTION_TYPE_TRADE_PROBLEM_LAND,
    TR_ACTION_TYPE_TRADE_PROBLEM_SEA,
    TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_AMOUNT,
    TR_ACTION_TYPE_ADJUST_ROME_WAGES,
    TR_ACTION_TYPE_GLADIATOR_REVOLT,
    TR_ACTION_TYPE_CHANGE_RESOURCE_PRODUCED,
    TR_ACTION_TYPE_CHANGE_ALLOWED_BUILDINGS,
    TR_ACTION_TYPE_SEND_STANDARD_MESSAGE,
    TR_ACTION_TYPE_ADJUST_CITY_HEALTH,
    TR_ACTION_TYPE_TRADE_SET_PRICE,
    TR_ACTION_TYPE_EMPIRE_MAP_CONVERT_FUTURE_TRADE_CITY,
    TR_ACTION_TYPE_REQUEST_IMMEDIATELY_START,
    TR_ACTION_TYPE_SHOW_CUSTOM_MESSAGE,
    TR_ACTION_TYPE_A_MESSAGE,
    TR_ACTION_TYPE_TAX_RATE_SET,
    TR_ACTION_TYPE_CHANGE_CUSTOM_VARIABLE,
    TR_ACTION_TYPE_TRADE_ADJUST_ROUTE_OPEN_PRICE,
    TR_ACTION_TYPE_CHANGE_CITY_RATING,
    TR_ACTION_TYPE_CHANGE_RESOURCE_STOCKPILES,
    TR_ACTION_TYPE_TRADE_ROUTE_SET_OPEN,
    TR_ACTION_TYPE_TRADE_ROUTE_ADD_NEW_RESOURCE,
    TR_ACTION_TYPE_TRADE_SET_BUY_PRICE_ONLY,
    TR_ACTION_TYPE_TRADE_SET_SELL_PRICE_ONLY,
    TR_ACTION_TYPE_BUILDING_FORCE_COLLAPSE,
    TR_ACTION_TYPE_INVASION_IMMEDIATE,
    TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL,
    TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_LESS,
    TR_PARAMETER_VALUE_COMPARISON_TYPE_EQUAL_OR_MORE,
    TR_PARAMETER_VALUE_COMPARISON_TYPE_NOT_EQUAL,
    TR_PARAMETER_VALUE_COMPARISON_TYPE_LESS_THAN,
    TR_PARAMETER_VALUE_COMPARISON_TYPE_GREATER_THAN,
    TR_PARAMETER_VALUE_DIFFICULTY_VERY_EASY,
    TR_PARAMETER_VALUE_DIFFICULTY_EASY,
    TR_PARAMETER_VALUE_DIFFICULTY_NORMAL,
    TR_PARAMETER_VALUE_DIFFICULTY_HARD,
    TR_PARAMETER_VALUE_DIFFICULTY_VERY_HARD,
    TR_PARAMETER_VALUE_BOOLEAN_FALSE,
    TR_PARAMETER_VALUE_BOOLEAN_TRUE,
    TR_PARAMETER_VALUE_POP_CLASS_ALL,
    TR_PARAMETER_VALUE_POP_CLASS_PATRICIAN,
    TR_PARAMETER_VALUE_POP_CLASS_PLEBEIAN,
    TR_PARAMETER_VALUE_POP_CLASS_SLUMS,
    TR_PARAMETER_VALUE_BUILDING_NONE,
    TR_PARAMETER_VALUE_BUILDING_ANY,
    TR_PARAMETER_VALUE_BUILDING_MENU_FARMS,
    TR_PARAMETER_VALUE_BUILDING_MENU_RAW_MATERIALS,
    TR_PARAMETER_VALUE_BUILDING_MENU_WORKSHOPS,
    TR_PARAMETER_VALUE_BUILDING_MENU_STATUES,
    TR_PARAMETER_VALUE_BUILDING_MENU_GOV_RES,
    TR_PARAMETER_VALUE_BUILDING_MENU_GRAND_TEMPLES,
    TR_PARAMETER_VALUE_BUILDING_MENU_TREES,
    TR_PARAMETER_VALUE_BUILDING_MENU_PATHS,
    TR_PARAMETER_VALUE_BUILDING_MENU_PARKS,
    TR_PARAMETER_VALUE_BUILDING_MENU_SMALL_TEMPLES,
    TR_PARAMETER_VALUE_BUILDING_MENU_LARGE_TEMPLES,
    TR_PARAMETER_VALUE_BUILDING_NATIVE_CROPS,
    TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_CERES,
    TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_NEPTUNE,
    TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MERCURY,
    TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_MARS,
    TR_PARAMETER_VALUE_BUILDING_SMALL_TEMPLE_VENUS,
    TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_CERES,
    TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_NEPTUNE,
    TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MERCURY, 
    TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_MARS,
    TR_PARAMETER_VALUE_BUILDING_LARGE_TEMPLE_VENUS,
    TR_PARAMETER_VALUE_DYNAMIC_RESOLVE,
    TR_PARAMETER_VALUE_NONE,
    TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT,
    TR_PARAMETER_VALUE_MESSAGE_CITY_IN_DEBT_AGAIN,
    TR_PARAMETER_VALUE_MESSAGE_CITY_STILL_IN_DEBT,
    TR_PARAMETER_VALUE_MESSAGE_CAESAR_WRATH,
    TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_CONTINUE,
    TR_PARAMETER_VALUE_MESSAGE_CAESAR_ARMY_RETREAT,
    TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE,
    TR_PARAMETER_VALUE_MESSAGE_ENEMIES_CLOSING,
    TR_PARAMETER_VALUE_MESSAGE_ENEMIES_AT_THE_DOOR,
    TR_PARAMETER_VALUE_MESSAGE_SMALL_FESTIVAL,
    TR_PARAMETER_VALUE_MESSAGE_LARGE_FESTIVAL,
    TR_PARAMETER_VALUE_MESSAGE_GRAND_FESTIVAL,
    TR_PARAMETER_VALUE_MESSAGE_GODS_UNHAPPY,
    TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT,
    TR_PARAMETER_VALUE_MESSAGE_GLADIATOR_REVOLT_FINISHED,
    TR_PARAMETER_VALUE_MESSAGE_EMPEROR_CHANGE,
    TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_SANDSTORMS,
    TR_PARAMETER_VALUE_MESSAGE_LAND_TRADE_DISRUPTED_LANDSLIDES,
    TR_PARAMETER_VALUE_MESSAGE_SEA_TRADE_DISRUPTED,
    TR_PARAMETER_VALUE_MESSAGE_ROME_RAISES_WAGES,
    TR_PARAMETER_VALUE_MESSAGE_ROME_LOWERS_WAGES,
    TR_PARAMETER_VALUE_MESSAGE_CONTAMINATED_WATER,
    TR_PARAMETER_VALUE_MESSAGE_EMPIRE_HAS_EXPANDED,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_CERES,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE_NO_SEA_TRADE,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MERCURY,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_MILITARY,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_VENUS,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_NEPTUNE,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS,
    TR_PARAMETER_VALUE_MESSAGE_CERES_IS_UPSET,
    TR_PARAMETER_VALUE_MESSAGE_NEPTUNE_IS_UPSET,
    TR_PARAMETER_VALUE_MESSAGE_MERCURY_IS_UPSET,
    TR_PARAMETER_VALUE_MESSAGE_MARS_IS_UPSET,
    TR_PARAMETER_VALUE_MESSAGE_VENUS_IS_UPSET,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_CERES,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MARS,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_MERCURY_ALTERNATE,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_NEPTUNE_ALTERNATE,
    TR_PARAMETER_VALUE_MESSAGE_BLESSING_FROM_VENUS_ALTERNATE,
    TR_PARAMETER_VALUE_MESSAGE_WRATH_OF_MARS_NO_NATIVES,
    TR_PARAMETER_VALUE_MESSAGE_GODS_WRATHFUL,
    TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_NO_TROOPS,
    TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_LATE,
    TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_LOST_TOO_WEAK,
    TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_WON,
    TR_PARAMETER_VALUE_MESSAGE_DISTANT_BATTLE_CITY_RETAKEN,
    TR_PARAMETER_VALUE_MESSAGE_HEALTH_ILLNESS,
    TR_PARAMETER_VALUE_MESSAGE_HEALTH_DISEASE,
    TR_PARAMETER_VALUE_MESSAGE_HEALTH_PESTILENCE,
    TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_1,
    TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_2,
    TR_PARAMETER_VALUE_MESSAGE_CAESAR_RESPECT_3,
    TR_PARAMETER_VALUE_MESSAGE_EMIGRATION,
    TR_PARAMETER_VALUE_MESSAGE_FIRED,
    TR_PARAMETER_VALUE_MESSAGE_SOLDIERS_STARVING,
    TR_PARAMETER_VALUE_MESSAGE_CAESAR_ANGER,
    TR_PARAMETER_VALUE_MESSAGE_ENEMIES_LEAVING,
    TR_PARAMETER_VALUE_MEDIA_TYPE_SOUND,
    TR_PARAMETER_VALUE_MEDIA_TYPE_VIDEO,
    TR_PARAMETER_VALUE_RATING_TYPE_PEACE,
    TR_PARAMETER_VALUE_RATING_TYPE_PROSPERITY,
    TR_PARAMETER_VALUE_STORAGE_TYPE_ALL,
    TR_PARAMETER_VALUE_STORAGE_TYPE_GRANARIES,
    TR_PARAMETER_VALUE_STORAGE_TYPE_WAREHOUSES,
    TR_PARAMETER_VALUE_INVASION_TYPE_ENEMY_ARMY,
    TR_PARAMETER_VALUE_INVASION_TYPE_CAESAR,
    TR_PARAMETER_VALUE_INVASION_TYPE_NATIVES,
    TR_PARAMETER_VALUE_INVASION_TYPE_MARS_NATIVES,
    TR_PARAMETER_VALUE_FORMATION_ATTACK_FOOD_CHAIN,
    TR_PARAMETER_VALUE_FORMATION_ATTACK_GOLD_STORES,
    TR_PARAMETER_VALUE_FORMATION_ATTACK_BEST_BUILDINGS,
    TR_PARAMETER_VALUE_FORMATION_ATTACK_TROOPS,
    TR_PARAMETER_VALUE_FORMATION_ATTACK_RANDOM,
    TR_PARAMETER_VALUE_ENEMY_UNDEFINED,
    TR_PARAMETER_VALUE_ENEMY_0_BARBARIAN,
    TR_PARAMETER_VALUE_ENEMY_1_NUMIDIAN,
    TR_PARAMETER_VALUE_ENEMY_2_GAUL,
    TR_PARAMETER_VALUE_ENEMY_3_CELT,
    TR_PARAMETER_VALUE_ENEMY_4_GOTH,
    TR_PARAMETER_VALUE_ENEMY_5_PERGAMUM,
    TR_PARAMETER_VALUE_ENEMY_6_SELEUCID,
    TR_PARAMETER_VALUE_ENEMY_7_ETRUSCAN,
    TR_PARAMETER_VALUE_ENEMY_8_GREEK,
    TR_PARAMETER_VALUE_ENEMY_9_EGYPTIAN,
    TR_PARAMETER_VALUE_ENEMY_10_CARTHAGINIAN,
    TR_PARAMETER_VALUE_ENEMY_11_CAESAR,
    TR_PARAMETER_DISPLAY_SET_TO,
    TR_PARAMETER_DISPLAY_ADD_TO,
    TR_PARAMETER_DISPLAY_BETWEEN,
    TR_PARAMETER_DISPLAY_IN_CITY,
    TR_PARAMETER_DISPLAY_ANYWHERE,
    TR_PARAMETER_DISPLAY_PERCENTAGE,
    TR_PARAMETER_DISPLAY_FLAT_NUMBER,
    TR_PARAMETER_DISPLAY_ONGOING,
    TR_PARAMETER_DISPLAY_NOT_ONGOING,
    TR_PARAMETER_DISPLAY_ROUTE_OPEN,
    TR_PARAMETER_DISPLAY_ROUTE_CLOSED,
    TR_PARAMETER_DISPLAY_ALLOWED,
    TR_PARAMETER_DISPLAY_DISALLOWED,
    TR_PARAMETER_DISPLAY_SHOW_MESSAGE,
    TR_PARAMETER_DISPLAY_DO_NOT_SHOW_MESSAGE,
    TR_PARAMETER_DISPLAY_BUY_PRICE,
    TR_PARAMETER_DISPLAY_SELL_PRICE,
    TR_PARAMETER_DISPLAY_MONTHS,
    TR_PARAMETER_DISPLAY_DAYS,
    TR_PARAMETER_DISPLAY_RESPECT_SETTINGS,
    TR_PARAMETER_DISPLAY_IGNORE_SETTINGS,
    TR_PARAMETER_DISPLAY_APPLY_COST,
    TR_PARAMETER_DISPLAY_NO_COST,
    TR_PARAMETER_DISPLAY_ADD_AS_BUYING,
    TR_PARAMETER_DISPLAY_ADD_AS_SELLING,
    TR_PARAMETER_DISPLAY_DESTROY_ALL_TYPES,
    TR_ORDER_CONDITION_NEVER,
    TR_ORDER_CONDITION_ALWAYS,
    TR_ORDER_CONDITION_SOURCE_HAS_MORE_THAN,
    TR_ORDER_CONDITION_DESTINATION_HAS_LESS_THAN,
    TR_BUILDING_INFO_DEPOT_SELECT_SOURCE,
    TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION,
    TR_BUILDING_INFO_DEPOT_ONE_BUILDING_FOR_RESOURCE,
    TR_BUILDING_INFO_DEPOT_NO_SOURCE_AVAILABLE,
    TR_BUILDING_INFO_DEPOT_NO_DESTINATION_AVAILABLE,
    TR_BUILDING_INFO_DEPOT_DELIVER,
    TR_BUILDING_INFO_DEPOT_CONDITION,
    TR_BUILDING_INFO_DEPOT_SOURCE,
    TR_BUILDING_INFO_DEPOT_DESTINATION,
    TR_BUILDING_INFO_DEPOT_SELECT_SOURCE_TITLE,
    TR_BUILDING_INFO_DEPOT_SELECT_DESTINATION_TITLE,
    TR_BUILDING_INFO_DEPOT_SELECT_RESOURCE_TITLE,
    TR_TOOLTIP_BUTTON_CENTER_CAMERA,
    TR_FIGURE_INFO_DEPOT_DELIVER,
    TR_FIGURE_INFO_DEPOT_RECALL,
    TR_FIGURE_INFO_DEPOT_RETURNING,
    TR_FIGURE_INFO_DEPOT_FROM,
    TR_FIGURE_INFO_DEPOT_TO,
    TR_BUILDING_DEPOT_NO_EMPLOYEES,
    TR_BUILDING_DEPOT_FEW_EMPLOYEES,
    TR_BUILDING_DEPOT_SOME_EMPLOYEES,
    TR_BUILDING_DEPOT_HALF_EMPLOYEES,
    TR_BUILDING_DEPOT_MANY_EMPLOYEES,
    TR_BUILDING_INFO_MOTHBALL_WARNING,
    TR_BUILDING_INFO_CARTLOAD,
    TR_BUILDING_INFO_CARTLOADS,
    TR_HOTKEY_SHOW_OVERLAY_RISKS_NATIVE,
    TR_BUILDING_PANELLED_GARDEN_WALL,
    TR_BUILDING_LOOPED_GARDEN_WALL_GATE,
    TR_BUILDING_LOOPED_GARDEN_WALL_GATE_DESC,
    TR_BUILDING_PANELLED_GARDEN_WALL_GATE,
    TR_BUILDING_PANELLED_GARDEN_WALL_GATE_DESC,
    TR_HOTKEY_BUILD_HIGHWAY,
    TR_BUILDING_SHRINE_DESC,
    TR_BUILDING_SHRINE_CERES,
    TR_BUILDING_SHRINE_MARS,
    TR_BUILDING_SHRINE_MERCURY,
    TR_BUILDING_SHRINE_NEPTUNE,
    TR_BUILDING_SHRINE_VENUS,
    TR_BUILDING_MENU_SHRINES,
    TR_BUILDING_INFO_TOTAL_FOOD,
    TR_BUILDING_FORMAL_GARDENS,
    TR_BUILDING_OVERGROWN_GARDENS,
    TR_WINDOW_ADVISOR_RELIGION_ALTARS_HEADER,
    TRANSLATION_MAX_KEY
} translation_key;

typedef struct {
    translation_key key;
    const char *string;
} translation_string;

void translation_load(language_type language);

uint8_t *translation_for(translation_key key);

void translation_czech(const translation_string **strings, int *num_strings);
void translation_english(const translation_string **strings, int *num_strings);
void translation_french(const translation_string **strings, int *num_strings);
void translation_german(const translation_string **strings, int *num_strings);
void translation_greek(const translation_string **strings, int *num_strings);
void translation_italian(const translation_string **strings, int *num_strings);
void translation_japanese(const translation_string **strings, int *num_strings);
void translation_korean(const translation_string **strings, int *num_strings);
void translation_polish(const translation_string **strings, int *num_strings);
void translation_portuguese(const translation_string **strings, int *num_strings);
void translation_russian(const translation_string **strings, int *num_strings);
void translation_spanish(const translation_string **strings, int *num_strings);
void translation_simplified_chinese(const translation_string **strings, int *num_strings);
void translation_swedish(const translation_string **strings, int *num_strings);
void translation_traditional_chinese(const translation_string **strings, int *num_strings);

#endif // TRANSLATION_TRANSLATION_H
