
# ![OJ Logo][logo] OpenJazz

## About

*OpenJazz* is a free, open-source version of the classic Jazz Jackrabbit™ games.

OpenJazz can be compiled on a wide range of operating systems, including
Windows, macOS, GNU/Linux and BSD flavors. Also ports are available for some
homebrew platforms, consoles and handhelds. See [Platforms](PLATFORMS.md) for
details. You can even play it [inside your web browser][web port].

To play, you will need the files from one of the original games.

With the demise of DOS-based operating systems, it has become necessary to use
emulators to play old DOS games. Jazz Jackrabbit™ deserves more - and would
benefit greatly from new features.

*Jazz Jackrabbit™* is a PC platform game. Produced by Epic Games (then Epic
MegaGames), it was first released in 1994. The fast-paced, colourful gameplay
proved popular, and the game won PC Format's Arcade Game of the Year award.
Many people still fondly recall the shareware versions.

## History

OpenJazz was started on the 23rd of August, 2005, by Alister Thomson.
Academic pressures put the project on hold until late December 2005.
The source code was released on the 25th, and the first version with a degree
of playability was released on the 15th of January, 2006.
Since then, a variety of ports have been released by other people. A lot of
them have since been merged back into the main code base.
More academic pressures meant there were few updates over the following few
years, but in 2009 a multiplayer version was released.
After that, more eye candy features have made it into the engine. These are 
features not directly involving the levels. However, without bonus levels, movie
playback and the menu plasma effect, OpenJazz would be incomplete.
In 2014, the project has been moved to GitHub to allow others to easily propose
changes, report bugs and also fix them. This also lead to more ports being made. 
Nowadays, development has slowed down. The original author is involved with
other projects and there is no clear roadmap for new features, besides striving
for a "true" and faithful Jazz Jackrabbit™ adaption on all possible platforms.
GitHub user [carstene1ns](https://github.com/carstene1ns) has cleaned and
restructured parts of the code base, integrated some ports and tries to resolve
bug reports.

## License

OpenJazz is available under the GNU General Public License version 2 or later,
see [licenses.txt](licenses.txt) for additional information and other included
software.

## [Controls](res/unix/OpenJazz.6.adoc#ingame-controls) (See manual)

## [Building](BUILDING.md)

## Running [![Play in Browser][web badge]][web port]

Execute `OpenJazz`. Depending on the platform and compile time options, the
data files are expected to be under different paths (alongside the executable
works always as a general fallback). You can also specifiy a game folder as
command line argument.

## Authors

Original author: Alister Thomson (alister_j_t at yahoo dot com)

[Additional Authors](res/unix/OpenJazz.6.adoc#authors) (See manual)

## Homepage

http://alister.eu/jazz/oj/

[logo]: res/unix/OpenJazz.png
[web badge]: https://img.shields.io/badge/Play_in-Browser-blue?style=plastic
[web port]: https://openjazz.github.io
