#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Yoku's Island Express
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220402.3

# Set game-specific variables

GAME_ID='yokus-island-express'
GAME_NAME='Yokuʼs Island Express'

ARCHIVE_BASE_1='setup_gog_yoku_latest_drm_free_210927_(50319).exe'
ARCHIVE_BASE_1_MD5='5a1241ffdda722df9c7c4c8fc1b661fe'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1300000'
ARCHIVE_BASE_1_VERSION='2021.09.27-gog50319'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/yokus_island_express'

ARCHIVE_BASE_0='setup_yokus_island_express_aug_24_2018_205911_(24871).exe'
ARCHIVE_BASE_0_MD5='49d3a80f0a039e7b7a4d5fcd4860e445'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1300000'
ARCHIVE_BASE_0_VERSION='2018.08.24-gog24871'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_DOC_DATA_FILES='
licenses'
ARCHIVE_GAME_BIN_FILES='
yoku.exe
bssndrpt64.exe
bugsplat64.dll
bugsplatrc64.dll
d3dcompiler_47.dll'
ARCHIVE_GAME_DATA_FILES='
data
processed'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='yoku.exe'
APP_MAIN_ICON='yoku.exe'

PACKAGES_LIST='PKG_DATA PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Set up a WINE virtual desktop on first launch, using the current desktop resolution

sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='${sed_expression}'"
APP_WINETRICKS="$APP_WINETRICKS vd=\$(LANG=C xrandr | sed ${sed_options})"
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks xrandr sed"

# Use persistent storage for user data

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/${USER}/Application Data/Villa Gorilla/Yoku'\''s Island Express'
DATA_DIRS="$DATA_DIRS ./userdata"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
