#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2021 Mopi
set -o errexit

###
# Hidden Through Time expansions:
# - Viking Tales
# - Legends of Japan
# - Road to Rome
# - Pirate Treasures
# - Aztec Rituals
# send your bug reports to contact@dotslashplay.it
###

script_version=20240301.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='hidden-through-time-1'
GAME_NAME='Hidden Through Time'

EXPANSION_ID_VIKING='viking-tales'
EXPANSION_NAME_VIKING='Viking Tales'

EXPANSION_ID_JAPAN='legends-of-japan'
EXPANSION_NAME_JAPAN='Legends of Japan'

EXPANSION_ID_ROME='road-to-rome'
EXPANSION_NAME_ROME='Road to Rome'

EXPANSION_ID_PIRATES='pirate-treasures'
EXPANSION_NAME_PIRATES='Pirate Treasures'

EXPANSION_ID_AZTEC='aztec-rituals'
EXPANSION_NAME_AZTEC='Aztec Rituals'

# Archives

## Viking Tales

ARCHIVE_BASE_VIKING_1_NAME='setup_hidden_through_time_-_viking_tales_1.0.9b_(56935).exe'
ARCHIVE_BASE_VIKING_1_MD5='ab9b8a7349085128affe778fcc0f84e9'
ARCHIVE_BASE_VIKING_1_TYPE='innosetup'
ARCHIVE_BASE_VIKING_1_SIZE='10457'
ARCHIVE_BASE_VIKING_1_VERSION='1.0.9b-gog56935'
ARCHIVE_BASE_VIKING_1_URL='https://www.gog.com/game/hidden_through_time_viking_tales'

ARCHIVE_BASE_VIKING_0_NAME='setup_hidden_through_time_-_viking_tales_1.0.7_(46929).exe'
ARCHIVE_BASE_VIKING_0_MD5='0367e7a34d784d6aca0f54e56bd0d47e'
ARCHIVE_BASE_VIKING_0_TYPE='innosetup'
ARCHIVE_BASE_VIKING_0_SIZE='7200'
ARCHIVE_BASE_VIKING_0_VERSION='1.0.7-gog46929'

## Legends of Japan

ARCHIVE_BASE_JAPAN_1_NAME='setup_hidden_through_time_-_legends_of_japan_1.0.9b_(56935).exe'
ARCHIVE_BASE_JAPAN_1_MD5='f5c129fcb7f481badd11465d726b018a'
ARCHIVE_BASE_JAPAN_1_TYPE='innosetup'
ARCHIVE_BASE_JAPAN_1_SIZE='10413'
ARCHIVE_BASE_JAPAN_1_VERSION='1.0.9b-gog56935'
ARCHIVE_BASE_JAPAN_1_URL='https://www.gog.com/game/hidden_through_time_legends_of_japan'

ARCHIVE_BASE_JAPAN_0_NAME='setup_hidden_through_time_-_legends_of_japan_1.0.7_(46929).exe'
ARCHIVE_BASE_JAPAN_0_MD5='d05628b0410b21559e8aebc99e1543c6'
ARCHIVE_BASE_JAPAN_0_TYPE='innosetup'
ARCHIVE_BASE_JAPAN_0_SIZE='7400'
ARCHIVE_BASE_JAPAN_0_VERSION='1.0.7-gog46929'

## Road to Rome

ARCHIVE_BASE_ROME_1_NAME='setup_hidden_through_time_road_to_rome_1.0.9b_(56935).exe'
ARCHIVE_BASE_ROME_1_MD5='6a0f909d0759c4f899cefcd0bac0ebe9'
ARCHIVE_BASE_ROME_1_TYPE='innosetup'
ARCHIVE_BASE_ROME_1_SIZE='10594'
ARCHIVE_BASE_ROME_1_VERSION='1.0.9b-gog56935'
ARCHIVE_BASE_ROME_1_URL='https://www.gog.com/game/hidden_through_time_road_to_rome'

ARCHIVE_BASE_ROME_0_NAME='setup_hidden_through_time_road_to_rome_1.0.7_(46929).exe'
ARCHIVE_BASE_ROME_0_MD5='2e08360a0232df11d7016fe0ef2b5629'
ARCHIVE_BASE_ROME_0_TYPE='innosetup'
ARCHIVE_BASE_ROME_0_SIZE='8200'
ARCHIVE_BASE_ROME_0_VERSION='1.0.7-gog46929'

## Pirate Treasures

ARCHIVE_BASE_PIRATES_1_NAME='setup_hidden_through_time_-_pirate_treasures_1.0.9b_(56935).exe'
ARCHIVE_BASE_PIRATES_1_MD5='d9f92a4d9673a1a5236d242ea0240a6d'
ARCHIVE_BASE_PIRATES_1_TYPE='innosetup'
ARCHIVE_BASE_PIRATES_1_SIZE='6620'
ARCHIVE_BASE_PIRATES_1_VERSION='1.0.9b-gog56935'
ARCHIVE_BASE_PIRATES_1_URL='https://www.gog.com/game/hidden_through_time_pirate_treasures'

## Aztec Rituals

ARCHIVE_BASE_AZTEC_1_NAME='setup_hidden_through_time_-_aztec_rituals_1.0.9b_(56935).exe'
ARCHIVE_BASE_AZTEC_1_MD5='378bd5618bbbe3f3d2746593cd988c52'
ARCHIVE_BASE_AZTEC_1_TYPE='innosetup'
ARCHIVE_BASE_AZTEC_1_SIZE='7043'
ARCHIVE_BASE_AZTEC_1_VERSION='1.0.9b-gog56935'
ARCHIVE_BASE_AZTEC_1_URL='https://www.gog.com/game/hidden_through_time_aztec_rituals'


CONTENT_GAME_MAIN_PATH='.'
CONTENT_GAME_MAIN_FILES='
goggame-*.info'

PKG_MAIN_DEPS="$GAME_ID"
## Ensure smooth upgrades from packages generated with pre-20240220.4 game scripts.
PKG_MAIN_PROVIDES_VIKING="${PKG_MAIN_PROVIDES_VIKING:-}
hidden-through-time-viking-tales"
PKG_MAIN_PROVIDES_JAPAN="${PKG_MAIN_PROVIDES_JAPAN:-}
hidden-through-time-legends-of-japan"
PKG_MAIN_PROVIDES_ROME="${PKG_MAIN_PROVIDES_ROME:-}
hidden-through-time-road-to-rome"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
