#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Nine Noir Lives
# send your bug reports to contact@dotslashplay.it
###

script_version=20231126.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='nine-noir-lives'
GAME_NAME='Nine Noir Lives'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_0_NAME='nine_noir_lives_1_0_12_59002.sh'
ARCHIVE_BASE_0_MD5='e93b7279c787fbbc508f91e762e46d6e'
ARCHIVE_BASE_0_SIZE='4837192'
ARCHIVE_BASE_0_VERSION='1.0.12-gog59002'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/nine_noir_lives'

ARCHIVE_BASE_DEMO_0_NAME='setup_nine_noir_lives_demo_1.02_(46357).exe'
ARCHIVE_BASE_DEMO_0_MD5='f22c232ad0d7c1512b0aa90611f67340'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_SIZE='550000'
ARCHIVE_BASE_DEMO_0_VERSION='1.02-gog46357'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/nine_noir_lives_demo'

VISIONAIRE_NAME='visplayer'
VISIONAIRE_NAME_DEMO='nnl'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_PATH_DEFAULT_DEMO='.'
## The shipped build of OpenAL must be used, to avoid a missing symbol error:
## symbol lookup error: ./visplayer: undefined symbol: SelectResampler
CONTENT_LIBS0_BIN_PATH="${CONTENT_PATH_DEFAULT}/libs64"
CONTENT_LIBS0_BIN_FILES='
libopenal.so'
CONTENT_GAME0_DATA_FILES='
*.vc
*.vi
*.vis
*.vs
*.vt
*.vv'
CONTENT_DOC0_DATA_FILES='
BSD_3_Clause.txt
LGPL2_1.txt
libpng-LICENSE.txt
MIT.txt
symbols.txt
webm.txt
ZLIB.txt'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/Silvernode Studios/NNL Demo'

## TODO: An icons pack should be provided for the full game.

PKG_BIN_ARCH='64'
PKG_BIN_ARCH_DEMO='32'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
## Demo - Delete the broken 256×256 icon.
case "$(current_archive)" in
	('ARCHIVE_BASE_DEMO_'*)
		broken_icon="$(package_path 'PKG_DATA')$(path_icons)/256x256/apps/$(game_id).png"
		rm --force "$broken_icon"
		rmdir --ignore-fail-on-non-empty --parents "$(dirname "$broken_icon")"
	;;
esac
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
