#!/usr/bin/env python3
"""
Plots data stored in BornAgain's .int or .int.gz format.
Can handle both 1D and 2D arrays.
"""

import argparse, os, sys
import bornagain as ba
from bornagain import ba_plot as bp

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("-v",
                        "--verbose",
                        action="store_true",
                        help="print some output to the terminal")
    parser.add_argument("file",
                        type=str,
                        help="input data file (.int or .int.gz)")
    parser.add_argument("-l", "--min", type=float, help="upper plot limit")
    parser.add_argument("-u", "--max", type=float, help="lower plot limit")
    parser.add_argument(
        "-y",
        "--ylin",
        action="store_true",
        help="linear y scale",
    )
    args = parser.parse_args()

    data = ba.readData2D(args.file)

    bp.plot_datafield(data)
    bp.plt.show()
