// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Generic;

namespace NuGet.Packaging.Licenses
{

    // Auto-Generated by the GenerateLicenseList tool. DO NOT EDIT this manually. Use the update script at $repositoryRoot/scripts/utils/UpdateNuGetLicenseSPDXList.ps1
    public static class NuGetLicenseData
    {
        public static string LicenseListVersion { get; } = "5dbff5c";

        public static readonly IReadOnlyDictionary<string, LicenseData> LicenseList = new Dictionary<string, LicenseData>()
        {
            { "0BSD", new LicenseData(licenseID: "0BSD", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "3D-Slicer-1.0", new LicenseData(licenseID: "3D-Slicer-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AAL", new LicenseData(licenseID: "AAL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Abstyles", new LicenseData(licenseID: "Abstyles", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AdaCore-doc", new LicenseData(licenseID: "AdaCore-doc", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Adobe-2006", new LicenseData(licenseID: "Adobe-2006", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Adobe-Display-PostScript", new LicenseData(licenseID: "Adobe-Display-PostScript", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Adobe-Glyph", new LicenseData(licenseID: "Adobe-Glyph", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Adobe-Utopia", new LicenseData(licenseID: "Adobe-Utopia", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ADSL", new LicenseData(licenseID: "ADSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AFL-1.1", new LicenseData(licenseID: "AFL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-1.2", new LicenseData(licenseID: "AFL-1.2", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-2.0", new LicenseData(licenseID: "AFL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-2.1", new LicenseData(licenseID: "AFL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-3.0", new LicenseData(licenseID: "AFL-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Afmparse", new LicenseData(licenseID: "Afmparse", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AGPL-1.0", new LicenseData(licenseID: "AGPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "AGPL-1.0-only", new LicenseData(licenseID: "AGPL-1.0-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AGPL-1.0-or-later", new LicenseData(licenseID: "AGPL-1.0-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AGPL-3.0", new LicenseData(licenseID: "AGPL-3.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "AGPL-3.0-only", new LicenseData(licenseID: "AGPL-3.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AGPL-3.0-or-later", new LicenseData(licenseID: "AGPL-3.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Aladdin", new LicenseData(licenseID: "Aladdin", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AMD-newlib", new LicenseData(licenseID: "AMD-newlib", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AMDPLPA", new LicenseData(licenseID: "AMDPLPA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AML", new LicenseData(licenseID: "AML", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AML-glslang", new LicenseData(licenseID: "AML-glslang", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AMPAS", new LicenseData(licenseID: "AMPAS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ANTLR-PD", new LicenseData(licenseID: "ANTLR-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ANTLR-PD-fallback", new LicenseData(licenseID: "ANTLR-PD-fallback", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "any-OSI", new LicenseData(licenseID: "any-OSI", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "any-OSI-perl-modules", new LicenseData(licenseID: "any-OSI-perl-modules", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Apache-1.0", new LicenseData(licenseID: "Apache-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Apache-1.1", new LicenseData(licenseID: "Apache-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Apache-2.0", new LicenseData(licenseID: "Apache-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "APAFML", new LicenseData(licenseID: "APAFML", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APL-1.0", new LicenseData(licenseID: "APL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "App-s2p", new LicenseData(licenseID: "App-s2p", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-1.0", new LicenseData(licenseID: "APSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-1.1", new LicenseData(licenseID: "APSL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-1.2", new LicenseData(licenseID: "APSL-1.2", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-2.0", new LicenseData(licenseID: "APSL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Arphic-1999", new LicenseData(licenseID: "Arphic-1999", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Artistic-1.0", new LicenseData(licenseID: "Artistic-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Artistic-1.0-cl8", new LicenseData(licenseID: "Artistic-1.0-cl8", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Artistic-1.0-Perl", new LicenseData(licenseID: "Artistic-1.0-Perl", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Artistic-2.0", new LicenseData(licenseID: "Artistic-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Artistic-dist", new LicenseData(licenseID: "Artistic-dist", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Aspell-RU", new LicenseData(licenseID: "Aspell-RU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ASWF-Digital-Assets-1.0", new LicenseData(licenseID: "ASWF-Digital-Assets-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ASWF-Digital-Assets-1.1", new LicenseData(licenseID: "ASWF-Digital-Assets-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Baekmuk", new LicenseData(licenseID: "Baekmuk", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Bahyph", new LicenseData(licenseID: "Bahyph", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Barr", new LicenseData(licenseID: "Barr", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "bcrypt-Solar-Designer", new LicenseData(licenseID: "bcrypt-Solar-Designer", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Beerware", new LicenseData(licenseID: "Beerware", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Bitstream-Charter", new LicenseData(licenseID: "Bitstream-Charter", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Bitstream-Vera", new LicenseData(licenseID: "Bitstream-Vera", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BitTorrent-1.0", new LicenseData(licenseID: "BitTorrent-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BitTorrent-1.1", new LicenseData(licenseID: "BitTorrent-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "blessing", new LicenseData(licenseID: "blessing", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BlueOak-1.0.0", new LicenseData(licenseID: "BlueOak-1.0.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Boehm-GC", new LicenseData(licenseID: "Boehm-GC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Boehm-GC-without-fee", new LicenseData(licenseID: "Boehm-GC-without-fee", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Borceux", new LicenseData(licenseID: "Borceux", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Brian-Gladman-2-Clause", new LicenseData(licenseID: "Brian-Gladman-2-Clause", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Brian-Gladman-3-Clause", new LicenseData(licenseID: "Brian-Gladman-3-Clause", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-1-Clause", new LicenseData(licenseID: "BSD-1-Clause", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause", new LicenseData(licenseID: "BSD-2-Clause", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BSD-2-Clause-Darwin", new LicenseData(licenseID: "BSD-2-Clause-Darwin", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause-first-lines", new LicenseData(licenseID: "BSD-2-Clause-first-lines", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause-FreeBSD", new LicenseData(licenseID: "BSD-2-Clause-FreeBSD", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "BSD-2-Clause-NetBSD", new LicenseData(licenseID: "BSD-2-Clause-NetBSD", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "BSD-2-Clause-Patent", new LicenseData(licenseID: "BSD-2-Clause-Patent", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause-pkgconf-disclaimer", new LicenseData(licenseID: "BSD-2-Clause-pkgconf-disclaimer", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause-Views", new LicenseData(licenseID: "BSD-2-Clause-Views", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause", new LicenseData(licenseID: "BSD-3-Clause", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BSD-3-Clause-acpica", new LicenseData(licenseID: "BSD-3-Clause-acpica", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-Attribution", new LicenseData(licenseID: "BSD-3-Clause-Attribution", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-Clear", new LicenseData(licenseID: "BSD-3-Clause-Clear", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BSD-3-Clause-flex", new LicenseData(licenseID: "BSD-3-Clause-flex", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-HP", new LicenseData(licenseID: "BSD-3-Clause-HP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-LBNL", new LicenseData(licenseID: "BSD-3-Clause-LBNL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-Modification", new LicenseData(licenseID: "BSD-3-Clause-Modification", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-No-Military-License", new LicenseData(licenseID: "BSD-3-Clause-No-Military-License", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-No-Nuclear-License", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-License", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-No-Nuclear-License-2014", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-License-2014", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-No-Nuclear-Warranty", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-Warranty", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-Open-MPI", new LicenseData(licenseID: "BSD-3-Clause-Open-MPI", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-Sun", new LicenseData(licenseID: "BSD-3-Clause-Sun", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-4-Clause", new LicenseData(licenseID: "BSD-4-Clause", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BSD-4-Clause-Shortened", new LicenseData(licenseID: "BSD-4-Clause-Shortened", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-4-Clause-UC", new LicenseData(licenseID: "BSD-4-Clause-UC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-4.3RENO", new LicenseData(licenseID: "BSD-4.3RENO", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-4.3TAHOE", new LicenseData(licenseID: "BSD-4.3TAHOE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Advertising-Acknowledgement", new LicenseData(licenseID: "BSD-Advertising-Acknowledgement", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Attribution-HPND-disclaimer", new LicenseData(licenseID: "BSD-Attribution-HPND-disclaimer", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Inferno-Nettverk", new LicenseData(licenseID: "BSD-Inferno-Nettverk", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Protection", new LicenseData(licenseID: "BSD-Protection", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Source-beginning-file", new LicenseData(licenseID: "BSD-Source-beginning-file", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Source-Code", new LicenseData(licenseID: "BSD-Source-Code", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Systemics", new LicenseData(licenseID: "BSD-Systemics", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Systemics-W3Works", new LicenseData(licenseID: "BSD-Systemics-W3Works", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSL-1.0", new LicenseData(licenseID: "BSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BUSL-1.1", new LicenseData(licenseID: "BUSL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "bzip2-1.0.5", new LicenseData(licenseID: "bzip2-1.0.5", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "bzip2-1.0.6", new LicenseData(licenseID: "bzip2-1.0.6", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "C-UDA-1.0", new LicenseData(licenseID: "C-UDA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CAL-1.0", new LicenseData(licenseID: "CAL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CAL-1.0-Combined-Work-Exception", new LicenseData(licenseID: "CAL-1.0-Combined-Work-Exception", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Caldera", new LicenseData(licenseID: "Caldera", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Caldera-no-preamble", new LicenseData(licenseID: "Caldera-no-preamble", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Catharon", new LicenseData(licenseID: "Catharon", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CATOSL-1.1", new LicenseData(licenseID: "CATOSL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-1.0", new LicenseData(licenseID: "CC-BY-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-2.0", new LicenseData(licenseID: "CC-BY-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-2.5", new LicenseData(licenseID: "CC-BY-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-2.5-AU", new LicenseData(licenseID: "CC-BY-2.5-AU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0", new LicenseData(licenseID: "CC-BY-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0-AT", new LicenseData(licenseID: "CC-BY-3.0-AT", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0-AU", new LicenseData(licenseID: "CC-BY-3.0-AU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0-DE", new LicenseData(licenseID: "CC-BY-3.0-DE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0-IGO", new LicenseData(licenseID: "CC-BY-3.0-IGO", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0-NL", new LicenseData(licenseID: "CC-BY-3.0-NL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0-US", new LicenseData(licenseID: "CC-BY-3.0-US", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-4.0", new LicenseData(licenseID: "CC-BY-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CC-BY-NC-1.0", new LicenseData(licenseID: "CC-BY-NC-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-2.0", new LicenseData(licenseID: "CC-BY-NC-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-2.5", new LicenseData(licenseID: "CC-BY-NC-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-3.0", new LicenseData(licenseID: "CC-BY-NC-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-3.0-DE", new LicenseData(licenseID: "CC-BY-NC-3.0-DE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-4.0", new LicenseData(licenseID: "CC-BY-NC-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-1.0", new LicenseData(licenseID: "CC-BY-NC-ND-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-2.0", new LicenseData(licenseID: "CC-BY-NC-ND-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-2.5", new LicenseData(licenseID: "CC-BY-NC-ND-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-3.0", new LicenseData(licenseID: "CC-BY-NC-ND-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-3.0-DE", new LicenseData(licenseID: "CC-BY-NC-ND-3.0-DE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-3.0-IGO", new LicenseData(licenseID: "CC-BY-NC-ND-3.0-IGO", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-4.0", new LicenseData(licenseID: "CC-BY-NC-ND-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-1.0", new LicenseData(licenseID: "CC-BY-NC-SA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-2.0", new LicenseData(licenseID: "CC-BY-NC-SA-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-2.0-DE", new LicenseData(licenseID: "CC-BY-NC-SA-2.0-DE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-2.0-FR", new LicenseData(licenseID: "CC-BY-NC-SA-2.0-FR", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-2.0-UK", new LicenseData(licenseID: "CC-BY-NC-SA-2.0-UK", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-2.5", new LicenseData(licenseID: "CC-BY-NC-SA-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-3.0", new LicenseData(licenseID: "CC-BY-NC-SA-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-3.0-DE", new LicenseData(licenseID: "CC-BY-NC-SA-3.0-DE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-3.0-IGO", new LicenseData(licenseID: "CC-BY-NC-SA-3.0-IGO", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-4.0", new LicenseData(licenseID: "CC-BY-NC-SA-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-1.0", new LicenseData(licenseID: "CC-BY-ND-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-2.0", new LicenseData(licenseID: "CC-BY-ND-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-2.5", new LicenseData(licenseID: "CC-BY-ND-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-3.0", new LicenseData(licenseID: "CC-BY-ND-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-3.0-DE", new LicenseData(licenseID: "CC-BY-ND-3.0-DE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-4.0", new LicenseData(licenseID: "CC-BY-ND-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-1.0", new LicenseData(licenseID: "CC-BY-SA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-2.0", new LicenseData(licenseID: "CC-BY-SA-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-2.0-UK", new LicenseData(licenseID: "CC-BY-SA-2.0-UK", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-2.1-JP", new LicenseData(licenseID: "CC-BY-SA-2.1-JP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-2.5", new LicenseData(licenseID: "CC-BY-SA-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-3.0", new LicenseData(licenseID: "CC-BY-SA-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-3.0-AT", new LicenseData(licenseID: "CC-BY-SA-3.0-AT", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-3.0-DE", new LicenseData(licenseID: "CC-BY-SA-3.0-DE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-3.0-IGO", new LicenseData(licenseID: "CC-BY-SA-3.0-IGO", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-4.0", new LicenseData(licenseID: "CC-BY-SA-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CC-PDDC", new LicenseData(licenseID: "CC-PDDC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-PDM-1.0", new LicenseData(licenseID: "CC-PDM-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-SA-1.0", new LicenseData(licenseID: "CC-SA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC0-1.0", new LicenseData(licenseID: "CC0-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CDDL-1.0", new LicenseData(licenseID: "CDDL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CDDL-1.1", new LicenseData(licenseID: "CDDL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CDL-1.0", new LicenseData(licenseID: "CDL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CDLA-Permissive-1.0", new LicenseData(licenseID: "CDLA-Permissive-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CDLA-Permissive-2.0", new LicenseData(licenseID: "CDLA-Permissive-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CDLA-Sharing-1.0", new LicenseData(licenseID: "CDLA-Sharing-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-1.0", new LicenseData(licenseID: "CECILL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-1.1", new LicenseData(licenseID: "CECILL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-2.0", new LicenseData(licenseID: "CECILL-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CECILL-2.1", new LicenseData(licenseID: "CECILL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-B", new LicenseData(licenseID: "CECILL-B", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CECILL-C", new LicenseData(licenseID: "CECILL-C", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CERN-OHL-1.1", new LicenseData(licenseID: "CERN-OHL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-1.2", new LicenseData(licenseID: "CERN-OHL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-P-2.0", new LicenseData(licenseID: "CERN-OHL-P-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-S-2.0", new LicenseData(licenseID: "CERN-OHL-S-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-W-2.0", new LicenseData(licenseID: "CERN-OHL-W-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CFITSIO", new LicenseData(licenseID: "CFITSIO", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "check-cvs", new LicenseData(licenseID: "check-cvs", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "checkmk", new LicenseData(licenseID: "checkmk", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ClArtistic", new LicenseData(licenseID: "ClArtistic", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Clips", new LicenseData(licenseID: "Clips", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CMU-Mach", new LicenseData(licenseID: "CMU-Mach", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CMU-Mach-nodoc", new LicenseData(licenseID: "CMU-Mach-nodoc", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CNRI-Jython", new LicenseData(licenseID: "CNRI-Jython", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CNRI-Python", new LicenseData(licenseID: "CNRI-Python", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CNRI-Python-GPL-Compatible", new LicenseData(licenseID: "CNRI-Python-GPL-Compatible", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "COIL-1.0", new LicenseData(licenseID: "COIL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Community-Spec-1.0", new LicenseData(licenseID: "Community-Spec-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Condor-1.1", new LicenseData(licenseID: "Condor-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "copyleft-next-0.3.0", new LicenseData(licenseID: "copyleft-next-0.3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "copyleft-next-0.3.1", new LicenseData(licenseID: "copyleft-next-0.3.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Cornell-Lossless-JPEG", new LicenseData(licenseID: "Cornell-Lossless-JPEG", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CPAL-1.0", new LicenseData(licenseID: "CPAL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CPL-1.0", new LicenseData(licenseID: "CPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CPOL-1.02", new LicenseData(licenseID: "CPOL-1.02", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Cronyx", new LicenseData(licenseID: "Cronyx", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Crossword", new LicenseData(licenseID: "Crossword", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CryptoSwift", new LicenseData(licenseID: "CryptoSwift", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CrystalStacker", new LicenseData(licenseID: "CrystalStacker", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CUA-OPL-1.0", new LicenseData(licenseID: "CUA-OPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Cube", new LicenseData(licenseID: "Cube", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "curl", new LicenseData(licenseID: "curl", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "cve-tou", new LicenseData(licenseID: "cve-tou", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "D-FSL-1.0", new LicenseData(licenseID: "D-FSL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DEC-3-Clause", new LicenseData(licenseID: "DEC-3-Clause", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "diffmark", new LicenseData(licenseID: "diffmark", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DL-DE-BY-2.0", new LicenseData(licenseID: "DL-DE-BY-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DL-DE-ZERO-2.0", new LicenseData(licenseID: "DL-DE-ZERO-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DOC", new LicenseData(licenseID: "DOC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DocBook-DTD", new LicenseData(licenseID: "DocBook-DTD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DocBook-Schema", new LicenseData(licenseID: "DocBook-Schema", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DocBook-Stylesheet", new LicenseData(licenseID: "DocBook-Stylesheet", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DocBook-XML", new LicenseData(licenseID: "DocBook-XML", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Dotseqn", new LicenseData(licenseID: "Dotseqn", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DRL-1.0", new LicenseData(licenseID: "DRL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DRL-1.1", new LicenseData(licenseID: "DRL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DSDP", new LicenseData(licenseID: "DSDP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "dtoa", new LicenseData(licenseID: "dtoa", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "dvipdfm", new LicenseData(licenseID: "dvipdfm", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ECL-1.0", new LicenseData(licenseID: "ECL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ECL-2.0", new LicenseData(licenseID: "ECL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "eCos-2.0", new LicenseData(licenseID: "eCos-2.0", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "EFL-1.0", new LicenseData(licenseID: "EFL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EFL-2.0", new LicenseData(licenseID: "EFL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "eGenix", new LicenseData(licenseID: "eGenix", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Elastic-2.0", new LicenseData(licenseID: "Elastic-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Entessa", new LicenseData(licenseID: "Entessa", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EPICS", new LicenseData(licenseID: "EPICS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EPL-1.0", new LicenseData(licenseID: "EPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "EPL-2.0", new LicenseData(licenseID: "EPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ErlPL-1.1", new LicenseData(licenseID: "ErlPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "etalab-2.0", new LicenseData(licenseID: "etalab-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EUDatagrid", new LicenseData(licenseID: "EUDatagrid", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "EUPL-1.0", new LicenseData(licenseID: "EUPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EUPL-1.1", new LicenseData(licenseID: "EUPL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "EUPL-1.2", new LicenseData(licenseID: "EUPL-1.2", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Eurosym", new LicenseData(licenseID: "Eurosym", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Fair", new LicenseData(licenseID: "Fair", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FBM", new LicenseData(licenseID: "FBM", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FDK-AAC", new LicenseData(licenseID: "FDK-AAC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Ferguson-Twofish", new LicenseData(licenseID: "Ferguson-Twofish", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Frameworx-1.0", new LicenseData(licenseID: "Frameworx-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FreeBSD-DOC", new LicenseData(licenseID: "FreeBSD-DOC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FreeImage", new LicenseData(licenseID: "FreeImage", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSFAP", new LicenseData(licenseID: "FSFAP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "FSFAP-no-warranty-disclaimer", new LicenseData(licenseID: "FSFAP-no-warranty-disclaimer", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSFUL", new LicenseData(licenseID: "FSFUL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSFULLR", new LicenseData(licenseID: "FSFULLR", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSFULLRSD", new LicenseData(licenseID: "FSFULLRSD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSFULLRWD", new LicenseData(licenseID: "FSFULLRWD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSL-1.1-ALv2", new LicenseData(licenseID: "FSL-1.1-ALv2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSL-1.1-MIT", new LicenseData(licenseID: "FSL-1.1-MIT", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FTL", new LicenseData(licenseID: "FTL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Furuseth", new LicenseData(licenseID: "Furuseth", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "fwlw", new LicenseData(licenseID: "fwlw", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Game-Programming-Gems", new LicenseData(licenseID: "Game-Programming-Gems", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GCR-docs", new LicenseData(licenseID: "GCR-docs", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GD", new LicenseData(licenseID: "GD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "generic-xts", new LicenseData(licenseID: "generic-xts", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1", new LicenseData(licenseID: "GFDL-1.1", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GFDL-1.1-invariants-only", new LicenseData(licenseID: "GFDL-1.1-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-invariants-or-later", new LicenseData(licenseID: "GFDL-1.1-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-no-invariants-only", new LicenseData(licenseID: "GFDL-1.1-no-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-no-invariants-or-later", new LicenseData(licenseID: "GFDL-1.1-no-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-only", new LicenseData(licenseID: "GFDL-1.1-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.1-or-later", new LicenseData(licenseID: "GFDL-1.1-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.2", new LicenseData(licenseID: "GFDL-1.2", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GFDL-1.2-invariants-only", new LicenseData(licenseID: "GFDL-1.2-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-invariants-or-later", new LicenseData(licenseID: "GFDL-1.2-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-no-invariants-only", new LicenseData(licenseID: "GFDL-1.2-no-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-no-invariants-or-later", new LicenseData(licenseID: "GFDL-1.2-no-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-only", new LicenseData(licenseID: "GFDL-1.2-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.2-or-later", new LicenseData(licenseID: "GFDL-1.2-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.3", new LicenseData(licenseID: "GFDL-1.3", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GFDL-1.3-invariants-only", new LicenseData(licenseID: "GFDL-1.3-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-invariants-or-later", new LicenseData(licenseID: "GFDL-1.3-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-no-invariants-only", new LicenseData(licenseID: "GFDL-1.3-no-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-no-invariants-or-later", new LicenseData(licenseID: "GFDL-1.3-no-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-only", new LicenseData(licenseID: "GFDL-1.3-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.3-or-later", new LicenseData(licenseID: "GFDL-1.3-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Giftware", new LicenseData(licenseID: "Giftware", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GL2PS", new LicenseData(licenseID: "GL2PS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Glide", new LicenseData(licenseID: "Glide", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Glulxe", new LicenseData(licenseID: "Glulxe", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GLWTPL", new LicenseData(licenseID: "GLWTPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "gnuplot", new LicenseData(licenseID: "gnuplot", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-1.0", new LicenseData(licenseID: "GPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-1.0-only", new LicenseData(licenseID: "GPL-1.0-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GPL-1.0-or-later", new LicenseData(licenseID: "GPL-1.0-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GPL-1.0+", new LicenseData(licenseID: "GPL-1.0+", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0", new LicenseData(licenseID: "GPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GPL-2.0-only", new LicenseData(licenseID: "GPL-2.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-2.0-or-later", new LicenseData(licenseID: "GPL-2.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-2.0-with-autoconf-exception", new LicenseData(licenseID: "GPL-2.0-with-autoconf-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-bison-exception", new LicenseData(licenseID: "GPL-2.0-with-bison-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-classpath-exception", new LicenseData(licenseID: "GPL-2.0-with-classpath-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-font-exception", new LicenseData(licenseID: "GPL-2.0-with-font-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-GCC-exception", new LicenseData(licenseID: "GPL-2.0-with-GCC-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0+", new LicenseData(licenseID: "GPL-2.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GPL-3.0", new LicenseData(licenseID: "GPL-3.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GPL-3.0-only", new LicenseData(licenseID: "GPL-3.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-3.0-or-later", new LicenseData(licenseID: "GPL-3.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-3.0-with-autoconf-exception", new LicenseData(licenseID: "GPL-3.0-with-autoconf-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-3.0-with-GCC-exception", new LicenseData(licenseID: "GPL-3.0-with-GCC-exception", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-3.0+", new LicenseData(licenseID: "GPL-3.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "Graphics-Gems", new LicenseData(licenseID: "Graphics-Gems", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "gSOAP-1.3b", new LicenseData(licenseID: "gSOAP-1.3b", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "gtkbook", new LicenseData(licenseID: "gtkbook", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Gutmann", new LicenseData(licenseID: "Gutmann", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HaskellReport", new LicenseData(licenseID: "HaskellReport", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HDF5", new LicenseData(licenseID: "HDF5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "hdparm", new LicenseData(licenseID: "hdparm", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HIDAPI", new LicenseData(licenseID: "HIDAPI", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Hippocratic-2.1", new LicenseData(licenseID: "Hippocratic-2.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HP-1986", new LicenseData(licenseID: "HP-1986", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HP-1989", new LicenseData(licenseID: "HP-1989", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND", new LicenseData(licenseID: "HPND", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "HPND-DEC", new LicenseData(licenseID: "HPND-DEC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-doc", new LicenseData(licenseID: "HPND-doc", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-doc-sell", new LicenseData(licenseID: "HPND-doc-sell", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-export-US", new LicenseData(licenseID: "HPND-export-US", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-export-US-acknowledgement", new LicenseData(licenseID: "HPND-export-US-acknowledgement", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-export-US-modify", new LicenseData(licenseID: "HPND-export-US-modify", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-export2-US", new LicenseData(licenseID: "HPND-export2-US", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-Fenneberg-Livingston", new LicenseData(licenseID: "HPND-Fenneberg-Livingston", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-INRIA-IMAG", new LicenseData(licenseID: "HPND-INRIA-IMAG", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-Intel", new LicenseData(licenseID: "HPND-Intel", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-Kevlin-Henney", new LicenseData(licenseID: "HPND-Kevlin-Henney", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-Markus-Kuhn", new LicenseData(licenseID: "HPND-Markus-Kuhn", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-merchantability-variant", new LicenseData(licenseID: "HPND-merchantability-variant", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-MIT-disclaimer", new LicenseData(licenseID: "HPND-MIT-disclaimer", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-Netrek", new LicenseData(licenseID: "HPND-Netrek", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-Pbmplus", new LicenseData(licenseID: "HPND-Pbmplus", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-sell-MIT-disclaimer-xserver", new LicenseData(licenseID: "HPND-sell-MIT-disclaimer-xserver", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-sell-regexpr", new LicenseData(licenseID: "HPND-sell-regexpr", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-sell-variant", new LicenseData(licenseID: "HPND-sell-variant", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-sell-variant-MIT-disclaimer", new LicenseData(licenseID: "HPND-sell-variant-MIT-disclaimer", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-sell-variant-MIT-disclaimer-rev", new LicenseData(licenseID: "HPND-sell-variant-MIT-disclaimer-rev", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-UC", new LicenseData(licenseID: "HPND-UC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND-UC-export-US", new LicenseData(licenseID: "HPND-UC-export-US", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HTMLTIDY", new LicenseData(licenseID: "HTMLTIDY", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "IBM-pibs", new LicenseData(licenseID: "IBM-pibs", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ICU", new LicenseData(licenseID: "ICU", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "IEC-Code-Components-EULA", new LicenseData(licenseID: "IEC-Code-Components-EULA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "IJG", new LicenseData(licenseID: "IJG", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "IJG-short", new LicenseData(licenseID: "IJG-short", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ImageMagick", new LicenseData(licenseID: "ImageMagick", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "iMatix", new LicenseData(licenseID: "iMatix", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Imlib2", new LicenseData(licenseID: "Imlib2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Info-ZIP", new LicenseData(licenseID: "Info-ZIP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Inner-Net-2.0", new LicenseData(licenseID: "Inner-Net-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "InnoSetup", new LicenseData(licenseID: "InnoSetup", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Intel", new LicenseData(licenseID: "Intel", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Intel-ACPI", new LicenseData(licenseID: "Intel-ACPI", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Interbase-1.0", new LicenseData(licenseID: "Interbase-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "IPA", new LicenseData(licenseID: "IPA", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "IPL-1.0", new LicenseData(licenseID: "IPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ISC", new LicenseData(licenseID: "ISC", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ISC-Veillard", new LicenseData(licenseID: "ISC-Veillard", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Jam", new LicenseData(licenseID: "Jam", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "JasPer-2.0", new LicenseData(licenseID: "JasPer-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "jove", new LicenseData(licenseID: "jove", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "JPL-image", new LicenseData(licenseID: "JPL-image", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "JPNIC", new LicenseData(licenseID: "JPNIC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "JSON", new LicenseData(licenseID: "JSON", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Kastrup", new LicenseData(licenseID: "Kastrup", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Kazlib", new LicenseData(licenseID: "Kazlib", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Knuth-CTAN", new LicenseData(licenseID: "Knuth-CTAN", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LAL-1.2", new LicenseData(licenseID: "LAL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LAL-1.3", new LicenseData(licenseID: "LAL-1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Latex2e", new LicenseData(licenseID: "Latex2e", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Latex2e-translated-notice", new LicenseData(licenseID: "Latex2e-translated-notice", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Leptonica", new LicenseData(licenseID: "Leptonica", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LGPL-2.0", new LicenseData(licenseID: "LGPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "LGPL-2.0-only", new LicenseData(licenseID: "LGPL-2.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LGPL-2.0-or-later", new LicenseData(licenseID: "LGPL-2.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LGPL-2.0+", new LicenseData(licenseID: "LGPL-2.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "LGPL-2.1", new LicenseData(licenseID: "LGPL-2.1", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPL-2.1-only", new LicenseData(licenseID: "LGPL-2.1-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPL-2.1-or-later", new LicenseData(licenseID: "LGPL-2.1-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPL-2.1+", new LicenseData(licenseID: "LGPL-2.1+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPL-3.0", new LicenseData(licenseID: "LGPL-3.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPL-3.0-only", new LicenseData(licenseID: "LGPL-3.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPL-3.0-or-later", new LicenseData(licenseID: "LGPL-3.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPL-3.0+", new LicenseData(licenseID: "LGPL-3.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPLLR", new LicenseData(licenseID: "LGPLLR", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Libpng", new LicenseData(licenseID: "Libpng", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libpng-1.6.35", new LicenseData(licenseID: "libpng-1.6.35", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libpng-2.0", new LicenseData(licenseID: "libpng-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libselinux-1.0", new LicenseData(licenseID: "libselinux-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libtiff", new LicenseData(licenseID: "libtiff", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libutil-David-Nugent", new LicenseData(licenseID: "libutil-David-Nugent", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LiLiQ-P-1.1", new LicenseData(licenseID: "LiLiQ-P-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LiLiQ-R-1.1", new LicenseData(licenseID: "LiLiQ-R-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LiLiQ-Rplus-1.1", new LicenseData(licenseID: "LiLiQ-Rplus-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Linux-man-pages-1-para", new LicenseData(licenseID: "Linux-man-pages-1-para", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Linux-man-pages-copyleft", new LicenseData(licenseID: "Linux-man-pages-copyleft", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Linux-man-pages-copyleft-2-para", new LicenseData(licenseID: "Linux-man-pages-copyleft-2-para", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Linux-man-pages-copyleft-var", new LicenseData(licenseID: "Linux-man-pages-copyleft-var", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Linux-OpenIB", new LicenseData(licenseID: "Linux-OpenIB", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LOOP", new LicenseData(licenseID: "LOOP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPD-document", new LicenseData(licenseID: "LPD-document", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPL-1.0", new LicenseData(licenseID: "LPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPL-1.02", new LicenseData(licenseID: "LPL-1.02", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LPPL-1.0", new LicenseData(licenseID: "LPPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPPL-1.1", new LicenseData(licenseID: "LPPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPPL-1.2", new LicenseData(licenseID: "LPPL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LPPL-1.3a", new LicenseData(licenseID: "LPPL-1.3a", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LPPL-1.3c", new LicenseData(licenseID: "LPPL-1.3c", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "lsof", new LicenseData(licenseID: "lsof", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Lucida-Bitmap-Fonts", new LicenseData(licenseID: "Lucida-Bitmap-Fonts", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LZMA-SDK-9.11-to-9.20", new LicenseData(licenseID: "LZMA-SDK-9.11-to-9.20", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LZMA-SDK-9.22", new LicenseData(licenseID: "LZMA-SDK-9.22", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Mackerras-3-Clause", new LicenseData(licenseID: "Mackerras-3-Clause", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Mackerras-3-Clause-acknowledgment", new LicenseData(licenseID: "Mackerras-3-Clause-acknowledgment", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "magaz", new LicenseData(licenseID: "magaz", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "mailprio", new LicenseData(licenseID: "mailprio", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MakeIndex", new LicenseData(licenseID: "MakeIndex", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "man2html", new LicenseData(licenseID: "man2html", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Martin-Birgmeier", new LicenseData(licenseID: "Martin-Birgmeier", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "McPhee-slideshow", new LicenseData(licenseID: "McPhee-slideshow", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "metamail", new LicenseData(licenseID: "metamail", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Minpack", new LicenseData(licenseID: "Minpack", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIPS", new LicenseData(licenseID: "MIPS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MirOS", new LicenseData(licenseID: "MirOS", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT", new LicenseData(licenseID: "MIT", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MIT-0", new LicenseData(licenseID: "MIT-0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-advertising", new LicenseData(licenseID: "MIT-advertising", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-Click", new LicenseData(licenseID: "MIT-Click", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-CMU", new LicenseData(licenseID: "MIT-CMU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-enna", new LicenseData(licenseID: "MIT-enna", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-feh", new LicenseData(licenseID: "MIT-feh", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-Festival", new LicenseData(licenseID: "MIT-Festival", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-Khronos-old", new LicenseData(licenseID: "MIT-Khronos-old", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-Modern-Variant", new LicenseData(licenseID: "MIT-Modern-Variant", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-open-group", new LicenseData(licenseID: "MIT-open-group", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-testregex", new LicenseData(licenseID: "MIT-testregex", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-Wu", new LicenseData(licenseID: "MIT-Wu", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MITNFA", new LicenseData(licenseID: "MITNFA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MMIXware", new LicenseData(licenseID: "MMIXware", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Motosoto", new LicenseData(licenseID: "Motosoto", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MPEG-SSG", new LicenseData(licenseID: "MPEG-SSG", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "mpi-permissive", new LicenseData(licenseID: "mpi-permissive", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "mpich2", new LicenseData(licenseID: "mpich2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MPL-1.0", new LicenseData(licenseID: "MPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MPL-1.1", new LicenseData(licenseID: "MPL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MPL-2.0", new LicenseData(licenseID: "MPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MPL-2.0-no-copyleft-exception", new LicenseData(licenseID: "MPL-2.0-no-copyleft-exception", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "mplus", new LicenseData(licenseID: "mplus", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MS-LPL", new LicenseData(licenseID: "MS-LPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MS-PL", new LicenseData(licenseID: "MS-PL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MS-RL", new LicenseData(licenseID: "MS-RL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MTLL", new LicenseData(licenseID: "MTLL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MulanPSL-1.0", new LicenseData(licenseID: "MulanPSL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MulanPSL-2.0", new LicenseData(licenseID: "MulanPSL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Multics", new LicenseData(licenseID: "Multics", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Mup", new LicenseData(licenseID: "Mup", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NAIST-2003", new LicenseData(licenseID: "NAIST-2003", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NASA-1.3", new LicenseData(licenseID: "NASA-1.3", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Naumen", new LicenseData(licenseID: "Naumen", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NBPL-1.0", new LicenseData(licenseID: "NBPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NCBI-PD", new LicenseData(licenseID: "NCBI-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NCGL-UK-2.0", new LicenseData(licenseID: "NCGL-UK-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NCL", new LicenseData(licenseID: "NCL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NCSA", new LicenseData(licenseID: "NCSA", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Net-SNMP", new LicenseData(licenseID: "Net-SNMP", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "NetCDF", new LicenseData(licenseID: "NetCDF", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Newsletr", new LicenseData(licenseID: "Newsletr", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NGPL", new LicenseData(licenseID: "NGPL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ngrep", new LicenseData(licenseID: "ngrep", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NICTA-1.0", new LicenseData(licenseID: "NICTA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NIST-PD", new LicenseData(licenseID: "NIST-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NIST-PD-fallback", new LicenseData(licenseID: "NIST-PD-fallback", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NIST-Software", new LicenseData(licenseID: "NIST-Software", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NLOD-1.0", new LicenseData(licenseID: "NLOD-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NLOD-2.0", new LicenseData(licenseID: "NLOD-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NLPL", new LicenseData(licenseID: "NLPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Nokia", new LicenseData(licenseID: "Nokia", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "NOSL", new LicenseData(licenseID: "NOSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Noweb", new LicenseData(licenseID: "Noweb", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NPL-1.0", new LicenseData(licenseID: "NPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "NPL-1.1", new LicenseData(licenseID: "NPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "NPOSL-3.0", new LicenseData(licenseID: "NPOSL-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NRL", new LicenseData(licenseID: "NRL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NTIA-PD", new LicenseData(licenseID: "NTIA-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NTP", new LicenseData(licenseID: "NTP", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NTP-0", new LicenseData(licenseID: "NTP-0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Nunit", new LicenseData(licenseID: "Nunit", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "O-UDA-1.0", new LicenseData(licenseID: "O-UDA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OAR", new LicenseData(licenseID: "OAR", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OCCT-PL", new LicenseData(licenseID: "OCCT-PL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OCLC-2.0", new LicenseData(licenseID: "OCLC-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ODbL-1.0", new LicenseData(licenseID: "ODbL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ODC-By-1.0", new LicenseData(licenseID: "ODC-By-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFFIS", new LicenseData(licenseID: "OFFIS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.0", new LicenseData(licenseID: "OFL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OFL-1.0-no-RFN", new LicenseData(licenseID: "OFL-1.0-no-RFN", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.0-RFN", new LicenseData(licenseID: "OFL-1.0-RFN", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.1", new LicenseData(licenseID: "OFL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OFL-1.1-no-RFN", new LicenseData(licenseID: "OFL-1.1-no-RFN", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.1-RFN", new LicenseData(licenseID: "OFL-1.1-RFN", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGC-1.0", new LicenseData(licenseID: "OGC-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGDL-Taiwan-1.0", new LicenseData(licenseID: "OGDL-Taiwan-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-Canada-2.0", new LicenseData(licenseID: "OGL-Canada-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-UK-1.0", new LicenseData(licenseID: "OGL-UK-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-UK-2.0", new LicenseData(licenseID: "OGL-UK-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-UK-3.0", new LicenseData(licenseID: "OGL-UK-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGTSL", new LicenseData(licenseID: "OGTSL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.1", new LicenseData(licenseID: "OLDAP-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.2", new LicenseData(licenseID: "OLDAP-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.3", new LicenseData(licenseID: "OLDAP-1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.4", new LicenseData(licenseID: "OLDAP-1.4", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.0", new LicenseData(licenseID: "OLDAP-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.0.1", new LicenseData(licenseID: "OLDAP-2.0.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.1", new LicenseData(licenseID: "OLDAP-2.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.2", new LicenseData(licenseID: "OLDAP-2.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.2.1", new LicenseData(licenseID: "OLDAP-2.2.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.2.2", new LicenseData(licenseID: "OLDAP-2.2.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.3", new LicenseData(licenseID: "OLDAP-2.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OLDAP-2.4", new LicenseData(licenseID: "OLDAP-2.4", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.5", new LicenseData(licenseID: "OLDAP-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.6", new LicenseData(licenseID: "OLDAP-2.6", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.7", new LicenseData(licenseID: "OLDAP-2.7", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OLDAP-2.8", new LicenseData(licenseID: "OLDAP-2.8", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLFL-1.3", new LicenseData(licenseID: "OLFL-1.3", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OML", new LicenseData(licenseID: "OML", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OpenPBS-2.3", new LicenseData(licenseID: "OpenPBS-2.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OpenSSL", new LicenseData(licenseID: "OpenSSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OpenSSL-standalone", new LicenseData(licenseID: "OpenSSL-standalone", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OpenVision", new LicenseData(licenseID: "OpenVision", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OPL-1.0", new LicenseData(licenseID: "OPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OPL-UK-3.0", new LicenseData(licenseID: "OPL-UK-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OPUBL-1.0", new LicenseData(licenseID: "OPUBL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OSET-PL-2.1", new LicenseData(licenseID: "OSET-PL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OSL-1.0", new LicenseData(licenseID: "OSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-1.1", new LicenseData(licenseID: "OSL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-2.0", new LicenseData(licenseID: "OSL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-2.1", new LicenseData(licenseID: "OSL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-3.0", new LicenseData(licenseID: "OSL-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "PADL", new LicenseData(licenseID: "PADL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Parity-6.0.0", new LicenseData(licenseID: "Parity-6.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Parity-7.0.0", new LicenseData(licenseID: "Parity-7.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PDDL-1.0", new LicenseData(licenseID: "PDDL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PHP-3.0", new LicenseData(licenseID: "PHP-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PHP-3.01", new LicenseData(licenseID: "PHP-3.01", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Pixar", new LicenseData(licenseID: "Pixar", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "pkgconf", new LicenseData(licenseID: "pkgconf", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Plexus", new LicenseData(licenseID: "Plexus", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "pnmstitch", new LicenseData(licenseID: "pnmstitch", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PolyForm-Noncommercial-1.0.0", new LicenseData(licenseID: "PolyForm-Noncommercial-1.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PolyForm-Small-Business-1.0.0", new LicenseData(licenseID: "PolyForm-Small-Business-1.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PostgreSQL", new LicenseData(licenseID: "PostgreSQL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PPL", new LicenseData(licenseID: "PPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PSF-2.0", new LicenseData(licenseID: "PSF-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "psfrag", new LicenseData(licenseID: "psfrag", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "psutils", new LicenseData(licenseID: "psutils", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Python-2.0", new LicenseData(licenseID: "Python-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Python-2.0.1", new LicenseData(licenseID: "Python-2.0.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "python-ldap", new LicenseData(licenseID: "python-ldap", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Qhull", new LicenseData(licenseID: "Qhull", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "QPL-1.0", new LicenseData(licenseID: "QPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "QPL-1.0-INRIA-2004", new LicenseData(licenseID: "QPL-1.0-INRIA-2004", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "radvd", new LicenseData(licenseID: "radvd", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Rdisc", new LicenseData(licenseID: "Rdisc", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RHeCos-1.1", new LicenseData(licenseID: "RHeCos-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RPL-1.1", new LicenseData(licenseID: "RPL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RPL-1.5", new LicenseData(licenseID: "RPL-1.5", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RPSL-1.0", new LicenseData(licenseID: "RPSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "RSA-MD", new LicenseData(licenseID: "RSA-MD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RSCPL", new LicenseData(licenseID: "RSCPL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Ruby", new LicenseData(licenseID: "Ruby", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Ruby-pty", new LicenseData(licenseID: "Ruby-pty", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SAX-PD", new LicenseData(licenseID: "SAX-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SAX-PD-2.0", new LicenseData(licenseID: "SAX-PD-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Saxpath", new LicenseData(licenseID: "Saxpath", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SCEA", new LicenseData(licenseID: "SCEA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SchemeReport", new LicenseData(licenseID: "SchemeReport", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sendmail", new LicenseData(licenseID: "Sendmail", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sendmail-8.23", new LicenseData(licenseID: "Sendmail-8.23", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sendmail-Open-Source-1.1", new LicenseData(licenseID: "Sendmail-Open-Source-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SGI-B-1.0", new LicenseData(licenseID: "SGI-B-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SGI-B-1.1", new LicenseData(licenseID: "SGI-B-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SGI-B-2.0", new LicenseData(licenseID: "SGI-B-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SGI-OpenGL", new LicenseData(licenseID: "SGI-OpenGL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SGP4", new LicenseData(licenseID: "SGP4", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SHL-0.5", new LicenseData(licenseID: "SHL-0.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SHL-0.51", new LicenseData(licenseID: "SHL-0.51", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SimPL-2.0", new LicenseData(licenseID: "SimPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SISSL", new LicenseData(licenseID: "SISSL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SISSL-1.2", new LicenseData(licenseID: "SISSL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SL", new LicenseData(licenseID: "SL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sleepycat", new LicenseData(licenseID: "Sleepycat", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SMAIL-GPL", new LicenseData(licenseID: "SMAIL-GPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SMLNJ", new LicenseData(licenseID: "SMLNJ", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SMPPL", new LicenseData(licenseID: "SMPPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SNIA", new LicenseData(licenseID: "SNIA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "snprintf", new LicenseData(licenseID: "snprintf", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SOFA", new LicenseData(licenseID: "SOFA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "softSurfer", new LicenseData(licenseID: "softSurfer", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Soundex", new LicenseData(licenseID: "Soundex", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Spencer-86", new LicenseData(licenseID: "Spencer-86", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Spencer-94", new LicenseData(licenseID: "Spencer-94", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Spencer-99", new LicenseData(licenseID: "Spencer-99", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SPL-1.0", new LicenseData(licenseID: "SPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ssh-keyscan", new LicenseData(licenseID: "ssh-keyscan", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SSH-OpenSSH", new LicenseData(licenseID: "SSH-OpenSSH", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SSH-short", new LicenseData(licenseID: "SSH-short", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SSLeay-standalone", new LicenseData(licenseID: "SSLeay-standalone", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SSPL-1.0", new LicenseData(licenseID: "SSPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "StandardML-NJ", new LicenseData(licenseID: "StandardML-NJ", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "SugarCRM-1.1.3", new LicenseData(licenseID: "SugarCRM-1.1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SUL-1.0", new LicenseData(licenseID: "SUL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sun-PPP", new LicenseData(licenseID: "Sun-PPP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sun-PPP-2000", new LicenseData(licenseID: "Sun-PPP-2000", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SunPro", new LicenseData(licenseID: "SunPro", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SWL", new LicenseData(licenseID: "SWL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "swrule", new LicenseData(licenseID: "swrule", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Symlinks", new LicenseData(licenseID: "Symlinks", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TAPR-OHL-1.0", new LicenseData(licenseID: "TAPR-OHL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TCL", new LicenseData(licenseID: "TCL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TCP-wrappers", new LicenseData(licenseID: "TCP-wrappers", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TermReadKey", new LicenseData(licenseID: "TermReadKey", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TGPPL-1.0", new LicenseData(licenseID: "TGPPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ThirdEye", new LicenseData(licenseID: "ThirdEye", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "threeparttable", new LicenseData(licenseID: "threeparttable", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TMate", new LicenseData(licenseID: "TMate", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TORQUE-1.1", new LicenseData(licenseID: "TORQUE-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TOSL", new LicenseData(licenseID: "TOSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TPDL", new LicenseData(licenseID: "TPDL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TPL-1.0", new LicenseData(licenseID: "TPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TrustedQSL", new LicenseData(licenseID: "TrustedQSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TTWL", new LicenseData(licenseID: "TTWL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TTYP0", new LicenseData(licenseID: "TTYP0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TU-Berlin-1.0", new LicenseData(licenseID: "TU-Berlin-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TU-Berlin-2.0", new LicenseData(licenseID: "TU-Berlin-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Ubuntu-font-1.0", new LicenseData(licenseID: "Ubuntu-font-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "UCAR", new LicenseData(licenseID: "UCAR", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "UCL-1.0", new LicenseData(licenseID: "UCL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ulem", new LicenseData(licenseID: "ulem", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "UMich-Merit", new LicenseData(licenseID: "UMich-Merit", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unicode-3.0", new LicenseData(licenseID: "Unicode-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unicode-DFS-2015", new LicenseData(licenseID: "Unicode-DFS-2015", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unicode-DFS-2016", new LicenseData(licenseID: "Unicode-DFS-2016", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unicode-TOU", new LicenseData(licenseID: "Unicode-TOU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "UnixCrypt", new LicenseData(licenseID: "UnixCrypt", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unlicense", new LicenseData(licenseID: "Unlicense", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Unlicense-libtelnet", new LicenseData(licenseID: "Unlicense-libtelnet", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unlicense-libwhirlpool", new LicenseData(licenseID: "Unlicense-libwhirlpool", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "UPL-1.0", new LicenseData(licenseID: "UPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "URT-RLE", new LicenseData(licenseID: "URT-RLE", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Vim", new LicenseData(licenseID: "Vim", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "VOSTROM", new LicenseData(licenseID: "VOSTROM", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "VSL-1.0", new LicenseData(licenseID: "VSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "W3C", new LicenseData(licenseID: "W3C", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "W3C-19980720", new LicenseData(licenseID: "W3C-19980720", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "W3C-20150513", new LicenseData(licenseID: "W3C-20150513", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "w3m", new LicenseData(licenseID: "w3m", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Watcom-1.0", new LicenseData(licenseID: "Watcom-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Widget-Workshop", new LicenseData(licenseID: "Widget-Workshop", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "WordNet", new LicenseData(licenseID: "WordNet", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Wsuipa", new LicenseData(licenseID: "Wsuipa", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "WTFPL", new LicenseData(licenseID: "WTFPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "wwl", new LicenseData(licenseID: "wwl", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "wxWindows", new LicenseData(licenseID: "wxWindows", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "X11", new LicenseData(licenseID: "X11", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "X11-distribute-modifications-variant", new LicenseData(licenseID: "X11-distribute-modifications-variant", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "X11-swapped", new LicenseData(licenseID: "X11-swapped", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Xdebug-1.03", new LicenseData(licenseID: "Xdebug-1.03", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Xerox", new LicenseData(licenseID: "Xerox", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Xfig", new LicenseData(licenseID: "Xfig", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "XFree86-1.1", new LicenseData(licenseID: "XFree86-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "xinetd", new LicenseData(licenseID: "xinetd", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "xkeyboard-config-Zinoviev", new LicenseData(licenseID: "xkeyboard-config-Zinoviev", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "xlock", new LicenseData(licenseID: "xlock", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Xnet", new LicenseData(licenseID: "Xnet", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "xpp", new LicenseData(licenseID: "xpp", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "XSkat", new LicenseData(licenseID: "XSkat", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "xzoom", new LicenseData(licenseID: "xzoom", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "YPL-1.0", new LicenseData(licenseID: "YPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "YPL-1.1", new LicenseData(licenseID: "YPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Zed", new LicenseData(licenseID: "Zed", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Zeeff", new LicenseData(licenseID: "Zeeff", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Zend-2.0", new LicenseData(licenseID: "Zend-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Zimbra-1.3", new LicenseData(licenseID: "Zimbra-1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Zimbra-1.4", new LicenseData(licenseID: "Zimbra-1.4", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Zlib", new LicenseData(licenseID: "Zlib", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "zlib-acknowledgement", new LicenseData(licenseID: "zlib-acknowledgement", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ZPL-1.1", new LicenseData(licenseID: "ZPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ZPL-2.0", new LicenseData(licenseID: "ZPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ZPL-2.1", new LicenseData(licenseID: "ZPL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
        };

        public static readonly IReadOnlyDictionary<string, ExceptionData> ExceptionList = new Dictionary<string, ExceptionData>()
        {
            { "389-exception", new ExceptionData(licenseID: "389-exception", isDeprecatedLicenseId: false) },
            { "Asterisk-exception", new ExceptionData(licenseID: "Asterisk-exception", isDeprecatedLicenseId: false) },
            { "Asterisk-linking-protocols-exception", new ExceptionData(licenseID: "Asterisk-linking-protocols-exception", isDeprecatedLicenseId: false) },
            { "Autoconf-exception-2.0", new ExceptionData(licenseID: "Autoconf-exception-2.0", isDeprecatedLicenseId: false) },
            { "Autoconf-exception-3.0", new ExceptionData(licenseID: "Autoconf-exception-3.0", isDeprecatedLicenseId: false) },
            { "Autoconf-exception-generic", new ExceptionData(licenseID: "Autoconf-exception-generic", isDeprecatedLicenseId: false) },
            { "Autoconf-exception-generic-3.0", new ExceptionData(licenseID: "Autoconf-exception-generic-3.0", isDeprecatedLicenseId: false) },
            { "Autoconf-exception-macro", new ExceptionData(licenseID: "Autoconf-exception-macro", isDeprecatedLicenseId: false) },
            { "Bison-exception-1.24", new ExceptionData(licenseID: "Bison-exception-1.24", isDeprecatedLicenseId: false) },
            { "Bison-exception-2.2", new ExceptionData(licenseID: "Bison-exception-2.2", isDeprecatedLicenseId: false) },
            { "Bootloader-exception", new ExceptionData(licenseID: "Bootloader-exception", isDeprecatedLicenseId: false) },
            { "CGAL-linking-exception", new ExceptionData(licenseID: "CGAL-linking-exception", isDeprecatedLicenseId: false) },
            { "Classpath-exception-2.0", new ExceptionData(licenseID: "Classpath-exception-2.0", isDeprecatedLicenseId: false) },
            { "CLISP-exception-2.0", new ExceptionData(licenseID: "CLISP-exception-2.0", isDeprecatedLicenseId: false) },
            { "cryptsetup-OpenSSL-exception", new ExceptionData(licenseID: "cryptsetup-OpenSSL-exception", isDeprecatedLicenseId: false) },
            { "Digia-Qt-LGPL-exception-1.1", new ExceptionData(licenseID: "Digia-Qt-LGPL-exception-1.1", isDeprecatedLicenseId: false) },
            { "DigiRule-FOSS-exception", new ExceptionData(licenseID: "DigiRule-FOSS-exception", isDeprecatedLicenseId: false) },
            { "eCos-exception-2.0", new ExceptionData(licenseID: "eCos-exception-2.0", isDeprecatedLicenseId: false) },
            { "erlang-otp-linking-exception", new ExceptionData(licenseID: "erlang-otp-linking-exception", isDeprecatedLicenseId: false) },
            { "Fawkes-Runtime-exception", new ExceptionData(licenseID: "Fawkes-Runtime-exception", isDeprecatedLicenseId: false) },
            { "FLTK-exception", new ExceptionData(licenseID: "FLTK-exception", isDeprecatedLicenseId: false) },
            { "fmt-exception", new ExceptionData(licenseID: "fmt-exception", isDeprecatedLicenseId: false) },
            { "Font-exception-2.0", new ExceptionData(licenseID: "Font-exception-2.0", isDeprecatedLicenseId: false) },
            { "freertos-exception-2.0", new ExceptionData(licenseID: "freertos-exception-2.0", isDeprecatedLicenseId: false) },
            { "GCC-exception-2.0", new ExceptionData(licenseID: "GCC-exception-2.0", isDeprecatedLicenseId: false) },
            { "GCC-exception-2.0-note", new ExceptionData(licenseID: "GCC-exception-2.0-note", isDeprecatedLicenseId: false) },
            { "GCC-exception-3.1", new ExceptionData(licenseID: "GCC-exception-3.1", isDeprecatedLicenseId: false) },
            { "Gmsh-exception", new ExceptionData(licenseID: "Gmsh-exception", isDeprecatedLicenseId: false) },
            { "GNAT-exception", new ExceptionData(licenseID: "GNAT-exception", isDeprecatedLicenseId: false) },
            { "GNOME-examples-exception", new ExceptionData(licenseID: "GNOME-examples-exception", isDeprecatedLicenseId: false) },
            { "GNU-compiler-exception", new ExceptionData(licenseID: "GNU-compiler-exception", isDeprecatedLicenseId: false) },
            { "gnu-javamail-exception", new ExceptionData(licenseID: "gnu-javamail-exception", isDeprecatedLicenseId: false) },
            { "GPL-3.0-389-ds-base-exception", new ExceptionData(licenseID: "GPL-3.0-389-ds-base-exception", isDeprecatedLicenseId: false) },
            { "GPL-3.0-interface-exception", new ExceptionData(licenseID: "GPL-3.0-interface-exception", isDeprecatedLicenseId: false) },
            { "GPL-3.0-linking-exception", new ExceptionData(licenseID: "GPL-3.0-linking-exception", isDeprecatedLicenseId: false) },
            { "GPL-3.0-linking-source-exception", new ExceptionData(licenseID: "GPL-3.0-linking-source-exception", isDeprecatedLicenseId: false) },
            { "GPL-CC-1.0", new ExceptionData(licenseID: "GPL-CC-1.0", isDeprecatedLicenseId: false) },
            { "GStreamer-exception-2005", new ExceptionData(licenseID: "GStreamer-exception-2005", isDeprecatedLicenseId: false) },
            { "GStreamer-exception-2008", new ExceptionData(licenseID: "GStreamer-exception-2008", isDeprecatedLicenseId: false) },
            { "harbour-exception", new ExceptionData(licenseID: "harbour-exception", isDeprecatedLicenseId: false) },
            { "i2p-gpl-java-exception", new ExceptionData(licenseID: "i2p-gpl-java-exception", isDeprecatedLicenseId: false) },
            { "Independent-modules-exception", new ExceptionData(licenseID: "Independent-modules-exception", isDeprecatedLicenseId: false) },
            { "KiCad-libraries-exception", new ExceptionData(licenseID: "KiCad-libraries-exception", isDeprecatedLicenseId: false) },
            { "LGPL-3.0-linking-exception", new ExceptionData(licenseID: "LGPL-3.0-linking-exception", isDeprecatedLicenseId: false) },
            { "libpri-OpenH323-exception", new ExceptionData(licenseID: "libpri-OpenH323-exception", isDeprecatedLicenseId: false) },
            { "Libtool-exception", new ExceptionData(licenseID: "Libtool-exception", isDeprecatedLicenseId: false) },
            { "Linux-syscall-note", new ExceptionData(licenseID: "Linux-syscall-note", isDeprecatedLicenseId: false) },
            { "LLGPL", new ExceptionData(licenseID: "LLGPL", isDeprecatedLicenseId: false) },
            { "LLVM-exception", new ExceptionData(licenseID: "LLVM-exception", isDeprecatedLicenseId: false) },
            { "LZMA-exception", new ExceptionData(licenseID: "LZMA-exception", isDeprecatedLicenseId: false) },
            { "mif-exception", new ExceptionData(licenseID: "mif-exception", isDeprecatedLicenseId: false) },
            { "mxml-exception", new ExceptionData(licenseID: "mxml-exception", isDeprecatedLicenseId: false) },
            { "Nokia-Qt-exception-1.1", new ExceptionData(licenseID: "Nokia-Qt-exception-1.1", isDeprecatedLicenseId: true) },
            { "OCaml-LGPL-linking-exception", new ExceptionData(licenseID: "OCaml-LGPL-linking-exception", isDeprecatedLicenseId: false) },
            { "OCCT-exception-1.0", new ExceptionData(licenseID: "OCCT-exception-1.0", isDeprecatedLicenseId: false) },
            { "OpenJDK-assembly-exception-1.0", new ExceptionData(licenseID: "OpenJDK-assembly-exception-1.0", isDeprecatedLicenseId: false) },
            { "openvpn-openssl-exception", new ExceptionData(licenseID: "openvpn-openssl-exception", isDeprecatedLicenseId: false) },
            { "PCRE2-exception", new ExceptionData(licenseID: "PCRE2-exception", isDeprecatedLicenseId: false) },
            { "polyparse-exception", new ExceptionData(licenseID: "polyparse-exception", isDeprecatedLicenseId: false) },
            { "PS-or-PDF-font-exception-20170817", new ExceptionData(licenseID: "PS-or-PDF-font-exception-20170817", isDeprecatedLicenseId: false) },
            { "QPL-1.0-INRIA-2004-exception", new ExceptionData(licenseID: "QPL-1.0-INRIA-2004-exception", isDeprecatedLicenseId: false) },
            { "Qt-GPL-exception-1.0", new ExceptionData(licenseID: "Qt-GPL-exception-1.0", isDeprecatedLicenseId: false) },
            { "Qt-LGPL-exception-1.1", new ExceptionData(licenseID: "Qt-LGPL-exception-1.1", isDeprecatedLicenseId: false) },
            { "Qwt-exception-1.0", new ExceptionData(licenseID: "Qwt-exception-1.0", isDeprecatedLicenseId: false) },
            { "romic-exception", new ExceptionData(licenseID: "romic-exception", isDeprecatedLicenseId: false) },
            { "RRDtool-FLOSS-exception-2.0", new ExceptionData(licenseID: "RRDtool-FLOSS-exception-2.0", isDeprecatedLicenseId: false) },
            { "SANE-exception", new ExceptionData(licenseID: "SANE-exception", isDeprecatedLicenseId: false) },
            { "SHL-2.0", new ExceptionData(licenseID: "SHL-2.0", isDeprecatedLicenseId: false) },
            { "SHL-2.1", new ExceptionData(licenseID: "SHL-2.1", isDeprecatedLicenseId: false) },
            { "stunnel-exception", new ExceptionData(licenseID: "stunnel-exception", isDeprecatedLicenseId: false) },
            { "SWI-exception", new ExceptionData(licenseID: "SWI-exception", isDeprecatedLicenseId: false) },
            { "Swift-exception", new ExceptionData(licenseID: "Swift-exception", isDeprecatedLicenseId: false) },
            { "Texinfo-exception", new ExceptionData(licenseID: "Texinfo-exception", isDeprecatedLicenseId: false) },
            { "u-boot-exception-2.0", new ExceptionData(licenseID: "u-boot-exception-2.0", isDeprecatedLicenseId: false) },
            { "UBDL-exception", new ExceptionData(licenseID: "UBDL-exception", isDeprecatedLicenseId: false) },
            { "Universal-FOSS-exception-1.0", new ExceptionData(licenseID: "Universal-FOSS-exception-1.0", isDeprecatedLicenseId: false) },
            { "vsftpd-openssl-exception", new ExceptionData(licenseID: "vsftpd-openssl-exception", isDeprecatedLicenseId: false) },
            { "WxWindows-exception-3.1", new ExceptionData(licenseID: "WxWindows-exception-3.1", isDeprecatedLicenseId: false) },
            { "x11vnc-openssl-exception", new ExceptionData(licenseID: "x11vnc-openssl-exception", isDeprecatedLicenseId: false) },
        };
    }

    public class LicenseData
    {
        public LicenseData(string licenseID, bool isOsiApproved, bool isDeprecatedLicenseId, bool isFsfLibre)
        {
            LicenseID = licenseID;
            IsOsiApproved = isOsiApproved;
            IsDeprecatedLicenseId = isDeprecatedLicenseId;
            IsFsfLibre = isFsfLibre;
        }

        public string LicenseID { get; }

        public bool IsOsiApproved { get; }

        public bool IsDeprecatedLicenseId { get; }

        public bool IsFsfLibre { get; }
    }

    public class ExceptionData
    {
        public ExceptionData(string licenseID, bool isDeprecatedLicenseId)
        {
            LicenseExceptionID = licenseID;
            IsDeprecatedLicenseId = isDeprecatedLicenseId;
        }

        public string LicenseExceptionID { get; }

        public bool IsDeprecatedLicenseId { get; }
    }
}
