/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import translate.Translate;

public class SearchForm
extends List
implements CommandListener,
DiscoveryListener {
    private Controller controller;
    private Command exitCommand;
    private Command connectCommand;
    private Command searchCommand;
    private Command lastUsedCommand;
    private int foundDevicesCount;
    private RemoteDevice[] foundDevices;
    private Translate t = Translate.getInstance();
    private Vector serviceList = new Vector();

    public SearchForm(Controller controller) {
        super("Search", 3);
        this.controller = controller;
        this.setCommandListener(this);
        this.connectCommand = new Command(Translate.get("Connect"), 8, 2);
        this.exitCommand = new Command(Translate.get("Exit"), 7, 1);
        this.addCommand(this.exitCommand);
        this.searchCommand = new Command(Translate.get("Search"), 1, 1);
        this.setSelectCommand(this.connectCommand);
        this.foundDevices = new RemoteDevice[7];
        this.startSearch();
    }

    void setStatusText(String string) {
        this.setTitle(string);
    }

    void startSearch() {
        Object object;
        this.removeCommand(this.searchCommand);
        this.foundDevicesCount = 0;
        this.deleteAll();
        this.serviceList.removeAllElements();
        this.setStatusText(Translate.get("Searching for devices..."));
        String string = this.controller.getSettings().getLastUsedDeviceURL();
        String string2 = this.controller.getSettings().getLastUsedDeviceName();
        if (string != null && string2 != null) {
            object = new ServiceInfo();
            object.connectURL = string;
            object.name = string2;
            this.addInfo((ServiceInfo)object);
        }
        try {
            object = LocalDevice.getLocalDevice().getDiscoveryAgent();
            UUID[] uUIDArray = new UUID[]{new UUID("1101", true)};
            object.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException bluetoothStateException) {
            bluetoothStateException.printStackTrace();
            this.setStatusText(Translate.get("Error - stopped"));
            this.addCommand(this.searchCommand);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.controller.exit();
        } else if (command == this.connectCommand) {
            if (this.getSelectedIndex() >= 0) {
                ServiceInfo serviceInfo = (ServiceInfo)this.serviceList.elementAt(this.getSelectedIndex());
                this.controller.connectTo(serviceInfo.connectURL, serviceInfo.name);
            }
        } else if (command == this.searchCommand) {
            this.startSearch();
        }
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (this.foundDevicesCount < this.foundDevices.length) {
            this.foundDevices[this.foundDevicesCount] = remoteDevice;
            ++this.foundDevicesCount;
            if (this.foundDevicesCount == 1) {
                this.setStatusText("" + this.foundDevicesCount + " " + Translate.get("device. Searching..."));
            } else {
                this.setStatusText("" + this.foundDevicesCount + " " + Translate.get("devices. Searching..."));
            }
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        for (int i = 0; i < serviceRecordArray.length; ++i) {
            String string = serviceRecordArray[i].getConnectionURL(0, false);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.connectURL = string;
            String string2 = null;
            try {
                String string3 = serviceRecordArray[i].getHostDevice().getFriendlyName(false);
                if (string3 != null && string3.length() > 0) {
                    string2 = string3;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            int n2 = 0;
            int n3 = 256;
            DataElement dataElement = serviceRecordArray[i].getAttributeValue(n3 + n2);
            String string4 = null;
            if (dataElement != null && dataElement.getDataType() == 32) {
                string4 = (String)dataElement.getValue();
            }
            serviceInfo.name = string2 != null && string4 != null ? string2 + " - " + string4 : (string2 != null ? string2 : (string4 != null ? serviceRecordArray[i].getHostDevice().getBluetoothAddress() + "/" + string4 : "???"));
            this.addInfo(serviceInfo);
            this.setStatusText(Translate.get("Freevused server found. Searching..."));
        }
    }

    void addInfo(ServiceInfo serviceInfo) {
        boolean bl = false;
        for (int i = 0; i < this.serviceList.size(); ++i) {
            ServiceInfo serviceInfo2 = (ServiceInfo)this.serviceList.elementAt(i);
            if (!serviceInfo2.equals(serviceInfo)) continue;
            bl = true;
        }
        if (!bl) {
            this.serviceList.addElement(serviceInfo);
            this.append(serviceInfo.name, null);
        }
    }

    public void serviceSearchCompleted(int n, int n2) {
        this.setStatusText(Translate.get("Done."));
        this.searchNextDeviceForServices();
    }

    void searchNextDeviceForServices() {
        if (this.foundDevicesCount > 0) {
            --this.foundDevicesCount;
            RemoteDevice remoteDevice = this.foundDevices[this.foundDevicesCount];
            this.foundDevices[this.foundDevicesCount] = null;
            try {
                DiscoveryAgent discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
                UUID[] uUIDArray = new UUID[]{new UUID("1101", true)};
                int[] nArray = new int[]{256};
                this.setStatusText(Translate.get("Retrieving service list..."));
                discoveryAgent.searchServices(nArray, uUIDArray, remoteDevice, (DiscoveryListener)this);
            }
            catch (BluetoothStateException bluetoothStateException) {
                bluetoothStateException.printStackTrace();
                this.setStatusText(Translate.get("Error - stopped."));
            }
        } else {
            this.addCommand(this.searchCommand);
        }
    }

    public void inquiryCompleted(int n) {
        this.setStatusText(Translate.get("Done."));
        this.searchNextDeviceForServices();
    }

    class ServiceInfo {
        public String connectURL;
        public String name;

        ServiceInfo() {
        }

        public boolean equals(Object object) {
            ServiceInfo serviceInfo = (ServiceInfo)object;
            return this.connectURL.equals(serviceInfo.connectURL) && this.name.equals(serviceInfo.name);
        }
    }
}

