//go:build ignore

package main

import (
	"bytes"
	"fmt"
	"log"
	"os"
)

func generateDecodeMap() [256]byte {
	const alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"

	var decodeMap [256]byte
	for i := 0; i < len(decodeMap); i++ {
		decodeMap[i] = 0xff
	}

	for i := 0; i < len(alphabet); i++ {
		decodeMap[alphabet[i]] = byte(i)
	}

	// for URL encoding
	decodeMap['-'] = decodeMap['+']
	decodeMap['_'] = decodeMap['/']

	return decodeMap
}

func main() {
	f, err := os.OpenFile("decode_map.go", os.O_WRONLY|os.O_CREATE|os.O_TRUNC, 0644)
	if err != nil {
		log.Fatal(err)
	}
	m := generateDecodeMap()
	var b bytes.Buffer
	fmt.Fprintf(&b, "// Code generated by generate_decode_map.go. DO NOT EDIT.\n\n")
	fmt.Fprintf(&b, "package base64dec\n\n")
	fmt.Fprintf(&b, "var decodeMap = [256]byte{")
	for i, v := range m {
		if i%16 == 0 {
			fmt.Fprintf(&b, "\n\t")
		} else {
			fmt.Fprint(&b, " ")
		}
		fmt.Fprintf(&b, "0x%02x,", v)
	}
	fmt.Fprintf(&b, "\n}\n")
	_, err = f.Write(b.Bytes())
	if err != nil {
		log.Fatal(err)
	}
	err = f.Close()
	if err != nil {
		log.Fatal(err)
	}
}
