; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=tsan -S | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK-EXC
; RUN: opt < %s -passes=tsan -S -tsan-handle-cxx-exceptions=0 | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK-NOEXC

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

declare void @can_throw()
declare void @cannot_throw() nounwind

define i32 @func1() sanitize_thread {
; CHECK-EXC-LABEL: define i32 @func1
; CHECK-EXC-SAME: () #[[ATTR1:[0-9]+]] personality ptr @__gcc_personality_v0 {
; CHECK-EXC-NEXT:    [[TMP1:%.*]] = call ptr @llvm.returnaddress(i32 0)
; CHECK-EXC-NEXT:    call void @__tsan_func_entry(ptr [[TMP1]])
; CHECK-EXC-NEXT:    invoke void @can_throw()
; CHECK-EXC-NEXT:    to label [[DOTNOEXC:%.*]] unwind label [[TSAN_CLEANUP:%.*]]
; CHECK-EXC:       .noexc:
; CHECK-EXC-NEXT:    call void @__tsan_func_exit()
; CHECK-EXC-NEXT:    ret i32 0
; CHECK-EXC:       tsan_cleanup:
; CHECK-EXC-NEXT:    [[CLEANUP_LPAD:%.*]] = landingpad { ptr, i32 }
; CHECK-EXC-NEXT:    cleanup
; CHECK-EXC-NEXT:    call void @__tsan_func_exit()
; CHECK-EXC-NEXT:    resume { ptr, i32 } [[CLEANUP_LPAD]]
;
; CHECK-NOEXC-LABEL: define i32 @func1
; CHECK-NOEXC-SAME: () #[[ATTR1:[0-9]+]] {
; CHECK-NOEXC-NEXT:    [[TMP1:%.*]] = call ptr @llvm.returnaddress(i32 0)
; CHECK-NOEXC-NEXT:    call void @__tsan_func_entry(ptr [[TMP1]])
; CHECK-NOEXC-NEXT:    call void @can_throw()
; CHECK-NOEXC-NEXT:    call void @__tsan_func_exit()
; CHECK-NOEXC-NEXT:    ret i32 0
;
  call void @can_throw()
  ret i32 0
}

define i32 @func2() sanitize_thread {
; CHECK-LABEL: define i32 @func2
; CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.returnaddress(i32 0)
; CHECK-NEXT:    call void @__tsan_func_entry(ptr [[TMP1]])
; CHECK-NEXT:    call void @cannot_throw()
; CHECK-NEXT:    call void @__tsan_func_exit()
; CHECK-NEXT:    ret i32 0
;
  call void @cannot_throw()
  ret i32 0
}

define i32 @func3(ptr %p) sanitize_thread {
; CHECK-LABEL: define i32 @func3
; CHECK-SAME: (ptr [[P:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.returnaddress(i32 0)
; CHECK-NEXT:    call void @__tsan_func_entry(ptr [[TMP1]])
; CHECK-NEXT:    call void @__tsan_read4(ptr [[P]])
; CHECK-NEXT:    [[A:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @__tsan_func_exit()
; CHECK-NEXT:    ret i32 [[A]]
;
  %a = load i32, ptr %p
  ret i32 %a
}

define i32 @func4() sanitize_thread nounwind {
; CHECK-LABEL: define i32 @func4
; CHECK-SAME: () #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.returnaddress(i32 0)
; CHECK-NEXT:    call void @__tsan_func_entry(ptr [[TMP1]])
; CHECK-NEXT:    call void @can_throw()
; CHECK-NEXT:    call void @__tsan_func_exit()
; CHECK-NEXT:    ret i32 0
;
  call void @can_throw()
  ret i32 0
}
