# -*- perl -*-
# generated by perlify.pl from libsbml/src/sbml/test/TestWriteSBML.cpp
# followed by little human processing to fix syntactic specialties
# perify.pl is unable to handle right now =;) xtof
use Test::More;
BEGIN { plan tests => 55 }; 

use LibSBML;
use strict;
#########################

# EXPAT = 1; LIBXML = 2;  XERCES = 3;
my $XML_PARSER = 2;

test_ReadSBML_SBML();
test_ReadSBML_Model();
test_ReadSBML_FunctionDefinition();
test_ReadSBML_UnitDefinition();
test_ReadSBML_Unit();
test_ReadSBML_Compartment();
test_ReadSBML_Species();

#---
sub readSBMLFromString {
 my $s = shift;
 my $rd = new LibSBML::SBMLReader;
 $rd->readSBMLFromString($s);
}

#---
sub SBML_HEADER_L3v1 {
 "<sbml xmlns='http://www.sbml.org/sbml/level3/version1/core' level='3' version='1'> <model name='m'>\n";
}

#---
sub XML_HEADER {
 "<?xml version='1.0' encoding='UTF-8'?>\n";
}

#---
sub SBML_FOOTER {
 "</model> </sbml>";
}

#---
sub wrapSBML_L3v1 {
 XML_HEADER() . SBML_HEADER_L3v1() . $_[0] . SBML_FOOTER();
}

#---
sub wrapXML {
 XML_HEADER() . $_[0];
}

#---
sub test_ReadSBML_SBML {
 my $s = wrapXML("<sbml level='3' version='1'> </sbml>");
 my $D = readSBMLFromString($s);
 ok( $D->getLevel() == 3 );
 ok( $D->getVersion() == 1 );
}

#---
sub test_ReadSBML_Model {
 my $s = wrapXML("<sbml level='3' version='1'>" . 
                 "  <model id='testModel'></model>" . 
                 "</sbml>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getId() eq "testModel" );
}

#---
sub test_ReadSBML_FunctionDefinition {
 my $s = wrapSBML_L3v1("<listOfFunctionDefinitions>" . 
                       "  <functionDefinition id='pow3' name='cubed'>" . 
                       "    <math>" . 
                       "      <lambda>" . 
                       "        <bvar><ci> x </ci></bvar>" . 
                       "        <apply>" . 
                       "          <power/>" . 
                       "          <ci> x </ci>" . 
                       "          <cn> 3 </cn>" . 
                       "        </apply>" . 
                       "      </lambda>" . 
                       "    </math>" . 
                       "  </functionDefinition>" . 
                       "</listOfFunctionDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumFunctionDefinitions() == 1 );
 my $fd = $M->getFunctionDefinition(0);
 ok( defined $fd );
 ok( $fd->isSetId() == 1 );
 ok( $fd->isSetName() == 1 );
 ok( $fd->getId() eq "pow3" );
 ok( $fd->getName() eq "cubed" );
 ok( $fd->isSetMath() == 1 );
 my $math = $fd->getMath();
 my $formula = $math->formulaToString();
 ok( defined $formula );
 ok( $formula eq "lambda(x, pow(x, 3))" );
}

#---
sub test_ReadSBML_UnitDefinition {
 my $s = wrapSBML_L3v1("<listOfUnitDefinitions>" . 
                       "  <unitDefinition id='mmls' name='mmol/ls'/>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumUnitDefinitions() == 1 );
 my $ud = $M->getUnitDefinition(0);
 ok( $ud->isSetId() == 1 );
 ok( $ud->isSetName() == 1 );
 ok( $ud->getId() eq "mmls" );
 ok( $ud->getName() eq "mmol/ls" );
}

#---
sub test_ReadSBML_Unit {
 my $s = wrapSBML_L3v1("<listOfUnitDefinitions>" . 
                       "  <unitDefinition id='Fahrenheit'>" . 
                       "    <listOfUnits>" . 
                       "      <unit kind='mole' multiplier='1.8' scale='32' exponent='2.2'/>" . 
                       "    </listOfUnits>" . 
                       "  </unitDefinition>" . 
                       "</listOfUnitDefinitions>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumUnitDefinitions() == 1 );
 my $ud = $M->getUnitDefinition(0);
 ok( $ud->isSetId() == 1 );
 ok( $ud->getId() eq "Fahrenheit" );
 ok( $ud->getNumUnits() == 1 );
 my $u = $ud->getUnit(0);
 ok( $u->getKind() == $LibSBML::UNIT_KIND_MOLE );
 ok( $u->getExponentAsDouble() == 2.2 );
 ok( $u->getScale() == 32 );
 ok( $u->getMultiplier() == 1.8 );
}

#---
sub test_ReadSBML_Compartment {
 my $s = wrapSBML_L3v1("<listOfCompartments>" . 
                       "  <compartment id='membrane' size='.3' spatialDimensions='2.1'" . 
                       "               units='area' constant='false'/>" . 
                       "</listOfCompartments>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumCompartments() == 1 );
 my $c = $M->getCompartment(0);
 ok( $c->isSetId() == 1 );
 ok( $c->isSetName() == 0 );
 ok( $c->isSetVolume() == 1 );
 ok( $c->isSetSize() == 1 );
 ok( $c->isSetUnits() == 1 );
 ok( $c->isSetConstant() == 1);
 ok( $c->getId() eq "membrane" );
 ok( $c->getUnits() eq "area" );
 ok( $c->getSpatialDimensionsAsDouble() == 2.1 );
 ok( $c->getSize() == .3 );
 ok( $c->getConstant() == 0);
}

#---
sub test_ReadSBML_Species {
 my $s = wrapSBML_L3v1("<listOfSpecies>" . 
                       "  <species id='Glucose' compartment='cell' initialConcentration='4.1'" . 
                       "           substanceUnits='item' conversionFactor='p'". 
                       "           boundaryCondition='true' hasOnlySubstanceUnits='false' constant='true'/>" . 
                       "</listOfSpecies>");
 my $D = readSBMLFromString($s);
 my $M = $D->getModel();
 ok( $M->getNumSpecies() == 1 );
 my $sp = $M->getSpecies(0);
 ok( $sp->isSetId() == 1 );
 ok( $sp->isSetName() == 0 );
 ok( $sp->isSetCompartment() == 1 );
 ok( $sp->isSetInitialAmount() == 0 );
 ok( $sp->isSetInitialConcentration() == 1 );
 ok( $sp->isSetHasOnlySubstanceUnits() == 1 );
 ok( $sp->isSetBoundaryCondition() == 1 );
 ok( $sp->isSetConstant() == 1 );
 ok( $sp->isSetConversionFactor() == 1 );
 ok( $sp->getId() eq "Glucose" );
 ok( $sp->getCompartment() eq "cell" );
 ok( $sp->getSubstanceUnits() eq "item" );
 ok( $sp->getInitialConcentration() == 4.1 );
 ok( $sp->getHasOnlySubstanceUnits() == 0 );
 ok( $sp->getBoundaryCondition() == 1 );
 ok( $sp->getConstant() == 1 );
 ok( $sp->getConversionFactor() eq "p" );
}

