/*
    SPDX-FileCopyrightText: 2023 Fushan Wen <qydwhotmail@gmail.com>

    SPDX-License-Identifier: GPL-2.0-or-later
*/

pragma ComponentBehavior: Bound

import QtQuick

import org.kde.plasma.plasmoid
import org.kde.kirigami as Kirigami
import org.kde.plasma.components as PlasmaComponents
import org.kde.plasma.extras as PlasmaExtras
import org.kde.pipewire.monitor as Monitor

PlasmaComponents.Page {
    implicitWidth: root.switchWidth
    implicitHeight: root.switchHeight

    PlasmaExtras.PlaceholderMessage {
        anchors.centerIn: parent

        visible: monitor.count === 0
        width: parent.width - (Kirigami.Units.gridUnit * 4)
        iconName: Plasmoid.icon
        text: root.toolTipSubText;
    }

    Repeater {
        model: monitor

        PlasmaExtras.PlaceholderMessage {
            anchors.centerIn: parent

            required property string display
            required property var model

            visible: monitor.count === 1
            width: parent.width - (Kirigami.Units.gridUnit * 4)
            iconName: Plasmoid.icon
            text: {
                if (model.state === Monitor.NodeState.Running && display) {
                    return i18nc("@info:status %1 camera name", "%1 is in use", display);
                }
                return root.toolTipSubText;
            }
        }
    }


    PlasmaComponents.ScrollView {
        anchors.fill: parent
        contentWidth: availableWidth - (contentItem as ListView).leftMargin - (contentItem as ListView).rightMargin
        focus: true

        contentItem: ListView {
            id: cameraList

            focus: visible
            model: monitor

            visible: count > 1

            delegate: PlasmaExtras.ExpandableListItem {
                required property string display
                required property var model

                // TODO: switch to PlasmaExtras.ListItem once it has subtitle
                icon: switch (model.state) {
                case Monitor.NodeState.Running:
                    return "camera-on-symbolic";
                case Monitor.NodeState.Idle:
                    return "camera-ready-symbolic";
                default:
                    return "camera-off-symbolic";
                }
                title: display || i18nc("@title", "Camera")
                subtitle: switch (model.state) {
                case Monitor.NodeState.Running:
                    return i18nc("@info:status", "Active");
                case Monitor.NodeState.Idle:
                    return i18nc("@info:status", "Idle");
                case Monitor.NodeState.Error:
                    return i18nc("@info:status", "Error");
                case Monitor.NodeState.Creating:
                    return i18nc("@info:status", "Creating");
                case Monitor.NodeState.Suspended:
                    return i18nc("@info:status", "Suspended");
                default:
                    return i18nc("@info:status", "Unknown");
                }
            }
        }
    }
}
