% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sample_n}
\alias{sample_n}
\alias{sample_frac}
\title{Sample n rows from a table}
\usage{
sample_n(tbl, size, replace = FALSE, weight = NULL, .env = NULL, ...)

sample_frac(tbl, size = 1, replace = FALSE, weight = NULL, .env = NULL, ...)
}
\arguments{
\item{tbl}{A data.frame.}

\item{size}{<\code{\link[=dplyr_tidy_select]{tidy-select}}>
For \code{sample_n()}, the number of rows to select.
For \code{sample_frac()}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}

\item{.env}{DEPRECATED.}

\item{...}{ignored}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
\code{sample_n()} and \code{sample_frac()} have been superseded in favour of
\code{\link[=slice_sample]{slice_sample()}}. While they will not be deprecated in the near future,
retirement means that we will only perform critical bug fixes, so we recommend
moving to the newer alternative.

These functions were superseded because we realised it was more convenient to
have two mutually exclusive arguments to one function, rather than two
separate functions. This also made it to clean up a few other smaller
design issues with \code{sample_n()}/\code{sample_frac}:
\itemize{
\item The connection to \code{slice()} was not obvious.
\item The name of the first argument, \code{tbl}, is inconsistent with other
single table verbs which use \code{.data}.
\item The \code{size} argument uses tidy evaluation, which is surprising and
undocumented.
\item It was easier to remove the deprecated \code{.env} argument.
\item \code{...} was in a suboptimal position.
}
}
\examples{
df <- tibble(x = 1:5, w = c(0.1, 0.1, 0.1, 2, 2))

# sample_n() -> slice_sample() ----------------------------------------------
# Was:
sample_n(df, 3)
sample_n(df, 10, replace = TRUE)
sample_n(df, 3, weight = w)

# Now:
slice_sample(df, n = 3)
slice_sample(df, n = 10, replace = TRUE)
slice_sample(df, n = 3, weight_by = w)

# Note that sample_n() would error if n was bigger than the group size
# slice_sample() will just use the available rows for consistency with
# the other slice helpers like slice_head()
try(sample_n(df, 10))
slice_sample(df, n = 10)

# sample_frac() -> slice_sample() -------------------------------------------
# Was:
sample_frac(df, 0.25)
sample_frac(df, 2, replace = TRUE)

# Now:
slice_sample(df, prop = 0.25)
slice_sample(df, prop = 2, replace = TRUE)
}
\keyword{internal}
